#include "genxyz.h"
#include "mcgen.h"

//========== method write_xyz ==========

int GENXYZ::write_xyz(const string _filename)
{
SYSUTILS tmp;
FILE *file;

//logfile.print("<write xyz: %d atoms>",size());
file=tmp.open_file(_filename,"w");
write_file(file);
tmp.close_file(file);
return 0;
}

//========== method write_history ==========

int GENXYZ::write_history(const string _filename)
{
SYSUTILS tmp;
FILE *file;

file=tmp.open_file(_filename,"a");
fprintf(file,"TIME %ld\n",params->get_triesdone());
write_file(file);
tmp.close_file(file);
return 0;
}

//========== method write_file ==========

int GENXYZ::write_file(FILE *_file)
{
int atomscount=0;

// 1st line: number of atoms following
fprintf(_file,"%zd\n",size());
// 2nd line: molecule name
fprintf(_file,"%s",params->get_header()->c_str());
for (list<ATOM*>::iterator it=begin(); it!=end(); ++it)
{
	assert(*it!=0);
	ATOM &a=**it;
	UNIT *u=a.get_unit();
	if (! a.get_has_coords())
		assert(false);
	assert(a.get_has_coords());
	fprintf(_file,
			"%4s %12.5lf %12.5lf %12.5lf # %5d %3d/%04d/%02d\n",
			a.get_label(),
			a.get_xcoord(),
			a.get_ycoord(),
			a.get_zcoord(),
			++atomscount,
			u->get_chain()->get_chainid(),
			u->get_distance_from_chainbegin()+1,
			a.get_index()
	       );
}

// last line: unit cell parameters
write_unitcell_matrix(_file);
return 0;
}

//========== static method write_listed_coords ==========

int GENXYZ::write_listed_coords(const string _filename, const set<ATOM*> _atoms)
{
SYSUTILS tmp;
FILE *file;
int atomscount=0;

file=tmp.open_file(_filename,"w");
fprintf(file,"%d\n",(int)_atoms.size());
fprintf(file,"%s",params->get_header()->c_str());

// Cycle through all given atoms
set<ATOM*>::iterator a, end;
for (a=_atoms.begin(),end=_atoms.end();a!=end;a++)
{
	assert(*a!=0);
	assert((*a)->get_has_coords());
	fprintf(file,
		"%4s %12.5lf %12.5lf %12.5lf # %5d %s/%02d\n",
		(*a)->get_label(),
		(*a)->get_xcoord(),
		(*a)->get_ycoord(),
		(*a)->get_zcoord(),
		++atomscount,
		(*a)->get_unit()->get_unitid()->to_c_str(),
	        (*a)->get_index()
	       );
}
write_unitcell_matrix(file);
tmp.close_file(file);

return 0;
}

//========== method write_unitcell_matrix ==========

int GENXYZ::write_unitcell_matrix(FILE *_file)
{
if ((params->get_cell(1,2)==0) && (params->get_cell(2,1)==0)
        && (params->get_cell(1,3)==0) && (params->get_cell(3,1)==0)
        && (params->get_cell(2,3)==0) && (params->get_cell(3,2)==0))
fprintf(_file,"UNCP %lf %lf %lf 90 90 90\n",
        params->get_cell(1,1),
        params->get_cell(2,2),
        params->get_cell(3,3));
else
fprintf(_file,"UNC %lf %lf %lf %lf %lf %lf %lf %lf %lf\n",
        params->get_cell(1,1), params->get_cell(1,2), params->get_cell(1,3),
        params->get_cell(2,1), params->get_cell(2,2), params->get_cell(2,3),
        params->get_cell(3,1), params->get_cell(3,2), params->get_cell(3,3));
return 0;
}

void GENXYZ::push_back(ATOM *x)
{
	assert(x->get_has_coords());
	list<ATOM*>::push_back(x);
}

