#ifndef __GENFIELDOUTINI_H_DEFINE__
#define __GENFIELDOUTINI_H_DEFINE__
#include <stdio.h>
#include <list>
#include "defs.h"
#include "vdw.h"

using namespace std;

struct BOND_OUT //! Holds one BOND line for field output file.
{
	const BONDDEF *bonddef;
	int numatoms;
	int site[4];
	double constlen;
	int repeat, spacing;
};

class UNIT;
class BOND;

class GENFIELDOUTINI //! Stores the whole field output and writes it to the disk.
{
private:
string filename;
string field_filename;
FILE *file;
FILE *f_file;
DEFS *defs;
VDW *vdw;
set<ATOMARG*> used_atomargs;

int push_bond_if_complete(list<BOND_OUT> &_bonds, UNIT *_unit,
		BOND &_bond, int _numatoms);
// If all atoms of the given bond have their coordinates set,
// then insert _bond into the _bonds array.

public:
int set_filename(string _filename);
int set_field_filename(string _filename);
int set_defs(DEFS *_defs);
int set_vdw(VDW *_VDW);
//update();
int write();
int write_defs();
int write_vdw();
int write_field_vdw();
};

#endif

