#include "genfieldoutini.h"
#include "mcgen.h"
#include "bondlist.h"
#include <list>
#include "fieldout2.h"

int GENFIELDOUTINI::write()
{
SYSUTILS tmp;
list<UNIT*> units;
list<ATOM*> atoms;

// SELECT atomarg FROM inited_units
// WHERE atom.has_coordinates INTO used_atomargs;
UNIT::retr_units_outputting_order(-1, units);
UNIT::retr_atoms_outputting_order(units, atoms);

if (atoms.empty())
	return 0;


used_atomargs.clear();
for (list<ATOM*>::iterator atom = atoms.begin();
		atom!=atoms.end(); ++atom)
	used_atomargs.insert((*atom)->get_atomarg());
// used_atomargs is now complete.

file=tmp.open_file(filename,"w");

write_defs();
write_vdw();

fprintf(file,"FIELD\n");
fprintf(file,"%s",params->get_header()->c_str()); // The name of the system

//fprintf(f_file,"%s",params->get_header()->c_str());
//fprintf(f_file,"UNITS kcal\n");
//fprintf(field_file,"\n"); // Optional "neut" line

int preset_exists=UNIT::get_units_outputting_order(0).size()>0 ? 1:0;
//fprintf(file,"MOLECULES %d\n",chains->get_molnr() + preset_exists);
fprintf(file,"MOLECULES %d\n",current_molid);
//fprintf(f_file,"MOLECULES%5d\n",chains->get_molnr() + preset_exists);
for (int molid=1-preset_exists; molid<=current_molid; ++molid)
{
	UNIT::retr_units_outputting_order(molid, units);
	UNIT::retr_atoms_outputting_order(units, atoms);

	list<ATOM*> atoms_for_force(atoms); // copy of atoms

	list<BOND_OUT> consts;
		// TODO insert constraints into consts array
		// When there is a constrant defined for placement,
		// but a parallel bond is missing, then this
		// should be included as a constraint.
	list<BOND_OUT> bonds;
	list<BOND_OUT> angs;
	list<BOND_OUT> dihs;
	list<BOND_OUT> forces;

	while (not atoms_for_force.empty())
	{
		int delta=0;
		int repeat=1;
		bool found=false;
		ATOM *first=atoms_for_force.front();
		atoms_for_force.pop_front();
		list<ATOM*>::iterator second, third;
		for (second = atoms_for_force.begin();
			second!=atoms_for_force.end(); ++second)
		{
			delta=(*second)->get_oid()-first->get_oid();
			if (first->has_similar_forcelist(*second, delta))
			{
				found=true;
				repeat=2;
				third=second;
				++third;
				atoms_for_force.erase(second);
				break;
			}
		}
		if (!found)
			delta=0;
		while (found)
		{
			int next_oid=first->get_oid()+delta*repeat;
			found=false;
			while ((third != atoms_for_force.end()) && ((*third)->get_oid() < next_oid))
				++third;
			if (third == atoms_for_force.end())
				break;
			if ((*third)->get_oid() != next_oid)
				break;
			if (first->has_similar_forcelist(*third, repeat*delta))
			{
				found=true;
				++repeat;
				second=third;
				++second;
				atoms_for_force.erase(third);
				third=second;
			}
		}
		list<BONDINST>::iterator f;
		for (f=first->get_forcelist_begin();
				f != first->get_forcelist_end(); ++f)
		{
			if (f->get_def()->get_potkey() == FIX)
				continue;
			BOND_OUT o=f->to_bond_out();
			o.repeat=repeat;
			o.spacing=delta;
			switch (o.numatoms)
			{
				case 2: bonds.push_back(o); break;
				case 3: angs.push_back(o); break;
				case 4: dihs.push_back(o); break;
				default: assert(false);
			}
		}
		continue;
	}

	// All data collected for the molecule. Write it to files now.
	
	fprintf(file,"Molecule %d\n",molid);
	//fprintf(f_file,"Molecule %d\n",molid);
	fprintf(file,"NUMMOLS 1\n");
	//fprintf(f_file,"NUMMOLS 1\n");

	if (! atoms.empty())
	{
		//fprintf(file,"ATOMGROUPS 1\n");
		fprintf(file,"ATOMS 1\n");
		//fprintf(f_file,"ATOMS %5zu\n",atoms.size());
		for (list<ATOM*>::iterator atom = atoms.begin();
				atom!=atoms.end(); ++atom)
		{
			ATOMARG *aarg=(*atom)->get_atomarg();
			fprintf(file,"ATOM %s 1\n",aarg->get_label());
			//fprintf(f_file,"%-8s%12.6lf%12.6lf%5d\n",
			//	aarg->get_label(),
			//	aarg->get_mass(),
			//	aarg->get_charge(),
			//	1);
		}
	}
		
	//fprintf(file,"SHELLS 0\n");

//	int constgroups=consts.size()>0?1:0;
	//fprintf(file,"CONSTGROUPS %d\n", constgroups);
/*	if (constgroups) // TODO lubada consts
	{
		fprintf(file,"CONSTS %zu\n",consts.size());
		for (list<BOND_OUT>::iterator it = consts.begin();
				it!=consts.end(); ++it)
		{
			fprintf(file,"CONST %d %d %d %d %d\n",
					it->type,
					it->site[0], 1,
					it->site[1], 1);
		}
	}*/

	for (list<BOND_OUT>::iterator it = bonds.begin();
			it!=bonds.end(); ++it)
	{
		fprintf(file,"BONDS %d\n",it->repeat);
		//fprintf(f_file,"BONDS%5d\n",1);
		//const BONDDEF *bdef=it->bonddef;
		fprintf(file,"BOND %s %d %d %d %d\n",
				it->bonddef->get_label().c_str(),
				it->site[0], it->spacing,
				it->site[1], it->spacing);
		//fprintf(f_file,"%-4s%5d%5d%12.6lf%12.6lf%12.6lf%12.6lf\n",
		//		bdef->get_potkey_str(),
		//		it->site[0],
		//		it->site[1],
		//		bdef->get_force(1),
		//		bdef->get_force(2),
		//		bdef->get_force(3),
		//		bdef->get_force(4));
	}

	//fprintf(f_file,"CONSTRAINTS%5zu\n",consts.size());
	//for (list<BOND_OUT>::iterator it = consts.begin();
	//		it!=consts.end(); ++it)
	//{
		//fprintf(f_file,"%5d%5d%12.6lf\n",
		//		it->site[0], it->site[1], it->constlen);
	//}

	//int anggroups=angs.size()>0?1:0;
	for (list<BOND_OUT>::iterator it = angs.begin();
			it!=angs.end(); ++it)
	{
		fprintf(file,"ANGLES %d\n",it->repeat);
		//fprintf(f_file,"ANGLES%5d\n",1);
		//const BONDDEF *bdef=it->bonddef;
		fprintf(file,"ANG %s %d %d %d %d %d %d\n",
				it->bonddef->get_label().c_str(),
				it->site[0], it->spacing,
				it->site[1], it->spacing,
				it->site[2], it->spacing);
		//fprintf(f_file,"%-4s%5d%5d%5d%12.6lf%12.6lf\n",
		//		bdef->get_potkey_str(),
		//		it->site[0],
		//		it->site[1],
		//		it->site[2],
		//		bdef->get_force(1),
		//		bdef->get_force(2));
	}

	//int dihgroups=dihs.size()>0?1:0;
	for (list<BOND_OUT>::iterator it = dihs.begin();
			it!=dihs.end(); ++it)
	{
		fprintf(file,"DIHEDRALS %d\n",it->repeat);
		//fprintf(f_file,"DIHEDRALS%5d\n",1);
		//const BONDDEF *bdef=it->bonddef;
		fprintf(file,"DIH %s %d %d %d %d %d %d %d %d\n",
				it->bonddef->get_label().c_str(),
				it->site[0], it->spacing,
				it->site[1], it->spacing,
				it->site[2], it->spacing,
				it->site[3], it->spacing);
			//fprintf(f_file,"%-4s%5d%5d%5d%5d",
			//		bdef->get_potkey_str(),
			//		it->site[0],
			//		it->site[1],
			//		it->site[2],
			//		it->site[3]);
			//int paramnr=bdef->get_dlpoly_paramnr();
			//if (bdef->get_if_dlpoly_needs_scalefactors())
				//fprintf(f_file,"%12.6lf%12.6lf\n",
				//		bdef->get_scalar_cou(),
				//		bdef->get_scalar_vdw());
			//for (int i=1; i<=paramnr; ++i)
			//{
				//if (i==8)
					//fprintf(f_file,"\n");
				//fprintf(f_file,"%12.6lf", bdef->get_force(i));
			//}
			//fprintf(f_file,"\n");
	}

	fprintf(file,"FINISH\n");
	//fprintf(f_file,"FINISH\n");
}

write_field_vdw();

fprintf(file,"CLOSE\n");
//fprintf(f_file,"CLOSE\n");
tmp.close_file(file);

// Convert fieldout.ini to dl_poly field file
//FIELDOUT fieldout(filename);
//fieldout.write_fieldfile(field_filename);

//tmp.close_file(f_file);
return 0;
}

//========== method write_defs ==========
// Writes the definitons part of the FIELDOUT file.

int GENFIELDOUTINI::write_defs()
{
fprintf(file,"FORCES\n");
for (set<ATOMARG*>::iterator it=used_atomargs.begin(); it != used_atomargs.end(); ++it)
{
	ATOMARG *atom=*it;
	fprintf(file,"ATOMTYPE %s %lf %lf\n",
			atom->get_label(),
			atom->get_mass(),
			atom->get_charge());
}
int constraints=defs->get_constraints();
for (int c=1; c<=constraints; ++c)
{
	fprintf(file,"CONSTRAINT %s %lf\n",
			defs->get_const(c)->get_label().c_str(),
			defs->get_const(c)->get_value());
}
int bonds=defs->get_bonds();
for (int b=1; b<=bonds; ++b)
{
	BONDDEF bond=defs->get_bond(b)->make_dlpoly_compatible(_BOND_);
	fprintf(file,"BONDTYPE %s %s %d",
			bond.get_label().c_str(),
			bond.get_potkey_str(),
			bond.get_forcenr());
	for (int i=1; i<=bond.get_forcenr(); ++i)
		fprintf(file, " %lf", bond.get_force(i));
	fprintf(file,"\n");
}
int angles=defs->get_angles();
for (int a=1; a<=angles; ++a)
{
	BONDDEF angle=defs->get_angle(a)->make_dlpoly_compatible(_ANGLE_);
	fprintf(file,"ANGLETYPE %s %s %d",
			angle.get_label().c_str(),
			angle.get_potkey_str(),
			angle.get_forcenr());
	for (int i=1; i<=angle.get_forcenr(); ++i)
			fprintf(file, " %lf", angle.get_force(i));
	fprintf(file,"\n");
}
int dihedrals=defs->get_dihedrals();
for (int d=1; d<=dihedrals; ++d)
{
	BONDDEF dih=defs->get_dih(d)->make_dlpoly_compatible(_DIHEDRAL_);
	fprintf(file,"DIHEDRALTYPE %s %s %d",
			dih.get_label().c_str(),
			dih.get_potkey_str(),
			dih.get_forcenr());
        for (int i=1; i<=dih.get_forcenr(); ++i)
                fprintf(file, " %lf", dih.get_force(i));
        fprintf(file,"\n");
}
return 0;
}


//========== method write_vdw ==========
// Writes the VDW definitions part of the FIELDOUT file.

int GENFIELDOUTINI::write_vdw()
{
//size_t nr_atomdefs=vdw->get_nr_atomdefs();
//size_t used_atomdefs=used_atomargs.size();
set<ATOMARG*>::iterator it, jt, end;
end=used_atomargs.end();
for (it=used_atomargs.begin(); it != end; ++it)
{
	int i=(*it)->get_id();
	for (jt=it; jt != end; ++jt)
	{
		int j=(*jt)->get_id();
		VDWRECORD *v=vdw->find(i,j);
		if ((v->get_vdwkey())==EMPTY)
			continue;
		fprintf(file, "VDW %s %s %s %d",
				v->get_vdwkey_str(),
				(*it)->get_label(),
				(*jt)->get_label(),
				v->get_argnr());
		for (int k=1; k<=v->get_argnr(); ++k)
			fprintf(file, " %lf", v->get_arg(k));
		fprintf(file, "\n");
	}
}
/*for (uint i=1; i<=nr_atomdefs; ++i)
{
	if (used_atomargs.count(defs->get_atomarg(i)) == 0)
		continue;
	for (uint j=i; j<=nr_atomdefs; ++j)
	{
		if (used_atomargs.count(defs->get_atomarg(j)) == 0)
			continue;
		VDWRECORD *v=vdw->find(i,j);
		fprintf(file, "VDW %d %s %d %d %d", vdwid++,
				v->get_vdwkey(), i-1, j-1, v->get_argnr());
		for (int k=1; k<=v->get_argnr(); ++k)
			fprintf(file, " %lf", v->get_arg(k));
		fprintf(file, "\n");
	}
}*/
return 0;
}

//========== method write_field_vdw ==========
// Writes the VDW definitions part of the mcgen.out.FIELD file.

int GENFIELDOUTINI::write_field_vdw()
{/*
size_t nr_atomdefs=vdw->get_nr_atomdefs();
size_t used_atomdefs=used_atomargs.size();
fprintf(f_file,"VDW%5lu\n",
		(long unsigned int)(used_atomdefs*(used_atomdefs+1)/2));
for (uint i=1; i<=nr_atomdefs; ++i)
{
	if (used_atomargs.count(defs->get_atomarg(i)) == 0)
		continue;
	for (uint j=i; j<=nr_atomdefs; ++j)
	{
		if (used_atomargs.count(defs->get_atomarg(j)) == 0)
			continue;
		VDWRECORD *v=vdw->find(i,j);
		fprintf(f_file, "%-8s%-8s%-4s %12.6lf%12.6lf%12.6lf%12.6lf%12.6lf\n",
				defs->get_atomarg(i)->get_label(),
				defs->get_atomarg(j)->get_label(),
				v->get_vdwkey(),
				v->get_arg(1),
				v->get_arg(2),
				v->get_arg(3),
				v->get_arg(4),
				v->get_arg(5));
	}
}*/
return 0;
}

//========== method set_filename ==========

int GENFIELDOUTINI::set_filename(string _filename)
{
	filename=_filename;
	return 0;
}

//========== method set_field_filename ==========

int GENFIELDOUTINI::set_field_filename(string _field_filename)
{
	field_filename=_field_filename;
	return 0;
}

//========== method set_defs ==========

int GENFIELDOUTINI::set_defs(DEFS *_defs)
{
	defs=_defs;
	return 0;
}


//========== method set_vdw ==========

int GENFIELDOUTINI::set_vdw(VDW *_vdw)
{
	vdw=_vdw;
	return 0;
}

