#include "four_atomref.h"
#include <sstream>
#include <assert.h>
#include <stdio.h>
#include "sysutils.h"
#include "logfile.h"

//========== constructor ==========

FOUR_ATOMREF::FOUR_ATOMREF()
{
chainid[0]=0;
chainid[1]=0;
chainid[2]=0;
chainid[3]=0;
unitid[0]=0;
unitid[1]=0;
unitid[2]=0;
unitid[3]=0;
atomid[0]=0;
atomid[1]=0;
atomid[2]=0;
atomid[3]=0;
}

//========== method set_chainXid ==========

int FOUR_ATOMREF::set_chainXid(int _index, int _chainXid)
{
assert(_index>=1);
assert(_index<=4);
chainid[_index-1]=_chainXid;
return 0;
}

//========== method set_unitXid ==========

int FOUR_ATOMREF::set_unitXid(int _index, int _unitXid)
{
assert(_index>=1);
assert(_index<=4);
unitid[_index-1]=_unitXid;
return 0;
}

//========== method set_atomXid ==========

int FOUR_ATOMREF::set_atomXid(int _index, int _atomXid)
{
assert(_index>=1);
assert(_index<=4);
if (_atomXid<1)
{
	ostringstream msg;
	msg<<"atom"<<_index<<"id="<<_atomXid<<". Must be at least 1.";
	throw msg.str();
}
atomid[_index-1]=_atomXid;
return 0;
}

//========== method get_chainXid ==========

int FOUR_ATOMREF::get_chainXid(int _index)
{
assert(_index>=1);
assert(_index<=4);
return chainid[_index-1];
}

//========== method get_unitXid ==========

int FOUR_ATOMREF::get_unitXid(int _index)
{
assert(_index>=1);
assert(_index<=4);
return unitid[_index-1];
}

//========== method get_atomXid ==========

int FOUR_ATOMREF::get_atomXid(int _index)
{
assert(_index>=1);
assert(_index<=4);
return atomid[_index-1];
}

//========== method copy ==========

int FOUR_ATOMREF::copy(const FOUR_ATOMREF &_original)
{
for (int i=0;i<4;i++) 
{       
	chainid[i]=_original.chainid[i];
	unitid[i]=_original.unitid[i];
	atomid[i]=_original.atomid[i];
}       
return 0;
}



/*!
    \fn FOUR_ATOMREF::FOUR_ATOMREF(FOUR_ATOMREF &_orig)
    \brief Copy constructor
 */
 FOUR_ATOMREF::FOUR_ATOMREF(const FOUR_ATOMREF &_orig)
{
copy(_orig);
}
