//===> generated by: genmakec.scr-00.00.09-031121 by cipo@ut.ee <===
//       Class: DEFS
//     Version: defs-00.00.07-060824-00 by cipo@ut.ee
//      Author: cipo@ut.ee
// Description:

#ifndef _DEFS_H_DEFINE
#define _DEFS_H_DEFINE
#include <iostream>
#include <string>
#include <ctype.h>
#include <cassert>
#include <cstring>
#include <map>

using namespace std;

class ATOMARG;
class BONDDEF;
class CONSTDEF;
class DEFS;

#include "sysutils.h"

#define _DEFS_VERSION "Version: defs-00.00.07-060824 by cipo@ut.ee\0"

class DEFS:SYSUTILS //! Reads and stores the DEFS-file.
{

private:

int atoms;
ATOMARG *atom;
map<const string,int> atom_by_label;
int constraints, constangles, constdihedrals;
CONSTDEF *con, *cang, *cdih; // arrays
int bonds, angles, dihedrals;
map<const string,int> const_by_label[3];
BONDDEF *bond, *angle, *dih; // arrays
map<const string,BONDDEF*> bond_by_label[3];

FILE *file;
string inputFileName;

public:

explicit DEFS(string _inputfilename);
~DEFS();
CONSTDEF *get_const(int _id);
CONSTDEF *get_const(string _id);
CONSTDEF *get_cang(int _id);
CONSTDEF *get_cang(string _id);
CONSTDEF *get_cdih(int _id);
CONSTDEF *get_cdih(string _id);
BONDDEF *get_bond(char _nrofatoms, int _id);
BONDDEF *get_bond(char _nrofatoms, const string _id);
BONDDEF *get_bond(int _id);
BONDDEF *find_suitable_bond(char _nrofatoms, const ATOMARG *_atom[4]);
BONDDEF *get_bond(const string _id);
BONDDEF *get_angle(int _id);
BONDDEF *get_angle(const string _id);
BONDDEF *get_dih(int _id);
BONDDEF *get_dih(const string _id);

ATOMARG *get_atomarg(int _id);
ATOMARG *get_atomarg(string _label);

int read_next(string _codeword);
int read_atom(string _inputfilename, ATOMARG& _atom, int _atomid);
int read_constdef(string _codeword, int _nratoms,string _inputfilename,
		CONSTDEF& _con, int _id);
int read_bonddef(string _codeword, int _nratoms,string _inputfilename,
		BONDDEF &_bond, int _id);
int get_atoms(); // returns the number of atom definitions.
int get_constraints(); // returns the number of constraint definitions.
int get_bonds(); // returns the number of bond definitions.
int get_angles(); // returns the number of angle definitions.
int get_dihedrals(); // returns the number of dihedral definitions.

};

#include "atomarg.h"
#include "bonddef.h"
#include "constdef.h"

#endif

