#include "defs.h"
#include "mcgen.h"

//========== constructor DEFS ==========

DEFS::DEFS(string _inputfilename)
{
defs=this;
int id;

inputFileName=_inputfilename;
file=open_file(inputFileName,"r");

read_next("DEFINITIONS\n");

read_next("ATOMS");
atoms=read_lineint(2);

atom=new ATOMARG[atoms];

for (id=1;id<=atoms;id++)
	read_atom(inputFileName,atom[id-1],id);

read_next("CONSTRAINTS");
constraints=read_lineint(2);
con=new CONSTDEF[constraints];
for (id=1;id<=constraints;id++)
	read_constdef("CONST",2,inputFileName,con[id-1],id);

read_next("BONDS");
bonds=read_lineint(2);
bond=new BONDDEF[bonds];
for (id=1;id<=bonds;id++)
        read_bonddef("BOND",2,inputFileName,bond[id-1],id);

read_next("ANGLES");
angles=read_lineint(2);
angle=new BONDDEF[angles];
for (id=1;id<=angles;id++)
        read_bonddef("ANG",3,inputFileName,angle[id-1],id);

read_next("CONSTANGLES");
constangles=read_lineint(2);
cang=new CONSTDEF[constangles];
for (id=1;id<=constangles;id++)
	read_constdef("CANG",3,inputFileName,cang[id-1],id);

read_next("DIHEDRALS");
dihedrals=read_lineint(2);
dih=new BONDDEF[dihedrals];
for (id=1;id<=dihedrals;id++)
        read_bonddef("DIH",4,inputFileName,dih[id-1],id);

read_next("CONSTDIHEDRALS");
constdihedrals=read_lineint(2);
cdih=new CONSTDEF[constdihedrals];
for (id=1;id<=constdihedrals;id++)
	read_constdef("CDIH",4,inputFileName,cdih[id-1],id);

read_next("CLOSE\n");
close_file(file);
//filename=0;
}

//========== destructor ~DEFS  ==========

DEFS::~DEFS()
{
	delete [] atom;
	delete [] con;
	delete [] cang;
	delete [] cdih;
	delete [] bond;
	delete [] angle;
	delete [] dih;
}

//========== method read_next ==========

int DEFS::read_next(string _codeword)
{

string tmpString(_codeword);
	
nextfilerecord(file);
test_filelinestringlnr(1,tmpString,"IOERROR:",inputFileName,
		_SYSUTILS_IOERR);
return 0;
}


//========== method read_atom ==========

int DEFS::read_atom(string _inputfilename, ATOMARG &_atom, int _atomid)
{
int id;
char inp_label[_SYSUTILS_INPROW_LEN];
char k=1;

read_next("ATOM");

/*id=read_lineint(++k);
if (id != _atomid)
{
	logfile.print("Error: atomid %d found where %d expected in %s.\n",id,_atomid,
			inputFileName.c_str());
	exit(1);
}*/
_atom.set_id(_atomid);

read_linestring(inp_label,++k);
_atom.set_label(inp_label);

if (atom_by_label.find(inp_label) != atom_by_label.end()) {
	logfile.print("%s:%d: error: duplicate atom label %s for atom %d.\n",
		inputFileName.c_str(),SYSU_retr_linecount(),inp_label,id);
	exit(1);
}
ostringstream satomid;
satomid<<_atomid;
atom_by_label[inp_label]=_atomid;
atom_by_label[satomid.str()]=_atomid;

_atom.set_mass(read_linedouble(++k));
_atom.set_charge(read_linedouble(++k));
_atom.set_radius(read_linedouble(++k));
int blindnr=read_lineint(++k);
//logfile.print("BLIND: %d\n",blindnr);
for (int i=1; i<=blindnr; i++)
{
	string blindlabel=SYSU_read_linestring(++k);
	ATOMARG *blind=get_atomarg(blindlabel);
	if (blind)
		_atom.add_blindatom(blind);
	else
		throw string("Error: unknown atom ")+blindlabel;
}
return 0;
}

//========== method read_constdef ==========

int DEFS::read_constdef(string _codeword, int _nratoms,
	       	string _inputfilename, CONSTDEF &_con, int _id)
{
int i;

assert(_nratoms>=2);
assert(_nratoms<=4);

read_next(_codeword);

string id=SYSU_read_linestring(2);
if (const_by_label[_nratoms-2].count(id) != 0) {
	logfile.print("%s:%d: error: duplicate const/constang/constdihedral label %s.\n",
		inputFileName.c_str(),SYSU_retr_linecount(),id.c_str());
	exit(1);
}
_con.set_label(id);
const_by_label[_nratoms-2][id]=_id;

//id=read_lineint(2);
//if (id != _id)
//{
//	logfile.print("Error: %s id %d found where %d expected in %s.\n",_codeword,
//			id,_id,inputFileName.c_str());
//	exit(1);
//}

for (i=1;i<=_nratoms;i++) {
	_con.set_atom(i,read_lineint(i+2));
}

_con.set_value(read_linedouble(_nratoms+3),_nratoms>=3);
if (_nratoms==4)
	_con.set_tolerance(0,false);
else
	_con.set_tolerance(read_linedouble(_nratoms+4),_nratoms>=3);

return 0;
}

//========== method read_bonddef ==========

int DEFS::read_bonddef(string _codeword, int _nratoms,
	       	string _inputfilename, BONDDEF& _bond, int _id)
{
int i,k;
char inp_potkey[_SYSUTILS_INPROW_LEN];

assert(_nratoms>=2);
assert(_nratoms<=4);

read_next(_codeword);

string label=SYSU_read_linestring(2);
if (bond_by_label[_nratoms-2].count(label) != 0) {
	logfile.print("%s:%d: error: duplicate bond/angle/dihedral label %s.\n",
		inputFileName.c_str(),SYSU_retr_linecount(),label.c_str());
	exit(1);
}
bond_by_label[_nratoms-2][label]=&_bond;
_bond.set_id(_id);
_bond.set_label(label);

k=3;
for (i=1;i<=_nratoms;i++)
	_bond.set_atom(i,SYSU_read_linestring(k++));

read_linestring(inp_potkey,k++);
_bond.set_potkey(inp_potkey);

_bond.set_forcenr(read_lineint(k++));

for (i=1;i<=_bond.get_forcenr();i++)
	_bond.set_force(i, read_linedouble(k++),((_nratoms==3) and (i==2)));

if (_nratoms == 4)
{
switch (_bond.get_potkey())
{
	case ZERO:
	{
		assert(_bond.get_forcenr()==0);
		break;
	}
	case HARM:
	{
		_bond.set_scalar_cou(0);
		_bond.set_scalar_vdw(0);
		break;
	}
	case COS:
	{
		assert(_bond.get_forcenr()==5);
		_bond.set_scalar_cou(_bond.get_force(4));
		_bond.set_scalar_vdw(_bond.get_force(5));
		break;
	}
	case SYLV:
	{
		assert(_bond.get_forcenr()==9);
		_bond.set_scalar_cou(0);
		_bond.set_scalar_vdw(0);
		break;
	}
	case ANDI:
	{
		_bond.set_scalar_cou(0);
		_bond.set_scalar_vdw(0);
		break;
	}
	case COSJ:
	{
		_bond.set_scalar_cou(0);
		_bond.set_scalar_vdw(0);
		break;
	}
	case COS5:
	{
		_bond.set_scalar_cou(0);
		_bond.set_scalar_vdw(0);
		break;
	}
	case ANPA:
	{
		_bond.set_scalar_cou(0);
		_bond.set_scalar_vdw(0);
		break;
	}
	case COSG: // Currently no scalling parameters
	{
		_bond.set_scalar_cou(0);
		_bond.set_scalar_vdw(0);
		break;
	}
	case FMCT:
	{
		assert(_bond.get_forcenr()>=2);
		assert(_bond.get_forcenr()%2==0);
		_bond.set_scalar_cou(_bond.get_force(1));
		_bond.set_scalar_vdw(_bond.get_force(2));
		break;
	}
	case LJPO:
	{
		// Those forcefields are not for dihedrals.
		assert(false);
		break;
	}
	case OPA2:
	{
		assert(_bond.get_forcenr()==4);
		_bond.set_scalar_cou(0);
		_bond.set_scalar_vdw(0);
		break;
	}
	default:
		assert(false);
}
}	
return 0;
}

//========== method get_const ==========

CONSTDEF *DEFS::get_const(int _id)
{
if ((_id>=1) && (_id<=constraints))
	return &con[_id-1];

ostringstream msg;
msg<<"Error: unknown constraint "<<_id;
string exc=msg.str();
throw exc;
}

//========== method get_const ==========

CONSTDEF *DEFS::get_const(string _id)
{
assert(this);
map<const string,int>::iterator it = const_by_label[0].find(_id);
if (it != const_by_label[0].end()) {
	int id=it->second;
	return &con[id-1];
}

ostringstream msg;
msg<<"Error: unknown constraint "<<_id;
string exc=msg.str();
throw exc;
}

//========== method get_cang ==========

CONSTDEF *DEFS::get_cang(int _id)
{
if ((_id>=1) && (_id<=constangles))
	return &cang[_id-1];

ostringstream msg;
msg<<"Error: unknown angular constraint "<<_id;
string exc=msg.str();
throw exc;
}

//========== method get_cang ==========

CONSTDEF *DEFS::get_cang(string _id)
{
map<const string,int>::iterator it = const_by_label[1].find(_id);
if (it != const_by_label[1].end()) {
	int id=it->second;
	return &cang[id-1];
}

ostringstream msg;
msg<<"Error: unknown angular constraint "<<_id;
string exc=msg.str();
throw exc;
}

//========== method get_cdih ==========

CONSTDEF *DEFS::get_cdih(int _id)
{
if ((_id>=1) && (_id<=constdihedrals))
	return &cdih[_id-1];

ostringstream msg;
msg<<"Error: unknown dihedral constraint "<<_id;
string exc=msg.str();
throw exc;
}

//========== method get_cdih ==========

CONSTDEF *DEFS::get_cdih(string _id)
{
map<const string,int>::iterator it = const_by_label[2].find(_id);
if (it != const_by_label[2].end()) {
	int id=it->second;
	return &cdih[id-1];
}

ostringstream msg;
msg<<"Error: unknown dihedral constraint "<<_id;
string exc=msg.str();
throw exc;
}

//========== method get_atomarg ==========

ATOMARG *DEFS::get_atomarg(int _id)
{
if ((_id>=1) && (_id<=atoms))
	return &atom[_id-1];

ostringstream msg;
msg<<"Error: unknown atom "<<_id;
string exc=msg.str();
throw exc;
}

//========== method get_atomarg ==========

ATOMARG *DEFS::get_atomarg(string _label)
{
map<const string,int>::iterator it = atom_by_label.find(_label);
if (it != atom_by_label.end()) {
	int id=it->second;
	return &atom[id-1];
}
return 0; // If not found, returns null pointer
}

//========== method get_bond ==========

BONDDEF *DEFS::get_bond(char _nrofatoms, int _id)
{
switch (_nrofatoms) {
	case 2:	return get_bond(_id);
	case 3:	return get_angle(_id);
	case 4:	return get_dih(_id);
	default:	assert(false);
}
}

//========== method get_bond ==========

BONDDEF *DEFS::get_bond(char _nrofatoms, const string _id)
{
assert(_nrofatoms>=2);
assert(_nrofatoms<=4);
map<const string,BONDDEF*>::iterator it = bond_by_label[_nrofatoms-2].find(_id);
if (it != bond_by_label[_nrofatoms-2].end()) {
	return it->second;
}

string whatisit;
switch (_nrofatoms) {
	case 2:	whatisit="bond"; break;
	case 3:	whatisit="angle"; break;
	case 4:	whatisit="dihedral"; break;
	default: assert(false);
}

ostringstream msg;
msg<<"Error: unknown "<<whatisit<<" with id "<<_id;
string exc=msg.str();
throw exc;
}

//========== method find_suitable_bond ==========

BONDDEF *DEFS::find_suitable_bond(char _nrofatoms, const ATOMARG *_atom[4])
{
assert(_nrofatoms>=2);
assert(_nrofatoms<=4);

BONDDEF *bit = 0;
BONDDEF *bbeg = 0;
BONDDEF *bend = 0;
BONDDEF *found = 0;
switch (_nrofatoms) {
	case 2:	bbeg=bond;  bend=bond  + bonds;     break;
	case 3:	bbeg=angle; bend=angle + angles;    break;
	case 4:	bbeg=dih;   bend=dih   + dihedrals; break;
	default: assert(false);
}

int foundcount=0;
for(bit=bbeg; bit!=bend; ++bit)
{
	bool straight=true;
	bool reverse=true;
	for (int i=0; i<_nrofatoms; ++i)
	{
		straight = straight && (bit->get_atom(i+1)          == _atom[i]);
		reverse  = reverse  && (bit->get_atom(_nrofatoms-i) == _atom[i]);
	}
	if (straight || reverse)
	{
		found=bit;
		++foundcount;
	}
}
if (foundcount > 1)
	throw string("Multiple forces found with same atom types");
return found; // if not found, then it is null pointer
}

//========== method get_bond ==========

BONDDEF *DEFS::get_bond(int _id)
{
if ((_id>=1) && (_id<=bonds))
	return &bond[_id-1];

logfile.print("Error: Bad bond id: %d\n",_id);
exit(_SYSUTILS_IOERR);
}

//========== method get_bond ==========

BONDDEF *DEFS::get_bond(const string _id)
{
return get_bond(2,_id);
}

//========== method get_angle ==========

BONDDEF *DEFS::get_angle(int _id)
{
if ((_id>=1) && (_id<=angles))
	return &angle[_id-1];

logfile.print("Error: Bad angle id: %d\n",_id);
exit(_SYSUTILS_IOERR);
}

//========== method get_angle ==========

BONDDEF *DEFS::get_angle(const string _id)
{
return get_bond(3,_id);
}

//========== method get_dih ==========

BONDDEF *DEFS::get_dih(int _id)
{
if ((_id<1) || (_id>dihedrals))
{
	logfile.print("Error: Bad dihedral id: %d\n",_id);
	exit(_SYSUTILS_IOERR);
}

return &dih[_id-1];
}

//========== method get_dih ==========

BONDDEF *DEFS::get_dih(const string _id)
{
return get_bond(4,_id);
}

//========== method get_atoms ==========

int DEFS::get_atoms()
{
return atoms;
}

//========== method get_constraints ==========

int DEFS::get_constraints()
{
return constraints;
}

//========== method get_bonds ==========

int DEFS::get_bonds()
{
return bonds;
}

//========== method get_angles ==========

int DEFS::get_angles()
{
return angles;
}

//========== method get_dihedrals ==========

int DEFS::get_dihedrals()
{
return dihedrals;
}

