#ifndef _CONSTDEF_H_DEFINE
#define _CONSTDEF_H_DEFINE

#include <assert.h>

class CONSTDEF;

#include "randome.h"
extern RANDOME *randome;

#include "mathfunc.h"

class CONSTDEF //! One constraint, constant angle or constant dihedral from the DEFS-file.
{
private:
	
int id;
string label;
int atom[4];
double value;
double tolerance;

public:

int set_id(int _id);
int set_label(const string &_label);
int set_atom(int _nr, int _id);
int set_value(double _value, bool _deg2rad);
int set_tolerance(double _tolerance, bool _deg2rad);
int get_id();
string get_label();
int get_atom(int _nr);
double get_value();
double get_tolerance();
double get_random_bond();
double get_random_angle();
double get_random_dihedral();

};

#endif
