#include "constdef.h"

//========== method set_atom ==========

int CONSTDEF::set_atom(int _nr, int _id)
{
assert(_nr>=1);
assert(_nr<=4);
atom[_nr-1]=_id;
return 0;
}

//========== method get_atom ==========

int CONSTDEF::get_atom(int _nr)
{
assert(_nr>=1); 
assert(_nr<=4); 
return atom[_nr-1]; 
}

//========== method set_id ==========

int CONSTDEF::set_id(int _id) {
id=_id; 
return 0; 
}

//========== method set_label ==========

int CONSTDEF::set_label(const string &_label) 
{
label=_label;
return 0;
}

//========== method get_label ==========

string CONSTDEF::get_label() 
{
return label;
}

//========== method set_value ==========

int CONSTDEF::set_value(double _value, bool _deg2rad) {
if (_deg2rad)
	value=MATHFUNC::deg2rad(_value);
else
	value=_value;
//logfile.print("constdef value: %lf,%d->%lf\n",_value,_deg2rad,value);
return 0;
}

//========== method set_tolerance ==========

int CONSTDEF::set_tolerance(double _tolerance, bool _deg2rad) {
if (_deg2rad)
	tolerance=MATHFUNC::deg2rad(_tolerance);
else
	tolerance=_tolerance;
return 0;
}

//========== method get_id ==========

int CONSTDEF::get_id() {
return id;
}

//========== method get_value ==========

double CONSTDEF::get_value()
{
return value;
}

//========== method get_tolerance ==========

double CONSTDEF::get_tolerance()
{
return tolerance;
}

//========== method get_random_bond ==========

double CONSTDEF::get_random_bond()
{
if (tolerance==0.0)
	return value;
else
	return value+tolerance*(randome->
		RANDOME_output_random_number()*2-1);
}

//========== method get_random_angle ==========

double CONSTDEF::get_random_angle()
{
if (tolerance==0.0)
	return value;
else
	return value+tolerance*(randome->
		RANDOME_output_random_number()*2-1);
}

//========== method get_random_dihedral ==========

double CONSTDEF::get_random_dihedral()
{
double ret;
if (value==0.0)
	ret=2*M_PIl*randome->RANDOME_output_random_number();
else
	ret=value;
//logfile.print("get_random_dihedral()=%lf\n",ret);
return ret;
}

