#include "connectone.h"
#include "defs.h"
#include "constdef.h"

//========== constructor CONNECTONE ==========

CONNECTONE::CONNECTONE():FOUR_ATOMREF()
{
	defs=0;
	con=0;
	cang=0;
	cdih=0;
}

//========== copy constructor CONNECTONE ==========

CONNECTONE::CONNECTONE(const CONNECTONE &_source):FOUR_ATOMREF(_source)
{
	defs=_source.defs;
	con=_source.con;
	cang=_source.cang;
	cdih=_source.cdih;
}

//========== copy constructor CONNECTONE ==========

CONNECTONE::CONNECTONE(const CONNECTONE &_constsource, const FOUR_ATOMREF &_refsource):FOUR_ATOMREF(_refsource)
{
	defs=_constsource.defs;
	con=_constsource.con;
	cang=_constsource.cang;
	cdih=_constsource.cdih;
}

//========== method set_defs ==========

int CONNECTONE::set_defs(DEFS *_defs)
{
defs=_defs;
return 0;
}

//========== method set_constid ==========

int CONNECTONE::set_constid(string _constid)
{
con=defs->get_const(_constid);
return 0;
}

//========== method set_cangid ==========

int CONNECTONE::set_cangid(string _cangid)
{
cang=defs->get_cang(_cangid);
return 0;
}

//========== method set_cdihid ==========

int CONNECTONE::set_cdihid(string _cdihid)
{
cdih=defs->get_cdih(_cdihid);
return 0;
}

//========== method get_const ==========

CONSTDEF *CONNECTONE::get_const()
{
return con;
}

//========== method get_cang ==========

CONSTDEF *CONNECTONE::get_cang()
{
return cang;
}

//========== method get_cdih ==========

CONSTDEF *CONNECTONE::get_cdih()
{
return cdih;
}

