#ifndef _CONNECT_H_DEFINE
#define _CONNECT_H_DEFINE

#include <vector>

//class CONNECT;
//class CONSTDEF;

#include "four_atomref.h"
#include "connectone.h"
#include "bondlist.h"
#include "constdef.h"
#include "bondclass.h"
#include "replace_atom.h"
class UNIT;

class CONNECT //! Stores one CONNECT-END_CONNECT block from the CHAINS-file and its accompanying xxEXCLUDE, xxBONDS, xxANGLES and xxDIHEDRALS block from the FIELD-file.
{
private:

int previousunittype;
BONDLIST exclusions, bonds, angles, dihedrals;

static vector<CONNECT*> connect_instances; // TODO this is too unpredictable to use in dump files.
int connect_id;
list<REPLACE_ATOM> replace_atoms;

public:

CONNECT();

// Create a copy of another CONNECT, but decrease unitids of all units in all
// bond arrays by _unitshift steps and throw out those some of whose unitids
// is greater than 1.
CONNECT(CONNECT &_refsource, int _unitshift, CONNECTONE &_constsource);

int set_previousunittype(int _type);
int get_previousunittype();

BONDLIST *get_bondarray(BONDCLASS _bondclass);
int get_connect_id();
static CONNECT *find_connect(int _id);
int maximum_used_unitid();
int add_replace_atom(const REPLACE_ATOM &_replace_atom);
int do_replace_atoms(UNIT *_unit);
};

#endif

