#include "connect.h"
#include "mcgen.h"
#include "defs.h"
#include "constdef.h"

vector<CONNECT*> CONNECT::connect_instances;

//========== constructor CONNECT ==========

CONNECT::CONNECT()//: CONNECTONE()
{
exclusions.set_bondatomsnum(2);
bonds.set_bondatomsnum(2);
angles.set_bondatomsnum(3);
dihedrals.set_bondatomsnum(4);
connect_instances.push_back(this);
connect_id=connect_instances.size();
//printf("CONNECT nr. %d created\n",connect_id);
}


//========== constructor CONNECT ==========
// Create a copy of another CONNECT, but decrease unitids of all units in all
// bond arrays by _unitshift steps and throw out those some of whose unitids
// is greater than 1.

CONNECT::CONNECT(CONNECT &_refsource, int _unitshift, CONNECTONE &_constsource)//: CONNECTONE(_constsource, _refsource)
{
connect_instances.push_back(this);
connect_id=connect_instances.size();

//FOUR_ATOMREF::copy(_refsource);
previousunittype=_refsource.previousunittype;
exclusions.shift_and_filter(_refsource.exclusions,_unitshift);
bonds.shift_and_filter(_refsource.bonds,_unitshift);
angles.shift_and_filter(_refsource.angles,_unitshift);
dihedrals.shift_and_filter(_refsource.dihedrals,_unitshift);
logfile.print("Note: new Cx with %d/%d EXC, %d/%d BOND, %d/%d ANG and %d/%d DIH records for shift %d.\n",
		(int)exclusions.size(),(int)_refsource.exclusions.size(),
		(int)bonds.size(),(int)_refsource.bonds.size(),
		(int)angles.size(),(int)_refsource.angles.size(),
		(int)dihedrals.size(),(int)_refsource.dihedrals.size(),
		(int)_unitshift);
}

//========== method set_previousunittype ==========

int CONNECT::set_previousunittype(int _type)
{
previousunittype=_type;
return 0;
}

//========== method get_previousunittype ==========

int CONNECT::get_previousunittype()
{
return previousunittype;
}

//========== method get_bondarray ==========

BONDLIST *CONNECT::get_bondarray(BONDCLASS _bondclass)
{
assert(this != 0);
switch (_bondclass)
{
	case _EXCLUDE_:
		return &exclusions;
	case _BOND_:
		return &bonds;
	case _ANGLE_:
		return &angles;
	case _DIHEDRAL_:
		return &dihedrals;
	default:
		assert(false);
}
}

//========== method get_connect_id ==========

int CONNECT::get_connect_id()
{
	if (this)
		return connect_id;
	else
		return 0;
}

//========== method find_connect ==========

CONNECT *CONNECT::find_connect(int _id)
{
	if (_id==0)
		return 0;
	assert(_id>0);
	assert((size_t)_id<=connect_instances.size());
	return connect_instances[_id-1];
}

//========== method maximum_used_unitid ==========

// int CONNECT::maximum_used_unitid()
// {
// if (this==0)
// 	return 0;
// int max, one;
// max=get_unitXid(1);
// one=get_unitXid(2);
// if (max<one) max=one;
// one=get_unitXid(3);
// if (max<one) max=one;
// one=exclusions.maximum_used_unitid();
// if (max<one) max=one;
// one=bonds.maximum_used_unitid();
// if (max<one) max=one;
// one=angles.maximum_used_unitid();
// if (max<one) max=one;
// one=dihedrals.maximum_used_unitid();
// if (max<one) max=one;
// return max;
// }


/*!
    \fn CONNECT::add_replace_atom(const REPLACE_ATOM &_replace_atom)
    \brief Adds new replacement atom to the connection record
 */
int CONNECT::add_replace_atom ( const REPLACE_ATOM &_replace_atom )
{
	assert(_replace_atom.get_atomarg());
	replace_atoms.push_back ( _replace_atom );
	return 0;
}

/*!
    \fn CONNECT::replace_atoms(UNIT *_unit)
 */
int CONNECT::do_replace_atoms(UNIT *_unit)
{
	if (!this)
		return 0;

	list<REPLACE_ATOM>::iterator it;

	for (it = replace_atoms.begin(); it != replace_atoms.end(); ++it)
	{
		ATOM *a=_unit->relative_atom(it->get_replace_ref().c_str());
		a->set_atomdef(&*it);
	}
	return 0;
}
