#ifndef _CHAINS_H_DEFINE
#define _CHAINS_H_DEFINE

using namespace std;

class CHAINS;
class BOND;

//#include <string>
//#include <iostream>
//#include <ctype.h>
//#include <cassert>
//#include <cstring>
//#include <stdio.h>
//#include <stdlib.h>
//#include <string.h>

#include "sysutils.h"
#include "unitdef.h"
#include "connect.h"
#include "chain.h"
#include "units.h"
#include "bond.h"
#include "molecule.h"

class CHAINS_ERROR:public string //! Exception class for CHAINS-file parsing errors
{
public:
CHAINS_ERROR(const char* _msg);
CHAINS_ERROR(const string _msg);
};

class FIELD_ERROR:public string //! Exception class for FIELD-file parsing errors
{
public:
FIELD_ERROR(const char* _msg);
FIELD_ERROR(const string _msg);
};

class CHAINS //! Reads the CHAINS-file and FIELD-file and organizes the information obtained into other classes.
{
private:

SYSUTILS sysu, fieldsysu;
FILE *file, *fieldfile;
string inputFileName, fieldFileName;

vector<MOLECULE*> molecules; // Array of all molecules.

int read_molecule(MOLECULE *_mol, UNITS &_units);
int read_next(const char *_codeword);
int read_nextfield(const string &_codeword);
int read_connect(CONNECT *_connect);
int read_nextfield(const char *_codeword);
int read_bond(const char *_codeword,
	BONDCLASS _bondclass, int _nrofatoms,
	int _bondid, BOND &_bond);
int read_bonds(BONDLIST *_bondarray, const string _targetstr,
	int _atomnr, BONDCLASS _bondclass, const char* _bondclassstr);
int read_bondgroup(FIELDTARGET _target, string _targetstr,
	CONNECT *_connect);
Unittype read_lineunittype(int _position);
static void chomp(string &_str);
     
public:

CHAINS(const string _inputfilename,
       const string _fieldfilename, UNITS &_units);
MOLECULE *get_molecule(unsigned int _molid);
int get_molnr();
string get_chainsfilemarker();
string get_fieldfilemarker();
bool check_chain_description_completeness(CHAIN *_chain);
CHAIN *read_chains(MOLECULE *_mol, UNITS &_units);

};

#endif

