#ifndef _CHAIN_H_DEFINE
#define _CHAIN_H_DEFINE

using namespace std;

enum FIELDTARGET {_IN_=0,_CF_=1,_CC_=2};
#define FIELDTARGET_TIMES_BONDCLASS 16

class CHAIN;
class CONNECT;
class BOND;
class UNITDEF;

struct CROSS_RECORD //! Structure to contain parameters for a CROSS record in the CHAINS file.
{
	UNITDEF * crosstype; //!< Which crossunit that CROSS applies to
	int spacing;   //!< Number of repeatunits between two crossunits
	int tolerance; //!< Plus-Minus tolerance for the spacing
	CONNECT *connectcross;
	CHAIN *sidechain; //!< The sidechain that connects here.
}; 

#include <cmath>
#include "unitdef.h"
#include "connect.h"

class CHAIN //! One chain block from the CHAINS-file and all its forcefield from the FIELD-file
{
private:

int chainid;

vector<CONNECT*> connectfirst; //!< All available CONNECTFIRST records to choose one from.

vector<CROSS_RECORD> cross; //!< The CROSS records are stored here.

CONNECT inconnect; // TODO initialize inconnect!
BOND *bond[FIELDTARGET_TIMES_BONDCLASS];
int bonds[FIELDTARGET_TIMES_BONDCLASS];

CHAIN *nextchain;
bool pause; //!< If true, then the next chain will be connected here later, after the whole tree has been initialized.

int unitnr;
//Unittype unittype;
UNITDEF *unitdef;

int repeat;
int surefinish;
bool cross_random;
unsigned int next_cross;

public:

CHAIN();
CONNECT *get_random_connectfirst();
CONNECT *get_connectfirst(int _id);
CONNECT *get_connectcross(int _id);
int set_nextchain(CHAIN *_nextchain);
int set_pause(bool _pause);
static int bondclassid(FIELDTARGET _target, BONDCLASS _class);
int set_bonds(FIELDTARGET _target, BONDCLASS _class, int _bonds);
int get_bonds(FIELDTARGET _target, BONDCLASS _class);
BOND *get_bond(FIELDTARGET _target, BONDCLASS _class, int _bondid);

//========== functions that simplify usage of the random numbers ==========
static int random_integer(int range);
bool random_deviation_accept(int _deviation, int _tolerance);

//========== SIMPLE ACCESSORS ==========//
CHAIN *get_nextchain();
bool get_pause();
int get_unitnr();
Unittype get_unittype();
UNITDEF *get_unitdef();
int set_unitdef(UNITDEF *_unitdef);
int set_crosstype(int _index, UNITDEF *_unitdef);
int set_unitnr(int _unitnr);
int get_repeat();
int get_spacing();
int get_tolerance();
int set_repeat(int _repeat);
int set_chainid(int _chainid);
int get_chainid();
int get_cfnr();
int get_crossnr();
CONNECT *get_inconnect();
int get_surefinish();
int set_surefinish(int _surefinish);
CONNECT * new_connectfirst();
CROSS_RECORD * new_cross(CROSS_RECORD &_cross);
int set_cross_random(bool _cross_random);
const CROSS_RECORD * get_next_cross();
};

#include "bond.h"

#endif
