#include <sstream>
#include "chain.h"
#include "mcgen.h"

//========== constructor CHAIN ==========
CHAIN::CHAIN()
{
chainid=0;
for (int i=0;i<FIELDTARGET_TIMES_BONDCLASS;i++)
{
	bond[i]=0;
	bonds[i]=0;
}
nextchain=0;
surefinish=0;
cross_random=false;
next_cross=0;
pause=0;
repeat=0;
}

//========== method get_random_connectfirst ==========

CONNECT *CHAIN::get_random_connectfirst()
{
int i;
if (!this)
	return 0;
if (get_cfnr()==0)
	return 0;
i=0;//TODO
return connectfirst[i];
}

//========== method get_connectfirst ==========

CONNECT *CHAIN::get_connectfirst(int _id)
{
//logfile.print("get_connectfirst(%d)n",_id);
assert(_id>=1);
assert(_id<=get_cfnr());

return connectfirst[_id-1];
}

//========== method set_nextchain ==========

int CHAIN::set_nextchain(CHAIN *_nextchain)
{
//logfile.print("DEBUG: %p.set_nextchain(%p)\n",this,_nextchain);
if (nextchain==0)
{
	nextchain=_nextchain;
	return 0;
}
else if (nextchain == _nextchain)
	return 0;
else
{
	logfile.print("Error: several chains (%d and %d) are connected to chain %d as next main chain.",
	nextchain->get_chainid(), _nextchain->get_chainid(), get_chainid());
	exit(1);
}
}

//========== method set_pause ==========

int CHAIN::set_pause(bool _pause)
{
pause=_pause;
return 0;
}

//========== method random_integer ==========

int CHAIN::random_integer(int range)
{
int value;

assert(range > 0);
if (range == 1)
	return 0;
double r=randome->RANDOME_output_random_number();
value = (int) floor(r*range);

ostringstream o;
o<<"Note: random number was "<<r<<".\n";
logfile.print(o.str().c_str());

assert(value >= 0);
assert(value < range);
return value;
}

//========== method random_deviation_accept ==========

bool CHAIN::random_deviation_accept(int _deviation, int _tolerance)
{
assert(_tolerance>=0);
if (_deviation >= _tolerance)
	return true;
if (_deviation < -_tolerance)
	return false;
if (randome->RANDOME_output_random_number()
	< (1/(_tolerance-_deviation+1)))
	return true;
else
	return false;
}

//========== method bondclassid ==========

int CHAIN::bondclassid(FIELDTARGET _target, BONDCLASS _class)
{
int classid =  (int) _target * 4 + (int) _class - 1;
assert(classid>=0);
assert(classid<FIELDTARGET_TIMES_BONDCLASS);
return classid;
}

//========== method set_bonds ==========

int CHAIN::set_bonds(FIELDTARGET _target, BONDCLASS _class, int _bonds)
{
SYSUTILS tmp;
int classid=bondclassid(_target, _class);
assert(bonds[classid]==0);
bonds[classid]=_bonds;
bond[classid]=new BOND [_bonds];
tmp.allocate_error(bond[classid],"CHAIN","BOND array",_SYSUTILS_MEMERR);
return 0;
}

//========== method get_bonds ==========

int CHAIN::get_bonds(FIELDTARGET _target, BONDCLASS _class)
{
return bonds[bondclassid(_target, _class)];
}

//========== method get_bond ==========

BOND *CHAIN::get_bond(FIELDTARGET _target, BONDCLASS _class, int _bondid)
{
int classid=bondclassid(_target, _class);
assert (_bondid>=1);
assert(_bondid<=bonds[classid]);
return bond[classid]+(_bondid-1);
}

//========== SIMPLE ACCESSORS ==========//

//========== method get_unitnr ==========

int CHAIN::get_unitnr()
{
return unitnr;
}

//========== method get_repeat ==========

int CHAIN::get_repeat()
{
return repeat;
}

//========== method get_spacing ==========

int CHAIN::get_spacing()
{
assert(cross.size() != 0);
return cross[next_cross].spacing;
}

//========== method get_tolerance ==========

int CHAIN::get_tolerance()
{
assert(cross.size() != 0);
return cross[next_cross].tolerance;
}

//========== method set_repeat ==========

int CHAIN::set_repeat(int _repeat)
{
repeat=_repeat;
return 0;
}

//========== method get_unitdef ==========

UNITDEF *CHAIN::get_unitdef()
{
return unitdef;
}

//========== method set_unitdef ==========

int CHAIN::set_unitdef(UNITDEF *_unitdef)
{
unitdef=_unitdef;
return 0;
}

//========== method set_unitnr ==========

int CHAIN::set_unitnr(int _unitnr)
{
if (_unitnr<1)
{
	logfile.print("# CHAIN %d: unitnr=%d\n",chainid,_unitnr);
	SYSUTILS tmp;
	tmp.SYSU_error_exit_if_true(_unitnr<1,"CHAIN","unitnr must be at least 1.\n",_SYSUTILS_IOERR);
}
unitnr=_unitnr;
return 0;
}

//========== method get_unittype ==========

Unittype CHAIN::get_unittype()
{
return get_unitdef()->get_unittype();
}

//========== method get_nextchain ==========

CHAIN *CHAIN::get_nextchain()
{
return nextchain;
}

//========== method get_pause ==========

bool CHAIN::get_pause()
{
return pause;
}

//========== method set_chainid ==========

int CHAIN::set_chainid(int _chainid)
{
	chainid=_chainid;
	return 0;
}

//========== method get_chainid ==========

int CHAIN::get_chainid()
{
	if (this)
		return chainid;
	else
		return 0;
}

//========== method get_cfnr ==========

int CHAIN::get_cfnr()
{
	return connectfirst.size();
}

//========== method  ==========

int CHAIN::get_crossnr()
{
	return cross.size();
}

//========== method get_inconnect ==========

CONNECT *CHAIN::get_inconnect()
{
if (this)
	return &inconnect;
else
	return 0;
}

//========== method set_surefinish ==========

int CHAIN::set_surefinish(int _surefinish)
{
if (_surefinish<0)
	surefinish=0;
else
	surefinish=_surefinish;
return 0;
}

//========== method get_surefinish ==========

int CHAIN::get_surefinish()
{
return surefinish;
}


/*!
    \fn CHAIN::new_connectfirst()
    \brief Adds new CONNECTFIRST record to the end of the array and records pointer to that CONNECTFIRST record.
 */
CONNECT * CHAIN::new_connectfirst()
{
	connectfirst.push_back(new CONNECT());
	CONNECT *c=connectfirst[connectfirst.size()-1];
	return c;
}

/*!
    \fn CHAIN::new_cross(CROSS &_cross)
    \brief Adds new record to the vector "cross" and copies given_values in. Returns pointer to the stored record.
 */
CROSS_RECORD * CHAIN::new_cross(CROSS_RECORD &_cross)
{
cross.push_back(_cross);
return &cross[cross.size()-1];
}


/*!
    \fn CHAIN::get_random_cross
    \brief Chooses randomly or sequentially one CROSS record available for this chain, and returns it.
 */
const CROSS_RECORD * CHAIN::get_next_cross()
{
int last=next_cross;
if (cross_random)
{
	next_cross = random_integer(get_crossnr());
}
else
{
	++next_cross;
	if (next_cross >= cross.size())
		next_cross=0;
}
return &cross[last];
}


/*!
    \fn CHAIN::set_cross_random(bool _cross_random)
    \brief Selects the cross choosing method.
    \param _cross_random can be true for random crosses or false for sequential crosses. Returns zero.
 */
int CHAIN::set_cross_random(bool _cross_random)
{
cross_random=_cross_random;
return 0;
}
