#ifndef _ATOM_H_DEFINE_
#define _ATOM_H_DEFINE_

#include <list>

#define MAXIMUM_USED_DEFAULT 0

#include "bond.h"

using namespace std;

class BONDLIST: public list<BOND> //! One BONDS or ANGLES or DIHEDRALS or EXCLUDE block from the FIELD-file. List with added searching capabilities.
{
private:

int bondatomsnum;
	
public:

bool contains(int _chain1, int _unit1, int _atom1,
	int _chain2, int _unit2, int _atom2);

// Copy a given bondlist, decrease all unit id-s by _unitshift and
// delete all bonds whose resultant maximum unitid is not zero.
// If _unitshift is zero, then all units with non-positive unitid-s are copied.
int shift_and_filter(BONDLIST &_original, int _unitshift);

int set_bondatomsnum(int _bondatomsnum);
int get_bondatomsnum();
int maximum_used_unitid();
};

#endif

