#include "bondlist.h"
#include <vector>
#include <assert.h>
#include "bond.h"

bool BONDLIST::contains(int _chain1, int _unit1, int _atom1,
	int _chain2, int _unit2, int _atom2)
{
BONDLIST::iterator iter, lopp;
lopp=end();
for (iter=begin(); iter != lopp; ++iter)
	if (iter->equals(_chain1,_unit1,_atom1,_chain2,_unit2,_atom2))
		return true;
return false;
}

int BONDLIST::shift_and_filter(BONDLIST &_original, int _unitshift)
{
assert(_unitshift>=0);
assert(size()==0);
set_bondatomsnum(_original.bondatomsnum);
BONDLIST::iterator iter, lopp;
lopp=_original.end();
for (iter=_original.begin(); iter != lopp; ++iter)
{
	int greatest_unitid=-99; // a very large negative number.
	BOND b(*iter);
	for (int k=1; k<=bondatomsnum ; k++)
	{
		b.set_unitXid(k,b.get_unitXid(k)-_unitshift);
		if (b.get_unitXid(k)>greatest_unitid)
			greatest_unitid=b.get_unitXid(k);
	}
	if ((_unitshift==0 and greatest_unitid<=0) or (greatest_unitid==0))
		push_back(b);
}
return 0;
}

int BONDLIST::set_bondatomsnum(int _bondatomsnum)
{
assert(_bondatomsnum>=2);
assert(_bondatomsnum<=4);
bondatomsnum=_bondatomsnum;
return 0;
}

int BONDLIST::get_bondatomsnum()
{
return bondatomsnum;
}

int BONDLIST::maximum_used_unitid()
{
int max=MAXIMUM_USED_DEFAULT;

BONDLIST::iterator iter, lopp;
lopp=end();
for (iter=begin(); iter != lopp; ++iter)
{
	BOND &b=*iter;
	for (int k=1; k<=bondatomsnum; k++)
	{
		int one=b.get_unitXid(k);
		if (max<one) max=one;
	}
}
return max;
}
