#ifndef _BONDINST_H_DEFINE
#define _BONDINST_H_DEFINE

#include "energy.h"
#include "bond.h"
#include "genfieldoutini.h"
class ATOM;

class BONDINST //! Bond instance with absolute pointers to the atoms
{
private:

BONDCLASS bondclass;
//const BONDDEF *def;
const ATOM *atom[4];
int filerow;

public:
const BONDDEF *def;

BONDINST(BONDCLASS _class, const BONDDEF *_def, const ATOM *_atom1, const ATOM *_atom2, const ATOM *_atom3, const ATOM *_atom4, int _filerow);

bool is_between_atoms(int _numatoms, ATOM *_atom[4]);
int calculate(ENERGY &_energy);
const ATOM *latest_atom() const;
int get_filerow() const;
bool is_similar(const BONDINST &_other, int _delta);
int push_to_outlist(list<BOND_OUT> &_outlist,
		int _delta, int _repeat) const;
int get_numatoms() const;
BOND_OUT to_bond_out();
const BONDDEF *get_def() const;
    int add_to_connection_lists();
};

#endif

