#ifndef _BONDDEF_H_DEFINE
#define _BONDDEF_H_DEFINE

#include <string.h>
#include <assert.h>
#include <sstream>

#include "sysutils.h"
#include "mathfunc.h"
#include "logfile.h"
#include "bond.h"

#define DIHFORCENR 7	//number of torsion potential parameters

typedef enum{ZERO,HARM,COS,SYLV,ANDI,ANPA,COS5,COSJ,FMCT,LJPO,_12_6,COSG,OPA2,FIX,COSB} Potkey;

// theta - valence angle
//

// f - dihedraal angle
// ES - electrostatic interaction scale factor
// VDW - van der Waals interaction scale factor
// zero: U(f) = 0; no. of params: 0 (NB: specify
//	'DIH 1 2 3 4 zero 0'
// cos: U(f) = A[1+cos(mf-s], params (3) order: A, s, m
// cos5: U(f) = sum{0.5*A[i]*[1-cos(i*f)]}, i=1...5, 
//		params (5) order A[1], A[2], A[3], A[4], A[5]
// cosj: U(f) = sum{0.5*A[i]*[1-B[i]*cos(if)]}, i=1...3
// cosg: U(f) = sum{A[i]*cos(B[i]*f)}, i=1...spec
//		params order: A[1], B[1], A[2], B[2],..., A[spec], B[spec]
//	currently does not contain vdW and Coulomb scalling parameters
//
// OPA2 potential: K. Kahn, T. C. Bruice, J. Comp. Chem., 23, 2002, 977-996
// "Parameterization of OPLS-AA force field for the conformational analysis 
//  of macrocyclic polyketides"
// opa2: U(f) = A[0] + A[1]*(1+cos(f))+A[2]*(1-cos(2f))+A[3]*(1+cos(3f))+...
//		...+A[4]*(1-cos(4f))	
//	params order in mcgen DEF-file: 
// DIH site1 site2 site3 site4 opa2 7 ES VDW A[0] A[1] A[2] A[3] A[4]

class ATOMARG;

class BONDDEF //! Holds bond's force calculation parameters. Read from the DEFS-file.
{
private:

int id;
string label;
ATOMARG *atom[4];
Potkey potkey;
int forcenr;
double *force;
int filerow;
double scalar_cou, scalar_vdw;
bool excludes_longrange;

public:

BONDDEF();
~BONDDEF();
int set_id(int _id);
int set_label(const string &_label);
string get_label() const;
int get_id() const;
bool get_excludes_longrange() const;
int set_filerow(int _filerow);
int get_filerow() const;
int set_atom(int _nr, const string &_id);
int set_potkey(char *_potkey);
int set_forcenr(int _forcenr);
int set_force(int _nr, double _force);
int set_force(int _nr, double _force, bool _deg2rad);
const ATOMARG *get_atom(int _nr) const;
Potkey get_potkey() const;
const char *get_potkey_str() const;
int get_forcenr() const;
double get_force(int _nr) const;
double bond_energy(const double _ell) const;
//double bond_energy(double kei,double ell_0,double ell);
double angle_energy(const double _theta) const;
static double angle_energy(double theta_0,double theta,double kei);
double torsion_energy(const double _tau) const;
/*
double torsion_energy(Potkey _potkey,double tau,double a0,double a1,double a2,
	double a3,double a4,double a5,double a6);
*/

double get_scalar_cou() const;
double get_scalar_vdw() const;
int set_scalar_cou(double _scalar_cou);
int set_scalar_vdw(double _scalar_vdw);
int get_dlpoly_paramnr() const;
int get_if_dlpoly_needs_scalefactors() const;
BONDDEF make_dlpoly_compatible(BONDCLASS _bondclass) const;
};
#endif
