#ifndef _BOND_H_DEFINE
#define _BOND_H_DEFINE

using namespace std;

class BOND;
class BONDDEF;
class DEFS;

#include <string>
#include "four_atomref.h"
#include "bondclass.h"

class BOND:public FOUR_ATOMREF //! Holds one bond, angle, dihedral or exclude line, read from the FIELD file
{
private:

BONDDEF *bonddef;
int bondid;
int fieldlinenr;
public:

BOND();
int set_bondid(int _bondid);
int set_bondid(int _nrofatoms, int _bondid);
int set_bondid(int _nrofatoms, const string _bondid);
int set_fieldlinenr(int _fieldlinenr);
int get_fieldlinenr();
int get_bondid();
bool get_excludes_longrange();
BONDDEF *get_bonddef();
bool equals(int chainXid, int atom1id, int atom2id);
bool equals(int chain1id, int atom1id, int chain2id, int atom2id);
bool equals(int _chain1id, int _unit1id, int _atom1id,
	int _chain2id, int _unit2id, int _atom2id);
int sort();
BOND(const BOND &_original);
	// This method forces atoms in one BOND record to be in non-decreasing
	// order. To be used only for exclusions, not bonds.

};

//#include "bonddef.h"

#endif
