#include "bond.h"
#include "defs.h"
#include "mcgen.h"

//========== constructor BOND ==========

BOND::BOND(): FOUR_ATOMREF()
{
bonddef=0;
fieldlinenr=0;
bondid=0;
}

//========== method get_bondid ==========

int BOND::get_bondid()
{
return bondid;
}

//========== method get_excludes_longrange ==========

bool BOND::get_excludes_longrange()
{
if (bonddef)
	return bonddef->get_excludes_longrange();
else
	return true;
}

//========== method get_bonddef ==========

BONDDEF *BOND::get_bonddef()
{
return bonddef;
}

//========== method set_bondid ==========

int BOND::set_bondid(int _nrofatoms, int _bondid)
{
bondid=_bondid;
bonddef=defs->get_bond(_nrofatoms,_bondid);
return 0;
}

//========== method set_bondid ==========

int BOND::set_bondid(int _nrofatoms, const string _bondid)
{
bonddef=defs->get_bond(_nrofatoms,_bondid);
bondid=bonddef->get_id();
return 0;
}

//========== method set_fieldlinenr ==========

int BOND::set_fieldlinenr(int _fieldlinenr)
{
fieldlinenr=_fieldlinenr;
return 0;
}

//========== method get_fieldlinenr ==========

int BOND::get_fieldlinenr()
{
return fieldlinenr;
}

//========== method equals ==========

bool BOND::equals(int chainXid, int atom1id, int atom2id)
{
return (chainid[0]==chainXid) and (chainid[1]==chainXid) and
	(unitid[0]==0) and (unitid[1]==0) and
	(atomid[0]==atom1id) and (atomid[1]==atom2id);
}

//========== method equals ==========

bool BOND::equals(int chain1id, int atom1id, int chain2id, int atom2id)
{
return (chainid[0]==chain1id) and (chainid[1]==chain2id) and
	(unitid[0]==0) and (unitid[1]==0) and
	(atomid[0]==atom1id) and (atomid[1]==atom2id);
}

//========== method equals ==========

bool BOND::equals(int _chain1id, int _unit1id, int _atom1id,
	int _chain2id, int _unit2id, int _atom2id)
{
return (chainid[0]==_chain1id) and (chainid[1]==_chain2id) and
	(unitid[0]==_unit1id) and (unitid[1]==_unit2id) and
	(atomid[0]==_atom1id) and (atomid[1]==_atom2id);
}

//========== method sort ==========

int BOND::sort()
{
int t;

if ((unitid[0]>unitid[1]) or (unitid[0]==unitid[1] and atomid[0]>atomid[1]))
{
	t=chainid[0];
	chainid[0]=chainid[1];
	chainid[1]=t;
	t=unitid[0];
	unitid[0]=unitid[1];
	unitid[1]=t;
	t=atomid[0];
	atomid[0]=atomid[1];
	atomid[1]=t;
}
return 0;
}

/*!
    \fn BOND::BOND(BOND &_original)
    \brief Copy constructor
 */
BOND::BOND(const BOND &_original): FOUR_ATOMREF(_original)
{
bonddef=_original.bonddef;
fieldlinenr=_original.fieldlinenr;
bondid=_original.bondid;
}
