#include "atomdef.h"
#include "mcgen.h"

//========== method set_method ==========

int ATOMDEF::set_method(AtomMethod _method)
{
method=_method;
return 0;
}

//========== method set_method ==========

int ATOMDEF::set_method(const char *_method)
{
if (!strcmp(_method,"hydro"))
	return set_method(HYDRO);
else if (!strcmp(_method,"back"))
	return set_method(BACK);
else
{
	logfile.print("Error: unknown connection method '%s'. 'hydro' or 'back' expected.",_method);
	exit(1);
}

}

//========== method get_method ==========

AtomMethod ATOMDEF::get_method()
{
return method;
}

//========== method set_atomarg ==========

int ATOMDEF::set_atomarg(ATOMARG *_atomarg)
{
atomarg=_atomarg;
return 0;
}

//========== method get_atomarg ==========

ATOMARG *ATOMDEF::get_atomarg() const
{
return atomarg;
}

//========== method get_bondatomid ==========

int ATOMDEF::get_bondatomid()
{
return get_atomXid((method==BACK)?3:2);
}

//========== method get_bondunitid ==========

int ATOMDEF::get_bondunitid()
{
return get_unitXid((method==BACK)?3:2);
}
