#ifndef _ATOMCOMMON_H_DEFINE
#define _ATOMCOMMON_H_DEFINE

#include <assert.h>

class ATOMCOMMON //! ATOMCOMMON is a 3-dimensional location vector.
{
private:

bool has_coords;	// If has_coords==true then vector is valid.
		// If has_coords==false then coordinates should not be read.
double coord[3];

public:

int set_xcoord(const double _xcoord);
int set_ycoord(const double _ycoord);
int set_zcoord(const double _zcoord);
int set_coords(const double _x, const double _y, const double _z);
int set_coords(const ATOMCOMMON *_coords);
bool check_coords(const double _x, const double _y, const double _z);
// return true if set_coords with same arguments would change nothing.
int set_has_coords(const bool _has_coords);
double get_xcoord() const ;
double get_ycoord() const ;
double get_zcoord() const ;
bool get_has_coords() const;
		
};

#endif
