#include "atomcommon.h"
#include "mcgen.h"

//========== method set_xcoord ==========

int ATOMCOMMON::set_xcoord(const double _xcoord)
{
coord[0]=_xcoord;
return 0;
}

//========== method set_ycoord ==========

int ATOMCOMMON::set_ycoord(const double _ycoord)
{
coord[1]=_ycoord;
return 0;
}

//========== method set_zcoord ==========

int ATOMCOMMON::set_zcoord(const double _zcoord)
{
coord[2]=_zcoord;
return 0;
}

//========== method set_has_coords ==========

int ATOMCOMMON::set_has_coords(const bool _has_coords)
{
has_coords=_has_coords;
return 0;
}

//========== method set_coords ==========

int ATOMCOMMON::set_coords(const double _x, const double _y, const double _z)
{
coord[0]=_x;
coord[1]=_y;
coord[2]=_z;
has_coords=true;
return 0;
}

//========== method set_coords ==========

int ATOMCOMMON::set_coords(const ATOMCOMMON *_coords)
{
coord[0]=_coords->coord[0];
coord[1]=_coords->coord[1];
coord[2]=_coords->coord[2];
has_coords=true;
return 0;
}

//========== method check_coords ==========

bool ATOMCOMMON::check_coords(const double _x, const double _y, const double _z)
{
return	has_coords and
	(abs(coord[0] - _x)<INFINITESIMAL) and
	(abs(coord[1] - _y)<INFINITESIMAL) and
	(abs(coord[2] - _z)<INFINITESIMAL);
}

//========== method get_xcoord ==========

double ATOMCOMMON::get_xcoord() const
{
assert(this);
assert(has_coords);
return coord[0];
}

//========== method get_ycoord ==========

double ATOMCOMMON::get_ycoord() const
{
assert(this);
assert(has_coords);
return coord[1];
}

//========== method get_zcoord ==========

double ATOMCOMMON::get_zcoord() const
{
assert(this);
assert(has_coords);
return coord[2];
}

//========== method get_has_coords ==========

bool ATOMCOMMON::get_has_coords() const
{
assert(this);
return has_coords;
}

