#ifndef _ATOMARG_H_DEFINE
#define _ATOMARG_H_DEFINE

#include <string.h>
#include <set>

using namespace std;

#define ATOMLABELLEN 4
// ATOMLABELLEN ei tohi suuremaks teha, kuna dlpoly ei suuda pikemaid
// sisse lugeda.

class ATOMARG //! Describes an atom's general properties: mass, charge etc.
{
private:

int id;
char label[ATOMLABELLEN+1];
double mass;
double charge;
double radius;
set<ATOMARG*> blind_atoms; // list of atoms that don't see the current atom.

public:

int set_id(int _id);
int set_label(char *_label);
int set_mass(double _mass);
int set_charge(double _charge);
int set_radius(double _radius);

int get_id();
const char *get_label() const;
double get_mass();
double get_charge();
double get_radius();
int add_blindatom(ATOMARG *_blind);
bool is_invisible_for(ATOMARG *_otheratom);

};

#endif

