#include "atomarg.h"
#include <cassert>

//========== method set_label ==========

int ATOMARG::set_label(char *_label)
{
strncpy(label,_label,ATOMLABELLEN+1);
label[ATOMLABELLEN]=0;
return 0;
}

//========== method set_id ==========

int ATOMARG::set_id(int _id) 
{
id=_id;
return 0;
}

//========== method set_mass ==========

int ATOMARG::set_mass(double _mass) 
{
mass=_mass;
return 0;
}

//========== method set_charge ==========

int ATOMARG::set_charge(double _charge) 
{
charge=_charge;
return 0;
}

//========== method set_radius ==========

int ATOMARG::set_radius(double _radius) 
{
radius=_radius;
return 0;
}

//========== method get_id ==========

int ATOMARG::get_id() 
{
return id;
}

//========== method get_label ==========

const char *ATOMARG::get_label() const
{
return label;
}

//========== method get_mass ==========

double ATOMARG::get_mass() 
{
return mass;
}

//========== method get_charge ==========

double ATOMARG::get_charge() {return charge;
}

//========== method get_radius ==========

double ATOMARG::get_radius() 
{
return radius;
}

//========== method add_blindatom ==========

int ATOMARG::add_blindatom(ATOMARG *_blind)
{
blind_atoms.insert(_blind);
return 0;
}

//========== method is_invisible_for ==========

bool ATOMARG::is_invisible_for(ATOMARG *_otheratom)
{
assert(this);
assert(_otheratom);
if (blind_atoms.count(_otheratom) != 0)
	return true;
else
	return false;
}
