#ifndef _ATOM_
#define _ATOM_

#include <assert.h>
#include <cmath>
#include <stdio.h>
#include <set>
#include <list>

class ATOM;
class UNIT;
class MOLECULE;

#ifndef _MATHFUNC
#define _MATHFUNC
#include "mathfunc.h"
#endif

#include "bondinst.h"
#include "atomdef.h"
#include "defs.h"
#include "image.h"

#define _ATOM_place_OK_ 0
#define _ATOM_place_MISSINGATOM_ 1
#define _ATOM_place_GEOMFAIL_ 2
#define _HISTORY_BREAKPOINT_ 0

// from mcpoly.h:
#define BC 1.38066e-23
// BC is Bolzmann constant k = 1.3806503e-23 J/K

class ATOM:public ATOMCOMMON //! Represents one atom while generating: its coordinates, its bonds and pointers to info about how to generate new coordinates for that atom.
{
private:

UNIT *unit; //!< unit that this atom belongs to
int index;  //!< which one of this unit's atoms is it. Combination of (unit,index) should give an unique id;
int oid; //!< Outputted atom ID for the FIELDOUT.INI file

ATOMDEF *atomdef;
ATOMARG *atomarg;
set <ATOM*> connected_atoms;
set <ATOM*> immediately_connected_atoms;

AtomMethod con_meth;
ATOM *con_atom[3];
CONSTDEF *con_const, *con_cang, *con_cdih;

static list<ATOM*> atoms_placement_order;
int atoms_placement_order_id;
static list<ATOM*>::iterator next_placement;
static int placed_count;
list<BONDINST> forcelist;

public:

MATHFUNC mat;

ATOM();

int add_to_atoms_placement_order();
static int place_next(ENERGY &_energy);
int place();
	// This method takes an ATOMDEF object as its input and places the ATOM
	// accordingly.
	// Result goes into coord[] and has_coords fields of the ATOM.
	// _recursion_enabled tells whether to recurrently place
	// previous atoms if they appear to be missing or give an
	// error message.

int place_randomly();
	// Generates random coordinates for the atom.
	// Used to place atoms in virtual seed and tail units.

// This method generaLizes calcback and calchydro.
// Input:  _dep_atoms = array of pointers to the three atoms that current
//                      atom is connected to.
//         _bon = pointer to the const definition
//         _ang = pointer to the constangle definition
//         _dih = pointer to the constdih definition
//         _method = which method to use, calcback or calcangle
// Output: always zero
int calcatom(ATOM *_dep_atoms[3],
	CONSTDEF *_bon, CONSTDEF *_ang, CONSTDEF *_dih, AtomMethod _method);

/*
selle meetodi sisendiks on kome aatomi koordinaadid, sideme pikkus komanda
ja neljanda ehk siis genereeritava aatomi vahel, dihedraalnurk ja nurk
teise-kolmanda-neljanda aatomi vahel...
*/
void calcback(double x1,double y1,double z1,double x2,double y2,
              double z2,double x3,double y3,double z3,double bond,
              double dihan,double alpha);
/*
see on selliste aatomite lisamiseks, mis pole mitte backbones, vaid on
nagu PEO vesinikud...

C1--C2--O1--C3--C4--O2
    |
        H1

        nt. sobib see H1 lisamiseks, aga C1, C2 ja O1 koordinaadid peavad olema
        olemas...btw...see sobiks nt. krvalahela alustamiseks...;)
  */
void calchydro(double x1,double y1,double z1,double x2,double y2,
               double z2,double x3,double y3,double z3,double bond,
               double dihan,double alpha);
static double vdw_energy(double ln1,int indx,double b1,double b2, double b3,
                  double b4,double b5);
static double vdw_energy(const ATOM *_atom1, const ATOM *_atom2, double _distance);
static double coulomb_energy(double qi,double qj,double ln1,double cconst);
static double coulomb_energy(const ATOM *_atom1, const ATOM *_atom2, double _distance);
static double energy_exp(double energy,double temperature); // input: kcal/mol
static double energy_exp(double energy);                    // input: kcal/mol

int set_atomarg(string _atomname);
int set_atomdef(ATOMDEF *_atomdef);
ATOMDEF *get_atomdef() const;
ATOMARG *get_atomarg() const;

int set_unit(UNIT *_unit);
UNIT *get_unit() const;
int set_index(int _index);
int get_index() const;

double distance_from_atom(const ATOM &_atom2) const;
static double distance(const ATOM *_atom1, const ATOM *_atom2);
static double angle(const ATOM *_atom1, const ATOM *_atom2, const ATOM *_atom3);
static double dihedral(const ATOM *_atom1, const ATOM *_atom2, const ATOM *_atom3, const ATOM *_atom4);
bool overlaps_with(ATOM &_atom2);
const char *get_label() const;
static ATOM *take_back_one_atom();
bool has_connection_with(ATOM *_otheratom);
/*string get_connections();*/

string get_location() const;
//bool has_previousatom(ATOM *_previousatom);
//ATOM *get_previousatom();
double get_charge() const;
double get_radius() const;
int get_atomid() const;
bool satisfies_geomconstraints();
bool has_overlaps();
//string connected_atoms_str();
int restore_connected_atoms();
unsigned int get_number_of_connected_atoms();
int set_oid(int _oid);
int get_oid() const;
static int get_placed_count();
int get_atoms_placement_order_id() const;
int add_to_forcelist(const BONDINST &_force);
int add_energy(ENERGY &_energy);
bool has_similar_forcelist(ATOM *_atom2, int _delta);
list<BONDINST>::iterator get_forcelist_begin();
list<BONDINST>::iterator get_forcelist_end();
static int check_all_forcelists(MOLECULE *_molecule);
static int check_pair_potentials(ATOM *a[4]);
static int check_triple_potentials(ATOM *a[4]);
static int check_quad_potentials(ATOM *a[4]);
void save_connection(ATOM *_atom2);
int save_connections ( ATOM *_dep_atoms[3] );
};

#endif
