#define ALL_ATOMS 0

class UNIT {
	public:
		int id;
		enum(BEGIN,CROSS,END) unittype;
		int unitid;
		UNIT *previousunit;
		UNIT *nextmainunit;	// default: NULL
		UNIT *nextsideunit;	// default: NULL
		int atoms;
		ATOM atoms[0];
		bool hasenergycalculated;
		double enery;
		int distance_from_last_cross;
		int distance_from_chainbegin;
		CHAIN *chain;
		CONNECT_DEREFERENCED connect;
		UNIT(UNIT *previousunit, enum(MAIN,SIDE) connectmode);
		~UNIT();
		int place(int atom);	// default: atom=ALL_ATOMS;
		double calculate_energy();
}

class ATOM {
	public:
		bool hascoords;	// default: false
		real coord[3];
		void place(U1,A1,U2,A2,U3,A3,dih,ang,con);
}

class CHAIN {
	public:
		CONNECT connectdefault;
		CONNECT connectfirst;
		CONNECT connectcross;
		CONNECT connect2cross;
}

class CONNECT_DEREFERENCED {
	public:
		//int connectblocksize; // default: 3
		UNIT* unit[3];
		int atom[3];
		CONNECT_DEREFERENCED(CONNECT connect);
}

class CONNECT {
	public:
		//int connectblocksize; // default: 3
		int unitid[3];
		int atomid[3];
}

class TODO_LIST {
	public:
		int size; // default: 0
		UNIT* unit[0];
		UNIT* getfirst(void);
		void insert_as_last(UNIT* unit);
		bool is_empty(void);
}

// globaalmuutujad:
// 	TODO_LIST list_main_A;
// 	TODO_LIST list_side;
// 	TODO_LIST list_main_B;

class HISTORY {
	private:
		int size; // default: 0
		HISTORYRECORD record[0];
	public:
		HISTORYRECORD getlast(void);
		void newunit(UNIT* unit);
		void newatom(UNIT* unit, int atom);
		void breakpoint(void);
		void chainend(UNIT* unit);
}

class HISTORYRECORD {
	public:
		enum(UNIT,ATOM,BREAKPOINT,CHAINEND) action;
		UNIT* unit;	// default: NULL
		int atom;	// default: 0
}

