//       Class: sysutils
//     Version: sysutils-00.01.03-040103 by cipo@ut.ee
//      Author: cipo@ut.ee
// Description: contains file and string utilities

#ifndef _SYSUTILS_H_DEFINE
#define _SYSUTILS_H_DEFINE

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include <iostream>
#include <string>
#include <algorithm>
#include <cctype>
#include <iomanip>

using namespace std;

#define _SYSUTILS_VERSION "Version: sysutils-00.01.03-040103 by cipo@ut.ee\0"

#define _SYSUTIL_TSTRING_LEN 30
#define _SYSUTIL_TSTRING_LEN_S 5
#define _SYSUTILS_TSTRING_LEN 30
#define _SYSUTILS_TSTRING_LEN_S 5
#define _SYSUTILS_INPROW_LEN 300
#define _SYSUTILS_COMMAND_LINEERR 1
#define _SYSUTILS_MEMERR 3
#define _SYSUTILS_IOERR 4
#define _SYSUTILS_DOUBLE_ERROR_VALUE 1.0E99

#define _SYSUTILS_INTVALUE_FIELD_WIDTH 8
#define _SYSUTILS_DOUBVALUE_FIELD_WIDHT 9
#define _SYSUITLS_DOUBLE_VALUE_PRECISION 2

class SYSUTILS
{

private:
char inpstring[300]; //input string buffer from a line from a file
char *fgetsend;
int SYSUTILS_STRING_READ_STATUS;
//struct tm *time_now;
//time_t tnow;

public:
//methods
FILE *open_file(char *filename,char *filemode);
FILE *open_file(string filename,string filemode);
int close_file(FILE *fileaddr);
int compare_strings(const char *inputstring1,const char *inputstring2,const char *message1,const char *message2,const char *message3);
int comp_str(char *inputstring1,char *inputstring2);
bool compare_strings_nocase(string _inputstring1,string _inputstring2);
	//nocase comparing of _inputstring1 with _inputstring2
	//retruns true, if _inputstring1==_inputstring2
int string_to_upper(char *inputstring);
string string_to_upper(string _inputstring);
	//returns uppercase version of input string
char *time2string(char *_addbstring,char *_addastring);
int readfileline(FILE *_inputfile);
	//reads a line from a file; 
	//returns the status of feof (0 if not file end)
int test_filelinehash();
	//test if file begins with a '#' or empty line '\n'
	//return 0 if no '#' of '\n'
int nextfilerecord(FILE *_inputfile);
	//read in next line with # and empty line test
	//return the status of feof (0 if not file end)
int read_linestring(char *_outstring,int _position);
	//read string from position in the line
string SYSU_read_linestring(int _position);
	//returns string at position _position
int read_line100char(char *_outstring);//read 100 first chars in the line
string SYSU_read_line100char();
int read_lineint(int _position);//read int value at position
long read_linelong(int _position);//read long value from position
double read_linedouble(int _position);//read double value at position
int test_filelinestring(int _position,char *_comparestring1,char *_message1,
		char *_message2,int _errcode);
	//test if _comparestring1 finds in the line at _position
	//if not, exit; returns 0 othervise; no case
int test_filelinestring(int _position,string _comparestring,
		string _programname,string _inputfilename,int _errcode);
	//test if _comparestring finds in the line at _position
	//if not, exit; returns 1 othervise; no case
int test_string(int _position,char *_comparestring1); //test if string finds in the line, 0 - if yes; 1 - if no
int allocate_error(void *p,const char *message1,const char *message2,const int _errcode);
	//exits if memory allocation error
int SYSU_allocate_error(void *p,string _programName,string _variableName,
	const int _errorCode);
	//exits if memory allocation error
char *allocate_string(const int _count,const char *mess1,const char *mess2,
	const int errcode);
	//allocate memory for string
//string *SYSU_allocate_string(const int _count,string _programName,
//	string _variableName,const int errcode);
	//allocate memory for string array
char **allocate_string2(const int _count1,const int _count2,const char *mess1,
	const char *mess2,const int errcode);
	//allcate memory for string array
char ***allocate_string3(int _count1,int _count2,int _count3,char *mess1,char *mess2,int errcode);//allocate memory for string _count1x_count2 matrix
char ****allocate_string4(int _count1,int _count2,int _count3,int _count4,char *mess1,char *mess2,int errcode);//allocate memory for string _count1x_count2x_count3 matrix
char ***allocate_3string(int _count,char *mess1,char *mess2,int errcode);
int *allocate_int(int _count,char *mess1,char *mess2,int errcode);//allocate memory for int array
int **allocate_int2(int _count1,int _count2,char *mess1,char *mess2,int errcode);//allocate memory for int _count1x_caount2 matrix
int ***allocate_int3(int _count1,int _count2,int _count3,char *mess1,char *mess2,int errcode);//allocate memory for int _count1x_count2x_count3 matrix
int ****allocate_int4(int _count1,int _count2,int _count3,int _count4,char *mess1,char *mess2,int errcode);//allocate memory for int _count1x_count2x_count3x_count4 matrix
int **allocate_2int(int _count,char *mess1,char *mess2,int errcode);
int ***allocate_3int(int _count,char *mess1,char *mess2,int errcode);
long *allocate_long(int _count,char *mess1,char *mess2,int errcode);//allocate memory for long array
double *allocate_double(int _count,char *mess1,char *mess2,int errcode);
	//allocates memeory for double array
double *SYSU_allocate_double(const int _count,string _programName,
	string _variableName,const int _errorCode);
	//allocates memeory for double array
double **allocate_double2(int _count1,int _count2,char *mess1,char *mess2,int errcode);//allocate memory for double _count1x_count2 matrix
double ***allocate_double3(int _count1,int _count2,int _count3,char *mess1,char *mess2,int errcode);//allocate memroy for double _count1x_count2_count3 matrix
double ****allocate_double4(int _count1,int _count2,int _count3,int _count4,char *mess1,char *mess2,int errcode);//allocate memory for double _count1x_count2x_count3x_count4 matrix
double **allocate_2double(int _count,char *mess1,char *mess2,int errcode);
double ***allocate_3double(int _count,char *mess1,char *mess2,int errcode);
int cut_stringend(char *_inpstring);
string SYSU_cut_stringend(string _inputString);
char *SYSU_retr_linestring_pointer();
int SYSU_display_warning(string _programName,string _warningString);
int SYSU_error_exit(string _programName,string _warningString,int _errorCode);
int SYSU_error_exit_if_true(bool _value2compare,string _programName,
	string _warningString,int _errorCode);
int SYSU_error_exit_if_true(int _value2compare,string _programName,
	string _warningString,int _errorCode);
int SYSU_error_exit_if_not_true(bool _value2compare,string _programName,
	string _warningString,int _errorCode);
int SYSU_error_exit_if_not_true(int _value2compare,string _programName,
	string _warningString,int _errorCode);
int SYSU_display_processed_steps(const int _stepWidth,const int _outputStep,
	const int _timeWidth,const int _timePrecision,
	const double _outputTime);
	// displays timestep output info like:
	// #==>...timestep [_outputStep] @ [_outputTime] ps processed...
	// _stepWidth sets _outputStep field width aligned right
	// _timeWidth sets _outputTime field width aligned right
	// _timePrecision sets _outputTime precision displayed
};


#endif
