#include "sysutils.h"


//======================================
//========== Method open_file ==========
//======================================

FILE *SYSUTILS::open_file(const char *filename,const char *filemode)
{

FILE *tmpfn;

if((tmpfn=fopen(filename,filemode))==NULL)
{
	printf("IOERROR: Can not open file %s...\n",filename);
	exit(0);
}

lineCount=0;

return tmpfn;

};

//======================================
//========== Method open_file ==========
//======================================

FILE *SYSUTILS::open_file(string filename,string filemode)
{

FILE *tmpfn;

if((tmpfn=fopen(filename.c_str(),filemode.c_str()))==NULL)
{
	cout << "IOERROR: Can not open file " << filename << "..." << endl;
	exit(_SYSUTILS_IOERR);
}

lineCount=0;

return tmpfn;

};

//=======================================
//========== Method close_file ==========
//=======================================

int SYSUTILS::close_file(FILE *fileaddr)
{
int tmp;

tmp=fclose(fileaddr);
return tmp;
}

//============================================
//========== Method compare_strings ==========
//============================================

int SYSUTILS::compare_strings(const char *inputstring1,
		const char *inputstring2,const char *message1,
		const char *message2,const char *message3)
{

int cs=0;

//cs=string_to_upper(inputstring1);

if(strcasecmp(inputstring1,inputstring2)!=0)
{
  printf("%s %s %s %s\n",message1,inputstring2,message2,message3);
  exit(1);
}


return cs;

};

//=====================================
//========== Method comp_str ==========
//=====================================

int SYSUTILS::comp_str(char *inputstring1,char *inputstring2)
{

int cs=0;

//cs=string_to_upper(inputstring1);

cs=strcasecmp(inputstring1,inputstring2);

return cs;

};

//======================================================
//========== Method compompare_strings_nocase ==========
//======================================================

bool SYSUTILS::compare_strings_nocase(string _inputstring1,string _inputstring2)
{

int tmpValue=-1;
bool retValue=false;
string inputString1,inputString2;

inputString1=string_to_upper(_inputstring1);
inputString2=string_to_upper(_inputstring2);

tmpValue=inputString2.compare(0,inputString2.length(),
		inputString1);

if(tmpValue!=0) retValue=false;
	else
		retValue=true;

return retValue;

};


//============================================
//========== Method string_to_upper ==========
//============================================

int SYSUTILS::string_to_upper(char *inputstring)
{

int i;

for(i=0;i<int(strlen(inputstring));i++)
	inputstring[i]=toupper(inputstring[i]);

return i;

};

//============================================
//========== Method string_to_upper ==========
//============================================

string SYSUTILS::string_to_upper(string _inputstring)
{

string tmpString;

tmpString=_inputstring;

std::transform(tmpString.begin(),tmpString.end(),
		tmpString.begin(),(int(*)(int)) toupper);

return tmpString;

};

//========================================
//========== Method time2string ==========
//========================================

char *SYSUTILS::time2string(char *_addbstring,char *_addastring)
{

struct tm *current_time;
time_t tnow;
char *timestring,*outstring;	

time(&tnow);
current_time=localtime(&tnow);

outstring=allocate_string(_SYSUTIL_TSTRING_LEN,_SYSUTILS_VERSION,"outstring\0",2);
strcpy(outstring,_addbstring);
timestring=allocate_string(_SYSUTIL_TSTRING_LEN,_SYSUTILS_VERSION,"timestring\0",2);

strftime(timestring,_SYSUTIL_TSTRING_LEN,"%Y%m%d%H%M%S",current_time);

strcat(outstring,timestring);
strcat(outstring,_addastring);

delete timestring;

return outstring;

};

//==========================================
//========== Method readfileline ===========
//==========================================

int SYSUTILS::readfileline(FILE *_inputfile)
{

int filestatus=0;

strcpy(&inpstring[0],"\0");

fgetsend=fgets(inpstring,299,_inputfile);

#ifdef __DEBUG__
printf("readfileline: %s",inpstring);
cout << "readfileline2: " << fgetsend;
#endif

//cout << "# " << inpstring;
lineCount=lineCount+1;

filestatus=feof(_inputfile);

return filestatus;

};

//================================================
//========== Method SYSU_read_fileline ===========
//================================================

bool SYSUTILS::SYSU_read_fileline(FILE *_inputfile)
{

bool ifSuccess=false;

strcpy(&inpstring[0],"\0");

fgetsend=fgets(inpstring,_SYSUTILS_INPROW_LEN,_inputfile);

if(feof(_inputfile) || fgetsend==NULL)
 	ifSuccess=false;
else
{
	ifSuccess=true;
	lineCount=lineCount+1;
}

return ifSuccess;

};

//==============================================
//========== Method test_filelinehash ==========
//==============================================

int SYSUTILS::test_filelinehash()
{

int tmp=0;

if(strncasecmp(inpstring,"#",1)==0) tmp=1;

if(strcasecmp(fgetsend,"\n")==0) tmp=1;

return tmp;
	
};

//===========================================
//========== Method nextfilerecord ==========
//===========================================

int SYSUTILS::nextfilerecord(FILE *_inputfile)
{

int i=0,j=1,k=0;

while(j!=0 && k==0)
{
	k=readfileline(_inputfile);
	if(k==0) j=test_filelinehash();
	i=k;
}

return i;

};

//================================================
//========== Method SYSU_nextfilerecord ==========
//================================================

bool SYSUTILS::SYSU_nextfilerecord(FILE *_inputfile)
{

bool retStatus=true,hashStatus=true;

while(hashStatus && retStatus)
{
	retStatus=SYSU_read_fileline(_inputfile);
	if(retStatus) hashStatus=test_filelinehash();
//	exitStatus=retStatus;
//cout << retStatus << hashStatus << endl;
}

return retStatus;

};

//============================================
//========== Method read_linestring ==========
//============================================

int SYSUTILS::read_linestring(char *_outstring,int _position)
{

int i;
char *copystring,*ttstring;
const char delims[]="\x020,\t"; //delimiter of tokens: <space> <comma> <TAB>

SYSUTILS_STRING_READ_STATUS=0;

copystring=allocate_string(_SYSUTILS_INPROW_LEN,_SYSUTILS_VERSION,
	"copystring\0",2);
strcpy(copystring,inpstring);
ttstring=strtok(copystring,delims);

if(ttstring==NULL) SYSUTILS_STRING_READ_STATUS=0;

for(i=1;i<_position;i++)
{
	ttstring=strtok(NULL,delims);
}

if(ttstring==NULL)
{	
	SYSUTILS_STRING_READ_STATUS=0;
	strcpy(_outstring,"\0");
}
else
{
	strcpy(_outstring,ttstring);
	SYSUTILS_STRING_READ_STATUS=1;
}


delete copystring;

return SYSUTILS_STRING_READ_STATUS;

};

//=================================================
//========== Method SYSU_read_linestring ==========
//=================================================

string SYSUTILS::SYSU_read_linestring(int _position)
{

int i;
char *copystring,*ttstring;
const char delims[]="\x020,\t"; //delimiter of tokens: <space> <comma> <TAB>
string retValue;

retValue.erase();

SYSUTILS_STRING_READ_STATUS=0;

copystring=allocate_string(_SYSUTILS_INPROW_LEN,_SYSUTILS_VERSION,
	"copystring\0",2);
strcpy(copystring,inpstring);
ttstring=strtok(copystring,delims);

if(ttstring==NULL) SYSUTILS_STRING_READ_STATUS=0;

for(i=1;i<_position;i++)
{
	ttstring=strtok(NULL,delims);
}

if(ttstring==NULL)
{	
	SYSUTILS_STRING_READ_STATUS=0;
	retValue="\0";
}
else
{
	retValue.append(ttstring);
	SYSUTILS_STRING_READ_STATUS=1;
}


delete copystring;

return retValue;

};

/*
string SYSUTILS::SYSU_read_linestring(int _position)
{

int i;
char *tmpstring,*copystring;
const char delims[]="\x020,\t"; //delimiter of tokens: <space> <comma> <TAB>

string tmpValue;

SYSUTILS_STRING_READ_STATUS=0;

tmpstring=allocate_string(100,_SYSUTILS_VERSION,"tmpstring\0",2);
copystring=allocate_string(300,_SYSUTILS_VERSION,"copystring\0",2);
strcpy(copystring,inpstring);
tmpstring=strtok(copystring,delims);

if(tmpstring==NULL) SYSUTILS_STRING_READ_STATUS=1;

for(i=1;i<_position;i++)
{
	tmpstring=strtok(NULL,delims);
}

if(tmpstring==NULL)
{	
	SYSUTILS_STRING_READ_STATUS=1;
	tmpValue="\0";
	strcpy(_outstring,"\0");
}
else
	strcpy(_outstring,tmpstring);
//	tmpValue.append(tmpstring);

delete copystring;


return tmpValue;

};
*/
//=============================================
//========== Method read_line100char ==========
//=============================================

int SYSUTILS::read_line100char(char *_outstring)
{

int i=0;

i=sscanf(inpstring,"%100c",&_outstring[0]);

return i;

};

//==================================================
//========== method SYSU_read_line100char ==========
//==================================================

string SYSUTILS::SYSU_read_line100char()
{

//int i=0;
string tmpValue;
tmpValue.assign(inpstring,0,100);

//cout << "# "<< inpstring << endl ;
//i=sscanf(inpstring,"%100c",&_outstring[0]);

return tmpValue;

};

//=========================================
//========== Method read_lineint ==========
//=========================================

int SYSUTILS::read_lineint(int _position)
{

int i,tmp=-1;
char intstring[100];

i=read_linestring(&intstring[0],_position);

if(i==1) sscanf(intstring,"%d",&tmp);

return tmp;

};

//==============================================
//========== Method SYSU_read_lineint ==========
//==============================================

int SYSUTILS::SYSU_read_lineint(int _position)
{

int tmp=-1;
bool retStatus;
char intstring[100];

retStatus=read_linestring(&intstring[0],_position);

if(retStatus) sscanf(intstring,"%d",&tmp);

return tmp;

};
//==========================================
//========== Method read_linelong ==========
//==========================================

long SYSUTILS::read_linelong(int _position)
{

int i;
long tmp=-1;
char longstring[100];

i=read_linestring(&longstring[0],_position);
sscanf(longstring,"%ld",&tmp);

return tmp;

};

//============================================
//========== Method read_linedouble ==========
//============================================

double SYSUTILS::read_linedouble(int _position)
{
int i;
double tmp=0.0;
char doublestring[100];

i=read_linestring(&doublestring[0],_position);
if(i==1) sscanf(doublestring,"%lf",&tmp);

return tmp;

};

//=================================================
//========== Method SYSU_read_linedouble ==========
//=================================================

double SYSUTILS::SYSU_read_linedouble(int _position)
{

bool retStatus;
double tmp=0.0;
char doublestring[100];

retStatus=read_linestring(&doublestring[0],_position);
if(retStatus) sscanf(doublestring,"%lf",&tmp);

return tmp;

};

//=================================================
//=========== Method test_filelinestring ==========
//=================================================

int SYSUTILS::test_filelinestring(int _position,char *_comparestring1,char *_message1,char *_message2,int _errcode)
{

int i;
char teststring[100];

i=read_linestring(&teststring[0],_position);
if(strcasecmp(teststring,_comparestring1)!=0)
{
	printf("%s Can not find %s record in %s file...\n",_message1,_comparestring1,_message2);
	exit(_errcode);
}

return 0;

};

//=================================================
//=========== Method test_filelinestring ==========
//=================================================

int SYSUTILS::test_filelinestring(int _position,string _comparestring,string _programname,string _inputfilename,int _errcode)
{

int i;
char teststring[100];
string tmpString;

i=read_linestring(&teststring[0],_position);

tmpString.append(&teststring[0]);

if(!compare_strings_nocase(tmpString,_comparestring))
{
	cout << "#EE> " << _programname << ": can not find " << _comparestring 
		<< " record in " << _inputfilename << " file..." << endl;
	cout << "#==>...exiting..." << endl;
	exit(_errcode);
}

return 1;

};

//====================================================
//=========== Method test_filelinestringlnr ==========
//====================================================

int SYSUTILS::test_filelinestringlnr(int _position,string _comparestring,
		string _programname,string _inputfilename,int _errcode)
{

int i;
char teststring[100];
string tmpString;

i=read_linestring(&teststring[0],_position);

tmpString.append(&teststring[0]);

if(!compare_strings_nocase(tmpString,_comparestring))
{
	cout << _inputfilename << ":" << SYSU_retr_linecount()
		<< ": error: expected \"" << _comparestring << "\"." << endl;
	cout << _programname << ": exiting with error code "<<_errcode
		<<"." << endl;
	exit(_errcode);
}

return 1;

};

//=================================================
//=========== Method test_string ==========
//=================================================

int SYSUTILS::test_string(int _position,char *_comparestring1)
{

int i;
char *teststring;

teststring=allocate_string(100,_SYSUTILS_VERSION,"tmpstring\0",2);
//delete ttstring;
//strcpy(&teststring[0],"\0");
i=read_linestring(teststring,_position);
//cout << teststring << endl;

if(strcasecmp(teststring,_comparestring1)!=0)
	i=1;
else
	i=0;
delete teststring;
return i;

};

//==============================================
//=========== Method SYSU_test_string ==========
//==============================================

int SYSUTILS::SYSU_test_string(int _position,string _comparestring)
{

bool retStatus;
char *teststring;

teststring=allocate_string(_SYSUTILS_INPROW_LEN,_SYSUTILS_VERSION,
	"tmpstring\0",2);
retStatus=read_linestring(teststring,_position);

if(strcasecmp(teststring,_comparestring.c_str())!=0)
	retStatus=false;
else
	retStatus=true;

delete teststring;

return retStatus;

};

//===========================================
//========== Method allocate_error ==========
//===========================================

int SYSUTILS::allocate_error(void *p,const char *message1,const char *message2,const int _errcode)
{

if(p==NULL)
{
	printf("MEMERROR: %s can not allocate memory for %s...\n",message1,message2);
	exit(_errcode);
}

return 0;
};

//================================================
//========== method SYSU_allocate_error ==========
//================================================

int SYSUTILS::SYSU_allocate_error(void *p,string _programName,
	string _variableName,const int _errorCode)
{

string warningString="can not allocate memory for "+_variableName;
int retValue;

if(p==NULL)
	retValue=SYSU_error_exit(_programName,warningString,_errorCode);

return _errorCode;
};

//============================================
//========== Method allocate_string ==========
//============================================

char *SYSUTILS::allocate_string(const int _count,const char *mess1,
	const char *mess2,const int errcode)
{

int i;
char *allocstrtmp;

allocstrtmp=new char[_count];
i=allocate_error(allocstrtmp,mess1,mess2,errcode);

return allocstrtmp;

};

//=================================================
//========== method SYSU_allocate_string ==========
//=================================================
/*
string *SYSUTILS::SYSU_allocate_string(const int _count,string _programName,
	string _variableName,const int errcode)
{

int i;
string *allocstrtmp;

allocstrtmp=new string[_count];
i=SYSU_allocate_error(allocstrtmp,_programName,_variableName,errcode);

return allocstrtmp;

};
*/
//=============================================
//========== Method allocate_string2 ==========
//=============================================

char **SYSUTILS::allocate_string2(const int _count1,const int _count2,
	const char *mess1,const char *mess2,const int errcode)
{

int i,j;
char **allocstrtmp;

allocstrtmp=new char*[_count1];
i=allocate_error(allocstrtmp,mess1,mess2,errcode);
for(j=0;j<_count1;j++)
{

	allocstrtmp[j]=allocate_string(_count2,mess1,mess2,errcode+10);
}

return allocstrtmp;

};

//=============================================
//========== Method allocate_string3 ==========
//=============================================

char ***SYSUTILS::allocate_string3(int _count1,int _count2,int _count3,char *mess1,char *mess2,int errcode)
{

int i,j;
char ***allocstrtmp;

allocstrtmp=new char**[_count1];
i=allocate_error(allocstrtmp,mess1,mess2,errcode);
for(j=0;j<_count1;j++)
{

	allocstrtmp[j]=allocate_string2(_count2,_count3,mess1,mess2,errcode+10);
}

return allocstrtmp;

};

//=============================================
//========== Method allocate_string4 ==========
//=============================================

char ****SYSUTILS::allocate_string4(int _count1,int _count2,int _count3,int _count4,char *mess1,char *mess2,int errcode)
{

int i,j;
char ****allocstrtmp;

allocstrtmp=new char***[_count1];
i=allocate_error(allocstrtmp,mess1,mess2,errcode);
for(j=0;j<_count1;j++)
{

	allocstrtmp[j]=allocate_string3(_count2,_count3,_count4,mess1,mess2,errcode+10);
}

return allocstrtmp;

};

//=============================================
//========== Method allocate_3string ==========
//=============================================

char ***SYSUTILS::allocate_3string(int _count,char *mess1,char *mess2,int errcode)
{

char ***allocstrtmp,i;
allocstrtmp=new char**[_count];
i=allocate_error(allocstrtmp,mess1,mess2,errcode);

return allocstrtmp;

};

//=========================================
//========== Method allocate_int ==========
//=========================================

int *SYSUTILS::allocate_int(int _count,char *mess1,char *mess2,int errcode)
{

int *allocinttmp,i;
allocinttmp=new int[_count];
i=allocate_error(allocinttmp,mess1,mess2,errcode);

return allocinttmp;

};

//==========================================
//========== Method allocate_int2 ==========
//==========================================

int **SYSUTILS::allocate_int2(int _count1,int _count2,char *mess1,char *mess2,int errcode)
{

int **allocinttmp;
int i,j;

allocinttmp=new int*[_count1];
i=allocate_error(allocinttmp,mess1,mess2,errcode);

for(j=0;j<_count1;j++)
{

	allocinttmp[j]=allocate_int(_count2,mess1,mess2,errcode+10);
}

return allocinttmp;

};

//==========================================
//========== Method allocate_int3 ==========
//==========================================

int ***SYSUTILS::allocate_int3(int _count1,int _count2,int _count3,char *mess1,char *mess2,int errcode)
{

int ***allocinttmp;
int i,j;

allocinttmp=new int**[_count1];
i=allocate_error(allocinttmp,mess1,mess2,errcode);

for(j=0;j<_count1;j++)
{

	allocinttmp[j]=allocate_int2(_count2,_count3,mess1,mess2,errcode+10);
}

return allocinttmp;

};

//==========================================
//========== Method allocate_int4 ==========
//==========================================

int ****SYSUTILS::allocate_int4(int _count1,int _count2,int _count3,int _count4,char *mess1,char *mess2,int errcode)
{

int ****allocinttmp;
int i,j;

allocinttmp=new int***[_count1];
i=allocate_error(allocinttmp,mess1,mess2,errcode);

for(j=0;j<_count1;j++)
{

	allocinttmp[j]=allocate_int3(_count2,_count3,_count4,mess1,mess2,errcode+10);
}

return allocinttmp;

};

//==========================================
//========== Method allocate_2int ==========
//==========================================

int **SYSUTILS::allocate_2int(int _count,char *mess1,char *mess2,int errcode)
{

int **allocinttmp,i;
allocinttmp=new int*[_count];
i=allocate_error(allocinttmp,mess1,mess2,errcode);

return allocinttmp;

};

//==========================================
//========== Method allocate_3int ==========
//==========================================

int ***SYSUTILS::allocate_3int(int _count,char *mess1,char *mess2,int errcode)
{

int ***allocinttmp,i;
allocinttmp=new int**[_count];
i=allocate_error(allocinttmp,mess1,mess2,errcode);

return allocinttmp;

};

//==========================================
//========== Method allocate_4int ==========
//==========================================

int ****SYSUTILS::allocate_4int(int _count,char *mess1,char *mess2,int errcode)
{

int ****allocinttmp,i;
allocinttmp=new int***[_count];
i=allocate_error(allocinttmp,mess1,mess2,errcode);

return allocinttmp;

};

//==========================================
//========== Method allocate_long ==========
//==========================================

long *SYSUTILS::allocate_long(int _count,char *mess1,char *mess2,int errcode)
{

long *alloclongtmp,i;
alloclongtmp=new long[_count];
i=allocate_error(alloclongtmp,mess1,mess2,errcode);

return alloclongtmp;

};

//============================================
//========== Method allocate_double ==========
//============================================

double *SYSUTILS::allocate_double(int _count,char *mess1,char *mess2,int errcode)
{

double *allocdoubtmp;
int i;

allocdoubtmp=new double[_count];
i=allocate_error(allocdoubtmp,mess1,mess2,errcode);

return allocdoubtmp;

};

//=================================================
//========== method SYSU_allocate_double ==========
//=================================================

double *SYSUTILS::SYSU_allocate_double(const int _count,string _programName,
	string _variableName,const int _errorCode)
{

double *allocdoubtmp;
int i;

allocdoubtmp=new double[_count];
i=SYSU_allocate_error(allocdoubtmp,_programName,_variableName,_errorCode);

return allocdoubtmp;

};

//=============================================
//========== Method allocate_double2 ==========
//=============================================

double **SYSUTILS::allocate_double2(int _count1,int _count2,char *mess1,char *mess2,int errcode)
{

double **allocdoubtmp;
int i,j;

allocdoubtmp=new double*[_count1];
i=allocate_error(allocdoubtmp,mess1,mess2,errcode);

for(j=0;j<_count1;j++)
{

	allocdoubtmp[j]=allocate_double(_count2,mess1,mess2,errcode+10);
}

return allocdoubtmp;

};

//=============================================
//========== Method allocate_double3 ==========
//=============================================

double ***SYSUTILS::allocate_double3(int _count1,int _count2,int _count3,char *mess1,char *mess2,int errcode)
{

double ***allocdoubtmp;
int i,j;

allocdoubtmp=new double**[_count1];
i=allocate_error(allocdoubtmp,mess1,mess2,errcode);

for(j=0;j<_count1;j++)
{

	allocdoubtmp[j]=allocate_double2(_count2,_count3,mess1,mess2,errcode+10);
}

return allocdoubtmp;

};

//=============================================
//========== Method allocate_double4 ==========
//=============================================

double ****SYSUTILS::allocate_double4(int _count1,int _count2,int _count3,int _count4,char *mess1,char *mess2,int errcode)
{

double ****allocdoubtmp;
int i,j;

allocdoubtmp=new double***[_count1];
i=allocate_error(allocdoubtmp,mess1,mess2,errcode);

for(j=0;j<_count1;j++)
{

	allocdoubtmp[j]=allocate_double3(_count2,_count3,_count4,mess1,mess2,errcode+10);
}

return allocdoubtmp;

};

//=======================================-=====
//========== Method allocate_2double ==========
//=============================================

double **SYSUTILS::allocate_2double(int _count,char *mess1,char *mess2,int errcode)
{

double **allocdoubletmp,i;
allocdoubletmp=new double*[_count];
i=allocate_error(allocdoubletmp,mess1,mess2,errcode);

return allocdoubletmp;

};

//=======================================-=====
//========== Method allocate_3double ==========
//=============================================

double ***SYSUTILS::allocate_3double(int _count,char *mess1,char *mess2,int errcode)
{

double ***allocdoubletmp,i;
allocdoubletmp=new double**[_count];
i=allocate_error(allocdoubletmp,mess1,mess2,errcode);

return allocdoubletmp;

};

//==========================================
//========== Method cut_stringend ==========
//==========================================

int SYSUTILS::cut_stringend(char *_inpstring)
{

int i;
size_t t;
char *_tmpstring;

i=strlen(_inpstring);

t=strcspn(_inpstring,"\n");

_tmpstring=allocate_string(t+1,_SYSUTILS_VERSION,"_tmpstring\0",3);	
strcpy(_tmpstring,"\0");

strncat(_tmpstring,_inpstring,t);
strcat(_tmpstring,"\0");
strcpy(_inpstring,_tmpstring);

delete _tmpstring;	

return t;

};

//===============================================
//========== Method SYSU_cut_stringend ==========
//===============================================

string SYSUTILS::SYSU_cut_stringend(string _inputString)
{

int i;
size_t t;
char *_tmpstring;
string tmpValue;

tmpValue.erase();

i=strlen(_inputString.c_str());

t=strcspn(_inputString.c_str(),"\n");

_tmpstring=allocate_string(t+1,_SYSUTILS_VERSION,"_tmpstring\0",3);	
strcpy(_tmpstring,"\0");

strncat(_tmpstring,_inputString.c_str(),t);
strcat(_tmpstring,"\0");
//strcpy(_inpstring,_tmpstring);
tmpValue.insert(0,_tmpstring);

delete _tmpstring;	

return tmpValue;

};

//=========================================================
//========== Method SYSU_retr_linestring_pointer ==========
//=========================================================

char *SYSUTILS::SYSU_retr_linestring_pointer()
{

return &inpstring[0];
	
}

//=================================================
//========== method SYSU_dispaly_warning ==========
//=================================================

int SYSUTILS::SYSU_display_warning(string _programName,string _warningString)
{

cout << "#EE> " << _programName << ": " << _warningString << endl;

return 0;

};	

//===============================================
//========== method SYSU_exit_if_error ==========
//===============================================

int SYSUTILS::SYSU_error_exit(string _programName,string _warningString,
	int _errorCode)
{
int i;

i=SYSU_display_warning(_programName,_warningString);
cout << "#==>...exiting..." << endl;
exit(_errorCode);

return _errorCode;
};

//====================================================
//========== method SYSU_error_exit_if_true ==========
//====================================================

int SYSUTILS::SYSU_error_exit_if_true(bool _value2compare,string _programName,
	string _warningString,int _errorCode)
{

if(_value2compare)
	SYSU_error_exit(_programName,_warningString,_errorCode);

return 0;
};

//====================================================
//========== method SYSU_error_exit_if_true ==========
//====================================================

int SYSUTILS::SYSU_error_exit_if_true(int _value2compare,string _programName,
	string _warningString,int _errorCode)
{

if(_value2compare!=0)
	SYSU_error_exit(_programName,_warningString,_errorCode);

return 0;
};


//========================================================
//========== method SYSU_error_exit_if_not_true ==========
//========================================================

int SYSUTILS::SYSU_error_exit_if_not_true(bool _value2compare,
	string _programName,string _warningString,int _errorCode)
{

if(!_value2compare)
	SYSU_error_exit(_programName,_warningString,_errorCode);

return 1;
};

//========================================================
//========== method SYSU_error_exit_if_not_true ==========
//========================================================

int SYSUTILS::SYSU_error_exit_if_not_true(int _value2compare,
	string _programName,string _warningString,int _errorCode)
{

if(_value2compare==0)
	SYSU_error_exit(_programName,_warningString,_errorCode);

return 1;
};

//=========================================================
//========== method SYSU_display_processed_steps ==========
//=========================================================

int SYSUTILS::SYSU_display_processed_steps(const int _stepWidth,
		const int _outputStep,const int _timeWidth,
		const int _timePrecision,const double _outputTime)
{

cout << "#==>...timestep [";
cout.width(_stepWidth);
cout << _outputStep << "] @ [";
cout.width(_timeWidth);
cout.setf(ios::fixed | ios::showpoint);
cout << setprecision(_timePrecision);
cout << _outputTime << "] ps processed..." << endl;
	
return 0;
};

//=================================================
//========== method SYSU_reset_linecount ==========
//=================================================

int SYSUTILS::SYSU_reset_linecount()
{

lineCount=0;

return lineCount;

}

//===============================================
//========== method SYSU_set_linecount ==========
//===============================================

int SYSUTILS::SYSU_set_linecount(const int _lineCount)
{

lineCount=_lineCount;
return lineCount;

}

//================================================
//========== method SYSU_retr_linecount ==========
//================================================

int SYSUTILS::SYSU_retr_linecount()
{

return lineCount;

}


