//  Class: fieldout
//Version: fieldout2-20090427 by cipo@ut.ee
// Author: cipo@ut.ee
//Description: class to generate DL_POLY FIELD file
// fieldout ini file format:
//forces description//
// "FORCES"
// "ATOMTYPES" int ATOMTYPES
// "ATOMTYPE" int atid char atlabel double atmass double atcharge
// {repeated int ATOMTYPES times}
// "SHELLS" int SHELLS
// "SHELL" int shellid double shellspring
// {repeated int SHELLS times}
// "CONSTRAINTS" int CONSTRAINTS
// "CONST" int constid double constlen
// {repeated int CONSTRAINTS times}
// "BONDS" int BONDS
// "BOND" int bondid char[4] bondtype int bondforcenr double bondforce[0] ...
// bondforce[bondforcenr-1]
// {repeated int BONDS times}
// "ANGLES" int ANGLES
// "ANGLE" int angid char[4] angtype int angforcenr double angforce[0] ...
// angforce[angforcenr-1]
// {repeated int ANGLES times}
// "DIHEDRALS" int DIHEDRALS
// "DIH" int dihid char[4] dihtype int dihforcenr double dihforce[0] ... 
//  dihforce[dihforcenr-1]
// {repeated int DIHEDRALS times}
//"TETHSF" int TETHS
//"TETHF" char[4] tethkey int tethforcenr double 
//	tethforce[1]..double tethforce[tethforcenr]
// "VDWS" int VDWS
// "VDW" int vdwid char[4] vdwtype int vdwsite1 int vdwsite2 int vdwforcenr
//      double vdwforce[0] ... vdwforce[vdwforcenr-1]
// {repeated int VDWS times}
//_BOND_FORCES,_ANG_FORCES,_DIH_FORCES,_VDW_FORCES - number of force
//constraints; defined in the fieldout.h file
//now actual field description begins
// "FIELD"
// char[80] SYSHEADER - FIELD file header
// "UNITS" "kcal"
// "MOLECULES" int MOLECULES
// {following structure repeated int MOLECULES times}
// char[80] MOLHEADER - molecule name
// "NUMMOLS" int NUMMOLS - number of this type of molecule in the structure
// "ATOMGROUPS" int ATOMSGROUPS
// {following structure until "CONSTGROUPS" repeated int ATOMGROUPS times - 
//  number of "ATOMS" records}
// "ATOMS" int ATOMS int atomscount
// {int ATOMS - number of following "ATOM" records;
//  int atomcounts - number of times to repeat following "ATOM" records in the 
//  FIELD file}
// "ATOM" int atomtype int atomrepeat
// {int atomtype - atom type from "FORCES" section
//  int atomrepeat - atom repeat counter in the FIELD file}
//  {repeated int ATOMS times}
//SHELLS x - not implemented yet
//SHELL type mol1 site1 mol2 site2 - not implemented yet
// "CONSTGROUPS" int CONSTGROUPS
// {following structure until "BONDGROUPS" repeated int CONSTGROUPS times - 
//  number of "CONSTS" records}
// "CONSTS" int CONSTS int constscount
// {int CONSTS - number of following "CONST" records;
//  int constscounts - number of times to repeat following "CONST" records in 
//                     the FIELD file}
// "CONST" int consttype int constsite1 int conststep1 int constsite2 
//       int conststep2
// {int consttype - constraint type in the "FORCES" section
//  int constsiteX - atom number in the molecule within NUMMOL
//  int conststepX - steps to add to get the same atom of the next constraint 
//                   of the same type}
// {repeated int CONSTS times}
// "BONDGROUPS" int BONDGROUPS
// {following structure until "ANGGROUPS" repeated int BONDGROUPS times - 
//  number of "BONDSS" records}
// "BONDS" int BONDSS int bondscount
// {int BONDSS - number of following "BOND" records;
//  int bondscounts - number of times to repeat following "BOND" records in 
//                     the FIELD file}
// "BOND" int bondstype int bondssite1 int bondsstep1 int bondssite2 
//       int bondsstep2
// {int bondstype - bond type in the "FORCES" section
//  int bondssiteX - atom number in the molecule within NUMMOL
//  int bondsstepX - steps to add to get the same atom of the next bond of 
//                   the same type}
// {repeated int BONDSS times}
// "ANGGROUPS" int ANGGROUPS
// {following structure until "DIHGROUPS" repeated int ANGGROUPS times - 
//  number of "ANGS" records}
// "ANGS" int ANGS int angscount
// {int ANGS - number of following "ANG" records;
//  int angscounts - number of times to repeat following "ANG" records in 
//                     the FIELD file}
// "ANG" int angstype int angsite1 int angstep1 int angsite2 
//       int angstep2 int angsite3 int angstep3
// {int angstype - angle type in the "FORCES" section
//  int angsiteX - atom number in the molecule within NUMMOL
//  int angstepX - steps to add to get the same atom of the next angle of 
//                   the same type}
// {repeated int ANGLES times}
// "DIHGROUPS" int DIHGROUPS
// {following structure until "FINISH" repeated int DIHGROUPS times - 
//  number of "DIHS" records}
// "DIHS" int DIHS int dihscount
// {int DIHS - number of following "DIH" records;
//  int dihscounts - number of times to repeat following "DIH" records in 
//                     the FIELD file}
// "DIH" int dihstype int dihsite1 int dihstep1 int dihsite2 
//       int dihstep2 int dihsite3 int dihstep3 int dihsite4 int dihstep4
// {int dihstype - dihedral type in the "FORCES" section
//  int dihsiteX - atom number in the molecule within NUMMOL
//  int dihstepX - steps to add to get the same atom of the next dihedral of 
//                   the same type}
// {repeated int DIHS times}
// RIGIDGROUPS int RIGIDGROUPS
// {following structure until "FINISH" repeated int RIGIDGROUPS times - 
//  number of "RIGIDS" records}
// "RIGIDS" int RIGIDS int rigidscount
// {int RIGIDS - number of following "RIGID" records;
//  int rigidscounts - number of times to repeat following "RIGID" records in 
//                     the FIELD file}
// "RIGID" int rigidnr int rigidsite1 int rigidstep1 {int rigidnr times}
// {int rigidnr - number of rigid sites
//  int rigidsiteX - rigid site index in the molecule within NUMMOL
//  int rigidstepX - steps to add to get the same atom of the next rigid 
//			complex of the same type}
// {repeated int RIGIDS times}
// "TETHGROUPS" int TETHGROUPS
// {following structure until "FINISH" repeated int TETHGROUPS times - 
//  number of "TETHS" records}
// "TETHS" int TETHS int tethcount
// {int TETHS - number of following "TETH" records;
//  int tethcounts - number of times to repeat following "TETH" records in 
//                     the FIELD file}
// "TETH" int tethtype int tethsite int tethstep1 
// {int tethtype - teth type in the "FORCES" section
//  int tethsite - atom number in the molecule within NUMMOL
//  int tethstep - steps to add to get the same atom of the next tehtered atom 
//                of the same type}
// {repeated int TETHS times}
// "FINISH" - the end of the molecule
// {next molecules follow, if any}
// "CLOSE"

#include <vector>
#include <string>
#include <iostream>
#include <map>
#include <sstream>

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#ifndef _SYSUTILS
#define _SYSUTILS
#include "sysutils.h"
#endif


#ifndef _FIELDOUT_VERSION
#define _FIELDOUT_VERSION "Version: fieldout2-20090427 by cipo@ut.ee\0"
#define _UNITS "kcal\0"
#define SYLV "sylv\0"
#define SYLV_PARAMS1 2
#define SYLV_PARAMS2 9
#define COSB "cosb\0"
#define COSB_PARAMS1 2
#define COSB_PARAMS2 9
#define COSB_PARAMS3 13
#define TORV "torv\0"
#define TORV_PARAMS1 2
#define TORV_PARAMS2 9
#define COS5 "cos5\0"
#define COS5_PARAMS1 2
#define COS5_PARAMS2 7
#define ZERO "zero\0"
#define ANDI "andi\0"
#define ANDI_PARAMS1 2
#define ANDI_PARAMS2 9
#endif

class FIELDOUT:SYSUTILS
{

private:

typedef enum {FATOMTYPE,FBOND,FCONSTRAINT,FANGLE,FDIH,FINV,FFIELD,FTETH,FVDW} _forces;
typedef enum {GATOMS,GBONDS,GCONSTS,GANGLES,GDIHS,GINVS,GRIGIDS,GTETHS,GFINISH,GCLOSE} _groups;
typedef enum {EKEYWORD=1,ETYPE,ESITE1,ESTEP1,ESITE2,ESTEP2,ESITE3,ESTEP3,
	ESITE4,ESTEP4} _elements;


vector<string>  data1D_type;
vector<int> data1D_site1,data1D_site2,data1D_site3,data1D_site4;
vector<int> data1D_step1,data1D_step2,data1D_step3,data1D_step4;
int data1D_element_count;
vector<double> data1D;

public:
//========== string/int ==========

typedef map<string,int> _fldo2StringIntMap;
typedef _fldo2StringIntMap::iterator _fldo2StringIntMapIter;

_fldo2StringIntMap bondForceNr,angleForceNr,dihForceNr,invForceNr,tethForceNr;
_fldo2StringIntMapIter stringIntResult;

pair<_fldo2StringIntMapIter,bool> stringIntInsertResult;

//========== string/double ==========

typedef map<string,double> _fldo2StringDoubleMap;
typedef _fldo2StringDoubleMap::iterator _fldo2StringDoubleMapIter;

_fldo2StringDoubleMap atomMass,atomCharge,constLength;
_fldo2StringDoubleMapIter stringDoubleResult;

pair<_fldo2StringDoubleMapIter,bool> stringDoubleInsertResult;

//========== string/string ==========

typedef map<string,string> fldo2StringStringMap;
typedef fldo2StringStringMap::iterator fldo2StringStringMapIter;

fldo2StringStringMap atomTypes,bondTypes,constraintTypes,angleTypes;
fldo2StringStringMap dihedralTypes,inversionTypes,tethTypes;

fldo2StringStringMap bondPotKey,anglePotKey,dihPotKey,invPotKey,tethPotKey;
fldo2StringStringMapIter stringStringResult;

pair<fldo2StringStringMapIter,bool> stringStringInsertResult;

//========== string/vector<double> ==========

typedef map<string,vector<double > > _fldo2StringVDMap;
typedef _fldo2StringVDMap::iterator _fldo2StringVDMapIter;

_fldo2StringVDMap bondForces,angleForces,dihForces,invForces,tethForces;
_fldo2StringVDMapIter stringVDResult;

pair<_fldo2StringVDMapIter,bool> stringVDInsertResult;


int ATOMTYPES,BONDTYPES,CONSTRAINTS,ANGLETYPES,DIHEDRALTYPES,INVERSIONS;
int TETHTYPES,VDWS;

vector <string> vdwPotKey;
vector <string> vdwAtom1,vdwAtom2;
vector <int> vdwForceNr;
vector< vector <double> > vdwForce;

/*
int SHELLS,VDWS;
int *shellid,*tethfid,*vdwid;
char **tethftype,**vdwtype;
double *shellspring;
int *tethforcenr,*vdwforcenr;
double **tethforce;
int *vdwsite1,*vdwsite2;
double **vdwforce;
*/

string SYSHEADER;
int MOLECULES;
vector <string> MOLHEADER;
vector <int> NUMMOLS; //counts NUMMOLS: 1D[molecules]

vector<int> ATOMGROUPS; //counts atom groups in a molecule: 1D[molecules]
vector< vector< int > >ATOMS; //counts group repeats: 2D[molecule][groups]
vector< vector< int > > atomelements; //records elements in the group:
	//  2D[molecules][groups]
vector< vector< vector< string> > > atomtype; //records atom types
	// 3D[molecules][groups][elements]
vector< vector< vector< int> > > atomrepeat; //records atom type repeat
	// 3D[molecules][groups][elements]

vector<int> BONDGROUPS; //counts bond groups in a molecule 1D[molecules]
vector< vector< int> > BONDS; //counts group repeats: 2D[molecules][groups]
vector< vector< int> > bondelements; //records elements in the group:
	//  2D[molecules][groups]
vector< vector< vector <string> > > bondtype; 
	// records bond types 3D[molecules][groups][elements]
vector< vector< vector<int> > > bondsite1,bondsite2;
	// records bond sites: 3D[molecules][groups][elements]
vector< vector< vector<int> > > bondstep1,bondstep2;
	// records bond steps: 3D[molecules][groups][elements]

vector<int> CONSTGROUPS; //counts const groups in a molecule 1D[molecules]
vector< vector< int> > CONSTS; //counts group repeats: 2D[molecules][groups]
vector< vector< int> > constelements; //records elements in the group:
	//  2D[molecules][groups]
vector< vector< vector <string> > > consttype; 
	// records constant types 3D[molecules][groups][elements]
vector< vector< vector<int> > > constsite1,constsite2;
	// records constraint sites: 3D[molecules][groups][elements]
vector< vector< vector<int> > > conststep1,conststep2;
	// records constraint steps: 3D[molecules][groups][elements]

vector<int> ANGLEGROUPS; //counts angle groups in a molecule 1D[molecules]
vector< vector< int> > ANGLES; //counts group repeats: 2D[molecules][groups]
vector< vector< int> > angleelements; //records elements in the group:
	//  2D[molecules][groups]
vector< vector< vector <string> > > angletype; 
	// records angle types 3D[molecules][groups][elements]
vector< vector< vector<int> > > anglesite1,anglesite2,anglesite3;
	// records angle sites: 3D[molecules][groups][elements]
vector< vector< vector<int> > > anglestep1,anglestep2,anglestep3;
	// records angle steps: 3D[molecules][groups][elements]

vector<int> DIHGROUPS; //counts dih groups in a molecule 1D[molecules]
vector< vector< int> > DIHEDRALS; //counts group repeats: 2D[molecules][groups]
vector< vector< int> > dihelements; //records elements in the group:
	//  2D[molecules][groups]
vector< vector< vector <string> > > dihtype; 
	// records dih types 3D[molecules][groups][elements]
vector< vector< vector<int> > > dihsite1,dihsite2,dihsite3,dihsite4;
	// records dih sites: 3D[molecules][groups][elements]
vector< vector< vector<int> > > dihstep1,dihstep2,dihstep3,dihstep4;
	// records dih steps: 3D[molecules][groups][elements]

vector<int> INVGROUPS; //counts inv groups in a molecule 1D[molecules]
vector< vector< int> > INVS; //counts group repeats: 2D[molecules][groups]
vector< vector< int> > invelements; //records elements in the group:
	//  2D[molecules][groups]
vector< vector< vector <string> > > invtype; 
	// records inv types 3D[molecules][groups][elements]
vector< vector< vector<int> > > invsite1,invsite2,invsite3,invsite4;
	// records inv sites: 3D[molecules][groups][elements]
vector< vector< vector<int> > > invstep1,invstep2,invstep3,invstep4;
	// records inv steps: 3D[molecules][groups][elements]

vector<int> RIGIDGROUPS; //counts rigid groups in a molecule 1D[molecules]
vector< vector< int> > RIGIDS; //counts group repeats: 2D[molecules][groups]
vector< vector< int> > rigidelements; //records elements in the group:
	//  2D[molecules][groups]
vector< vector< vector <int> > > rigidnr;
	// records rigid sites in the element 3D[molecules][groups][elements]
vector< vector< vector< vector< int> > > > rigidsite; //records rigid sites:
	// 4D[molecules][groups][elements][sites]
vector< vector< vector< vector< int> > > > rigidstep; //records rigid steps:
	// 4D[molecules][groups][elements][sites]

vector<int> TETHGROUPS; //counts inv groups in a molecule 1D[molecules]
vector< vector< int> > TETHS; //counts group repeats: 2D[molecules][groups]
vector< vector< int> > tethelements; //records elements in the group:
	//  2D[molecules][groups]
vector< vector< vector <string> > > tethtype; 
	// records inv types 3D[molecules][groups][elements]
vector< vector< vector<int> > > tethsite;
	// records inv sites: 3D[molecules][groups][elements]
vector< vector< vector<int> > > tethstep;
	// records inv steps: 3D[molecules][groups][elements]

/*
int ****rigidsite,****rigidstep;
int *TETHGROUPS;
int **TETHS;
int **tethcount;
int ***tethtype,***tethsite,***tethstep;
*/
FIELDOUT(string _inputfn);
~FIELDOUT();
int FO2_read_elements(string _keyword,FILE *_inputfile,int _sitenr);
	//reads elements within a group, _sitenr is a number of sites
	//returns nember of elements in the group
int FO2_read_element_sites(string _keyword,FILE *_inputfile);
	// reads one single element, returns number sites in the element
	// exits, if _keyword not found
	// sites are stored into site1, steps into step1
vector<string> FO2_return_1D_types();
vector<int> FO2_return_1D_sites(int _site);
vector<int> FO2_return_1D_steps(int _site);
double FO2_output_map_second_string2double(
	_fldo2StringDoubleMap _inputMap,string _searchString,	
	string _errorMessage,string _programName);
bool FO2_check_types(fldo2StringStringMap _inputMap,
	vector< vector< vector< string> > > _checkingType,int _molecule,
	int _group,string _programName,string _inputType);
int FO2_output_map_second_string2int(
	_fldo2StringIntMap _inputMap,string _searchString,
	string _errorMessage,string _programName);
string FO2_output_map_second_string2string(
	fldo2StringStringMap _inputMap,string _searchString,
	string _errorMessage,string _programName);
int write_fieldfile(string _outfn);


};






