#include "fieldout2.h"

//=====================================
//========== Method FIELDOUT ==========
//=====================================

FIELDOUT::FIELDOUT(string _inputfn)
{

FILE *infp;
int i;

int moleculeCount=0;
int forceCount=0;
int elementCount=0;
bool forcesExitStatus=false;
bool moleculeExitStatus=false;
bool groupExitStatus=false;
bool elementExitStatus=false;

int groupType;
int forceType;
string inputTypeString;
string tmpString,tmpString1;
int inputInt;
double inputDouble;

infp=open_file(_inputfn,"r");

i=nextfilerecord(infp);
i=test_filelinestring(1,"FORCES\n","IOERROR:",_inputfn,1);

ATOMTYPES=0;
BONDTYPES=0;
CONSTRAINTS=0;
ANGLETYPES=0;
DIHEDRALTYPES=0;
INVERSIONS=0;
VDWS=0;

while(!forcesExitStatus)
{
	i=nextfilerecord(infp);

	tmpString=SYSU_read_linestring(1);
	tmpString=SYSU_cut_stringend(tmpString);

	if(compare_strings_nocase(tmpString,"ATOMTYPE"))
		forceType=FATOMTYPE;
	if(compare_strings_nocase(tmpString,"BONDTYPE"))
		forceType=FBOND;
	if(compare_strings_nocase(tmpString,"CONSTRAINT"))
		forceType=FCONSTRAINT;
	if(compare_strings_nocase(tmpString,"ANGLETYPE"))
		forceType=FANGLE;
	if(compare_strings_nocase(tmpString,"DIHEDRALTYPE"))
		forceType=FDIH;
	if(compare_strings_nocase(tmpString,"INVERSION"))
		forceType=FINV;
	if(compare_strings_nocase(tmpString,"VDW"))
		forceType=FVDW;
	if(compare_strings_nocase(tmpString,"FIELD"))
		forceType=FFIELD;
	switch(forceType)
	{
		case FATOMTYPE:
		{

			tmpString=SYSU_read_linestring(2);
			inputDouble=SYSU_read_linedouble(3);

			stringStringResult=atomTypes.find(tmpString);
			if(stringStringResult!=atomTypes.end())
			{
				SYSU_error_exit(_FIELDOUT_VERSION,
					"ATOMTYPE "+tmpString+
					" already exists",
					_SYSUTILS_IOERR);
			}
			stringStringInsertResult=atomTypes.insert(
				make_pair(tmpString,tmpString));

			stringDoubleResult=atomMass.find(tmpString);
			if(stringDoubleResult!=atomMass.end())
			{
				SYSU_error_exit(_FIELDOUT_VERSION,
					"ATOMTYPE "+tmpString+" already exists",
					_SYSUTILS_IOERR);
			}
			stringDoubleInsertResult=atomMass.insert(make_pair(
				tmpString,inputDouble));

			inputDouble=SYSU_read_linedouble(4);
			stringDoubleInsertResult=atomCharge.insert(make_pair(
				tmpString,inputDouble));
			ATOMTYPES=ATOMTYPES+1;

			break;
		}
		case FBOND:
		{
			inputTypeString=SYSU_read_linestring(2);
			tmpString=SYSU_read_linestring(3);

			stringStringResult=bondTypes.find(inputTypeString);
			if(stringStringResult!=bondTypes.end())
			{
				SYSU_error_exit(_FIELDOUT_VERSION,
					"BONDTYPE "+inputTypeString+
					" already exists",
					_SYSUTILS_IOERR);
			}
			stringStringInsertResult=bondTypes.insert(
				make_pair(inputTypeString,inputTypeString));

			stringStringResult=bondPotKey.find(inputTypeString);
			if(stringStringResult!=bondPotKey.end())
			{
				SYSU_error_exit(_FIELDOUT_VERSION,
					"BONDTYPE "+inputTypeString+
					" already exists",
					_SYSUTILS_IOERR);
			}
			stringStringInsertResult=bondPotKey.insert(make_pair(
				inputTypeString,tmpString));


			inputInt=SYSU_read_lineint(4);
			stringIntResult=bondForceNr.find(inputTypeString);
			if(stringIntResult!=bondForceNr.end())
			{
				SYSU_error_exit(_FIELDOUT_VERSION,
					"BONDTYPE "+inputTypeString+
					" already exists",
					_SYSUTILS_IOERR);
			}
			stringIntInsertResult=bondForceNr.insert(make_pair(
				inputTypeString,inputInt));

			stringVDResult=bondForces.find(inputTypeString);
			if(stringVDResult!=bondForces.end())
			{
				SYSU_error_exit(_FIELDOUT_VERSION,
					"label "+inputTypeString+
					" already exists",
					_SYSUTILS_IOERR);
			}
			else
			{
				data1D.clear();
				stringIntResult=bondForceNr.find(
					inputTypeString);
				for(forceCount=0;forceCount<
					stringIntResult->second;forceCount++)
				{
					data1D.push_back(
						SYSU_read_linedouble(5+
						forceCount));
				}
				stringVDInsertResult=bondForces.insert(
					make_pair(inputTypeString,data1D));
			}
			BONDTYPES=BONDTYPES+1;

			break;
		}

		case FCONSTRAINT:
		{
			tmpString=SYSU_read_linestring(2);

			stringStringResult=constraintTypes.find(tmpString);
			if(stringStringResult!=constraintTypes.end())
			{
				SYSU_error_exit(_FIELDOUT_VERSION,
					"CONSTRAINT "+tmpString+
					" already exists",
					_SYSUTILS_IOERR);
			}
			stringStringInsertResult=constraintTypes.insert(
				make_pair(tmpString,tmpString));

			inputDouble=SYSU_read_linedouble(3);
			stringDoubleResult=constLength.find(tmpString);
			if(stringDoubleResult!=constLength.end())
			{
				SYSU_error_exit(_FIELDOUT_VERSION,
					"CONSTRAINT "+tmpString+
					" already exists",
					_SYSUTILS_IOERR);
			}
			else
			stringDoubleInsertResult=constLength.insert(make_pair(
				tmpString,inputDouble));
			CONSTRAINTS=CONSTRAINTS+1;
			break;
		}

		case FANGLE:
		{
			inputTypeString=SYSU_read_linestring(2);
			tmpString=SYSU_read_linestring(3);

			stringStringResult=angleTypes.find(inputTypeString);
			if(stringStringResult!=angleTypes.end())
			{
				SYSU_error_exit(_FIELDOUT_VERSION,
					"ANGLELTYPE "+inputTypeString+
					" already exists",
					_SYSUTILS_IOERR);
			}
			stringStringInsertResult=angleTypes.insert(
				make_pair(inputTypeString,inputTypeString));

			stringStringResult=anglePotKey.find(inputTypeString);
			if(stringStringResult!=anglePotKey.end())
			{
				SYSU_error_exit(_FIELDOUT_VERSION,
					"ANGLETYPE "+inputTypeString+
					" already exists",
					_SYSUTILS_IOERR);
			}
			stringStringInsertResult=anglePotKey.insert(make_pair(
				inputTypeString,tmpString));

			inputInt=SYSU_read_lineint(4);
			stringIntResult=angleForceNr.find(inputTypeString);
			if(stringIntResult!=angleForceNr.end())
			{
				SYSU_error_exit(_FIELDOUT_VERSION,
					"ANGLETYPE "+inputTypeString+
					" already exists",
					_SYSUTILS_IOERR);
			}
			stringIntInsertResult=angleForceNr.insert(make_pair(
				inputTypeString,inputInt));

			stringVDResult=angleForces.find(inputTypeString);
			if(stringVDResult!=angleForces.end())
			{
				SYSU_error_exit(_FIELDOUT_VERSION,
					"label "+inputTypeString+
					" already exists",
					_SYSUTILS_IOERR);
			}
			else
			{
				data1D.clear();
				stringIntResult=angleForceNr.find(
					inputTypeString);
				for(forceCount=0;forceCount<
					stringIntResult->second;forceCount++)
				{
					data1D.push_back(
						SYSU_read_linedouble(5+
						forceCount));
				}
				stringVDInsertResult=angleForces.insert(
					make_pair(inputTypeString,data1D));
			}
			ANGLETYPES=ANGLETYPES+1;
			break;
		}

		case FDIH:
		{
			inputTypeString=SYSU_read_linestring(2);
			tmpString=SYSU_read_linestring(3);
			stringStringResult=dihedralTypes.find(inputTypeString);
			if(stringStringResult!=dihedralTypes.end())
			{
				SYSU_error_exit(_FIELDOUT_VERSION,
					"DIHEDRALTYPE "+inputTypeString+
					" already exists",
					_SYSUTILS_IOERR);
			}
			stringStringInsertResult=dihedralTypes.insert(
				make_pair(inputTypeString,inputTypeString));

			stringStringResult=dihPotKey.find(inputTypeString);
			if(stringStringResult!=dihPotKey.end())
			{
				SYSU_error_exit(_FIELDOUT_VERSION,
					"DIHEDRALTYPE "+inputTypeString+
					" already exists",
					_SYSUTILS_IOERR);
			}
			stringStringInsertResult=dihPotKey.insert(make_pair(
				inputTypeString,tmpString));

			inputInt=SYSU_read_lineint(4);
			stringIntResult=dihForceNr.find(inputTypeString);
			if(stringIntResult!=dihForceNr.end())
			{
				SYSU_error_exit(_FIELDOUT_VERSION,
					"DIHEDRALTYPE "+inputTypeString+
					" already exists",
					_SYSUTILS_IOERR);
			}
			stringIntInsertResult=dihForceNr.insert(make_pair(
				inputTypeString,inputInt));

			stringVDResult=dihForces.find(inputTypeString);
			if(stringVDResult!=dihForces.end())
			{
				SYSU_error_exit(_FIELDOUT_VERSION,
					"DIHEDRALTYPE "+inputTypeString+
					" already exists",
					_SYSUTILS_IOERR);
			}
			else
			{
				data1D.clear();
				stringIntResult=dihForceNr.find(
					inputTypeString);
				for(forceCount=0;forceCount<
					stringIntResult->second;forceCount++)
				{
					data1D.push_back(
						SYSU_read_linedouble(5+
						forceCount));
				}
				stringVDInsertResult=dihForces.insert(
					make_pair(inputTypeString,data1D));
			}
			DIHEDRALTYPES=DIHEDRALTYPES+1;
			break;
		}
		case FINV:
		{
			inputTypeString=SYSU_read_linestring(2);
			tmpString=SYSU_read_linestring(3);
	
			stringStringResult=inversionTypes.find(inputTypeString);
			if(stringStringResult!=inversionTypes.end())
			{
				SYSU_error_exit(_FIELDOUT_VERSION,
					"INVERSION "+inputTypeString+
					" already exists",
					_SYSUTILS_IOERR);
			}
			stringStringInsertResult=inversionTypes.insert(
				make_pair(inputTypeString,inputTypeString));

			stringStringResult=invPotKey.find(inputTypeString);
			if(stringStringResult!=invPotKey.end())
			{
				SYSU_error_exit(_FIELDOUT_VERSION,
					"INVERSION "+inputTypeString+
					" already exists",
					_SYSUTILS_IOERR);
			}
			stringStringInsertResult=invPotKey.insert(make_pair(
				inputTypeString,tmpString));

			inputInt=SYSU_read_lineint(4);
			stringIntResult=invForceNr.find(inputTypeString);
			if(stringIntResult!=invForceNr.end())
			{
				SYSU_error_exit(_FIELDOUT_VERSION,
					"INVERSION "+inputTypeString+
					" already exists",
					_SYSUTILS_IOERR);
			}
			stringIntInsertResult=invForceNr.insert(make_pair(
				inputTypeString,inputInt));

			stringVDResult=invForces.find(inputTypeString);
			if(stringVDResult!=invForces.end())
			{
				SYSU_error_exit(_FIELDOUT_VERSION,
					"INVERSION "+inputTypeString+
					" already exists",
					_SYSUTILS_IOERR);
			}
			else
			{
				data1D.clear();
				stringIntResult=invForceNr.find(
					inputTypeString);
				for(forceCount=0;forceCount<
					stringIntResult->second;forceCount++)
				{
					data1D.push_back(
						SYSU_read_linedouble(5+
						forceCount));
				}
				stringVDInsertResult=invForces.insert(
					make_pair(inputTypeString,data1D));
			}
			INVERSIONS=INVERSIONS+1;
			break;
		}

		case FVDW:
		{
			inputTypeString=SYSU_read_linestring(2);
			tmpString=SYSU_read_linestring(3);
			tmpString1=SYSU_read_linestring(4);

			elementExitStatus=false;
			for(elementCount=0;elementCount<(int) vdwAtom1.size()-1;
				elementCount++)
			{
				if(compare_strings_nocase(
					tmpString,vdwAtom1.at(elementCount)) 
					and compare_strings_nocase(tmpString1,
					vdwAtom2.at(elementCount)))
					elementExitStatus=true;
				if(compare_strings_nocase(
					tmpString1,vdwAtom1.at(elementCount)) 
					and compare_strings_nocase(tmpString,
					vdwAtom2.at(elementCount)))
					elementExitStatus=true;
			}
			
			if(!elementExitStatus)
			{
				vdwPotKey.push_back(inputTypeString);
				vdwAtom1.push_back(tmpString);
				vdwAtom2.push_back(tmpString1);
				vdwForceNr.push_back(SYSU_read_lineint(5));
				
				data1D.clear();
				for(forceCount=0;forceCount<vdwForceNr.
					at(vdwForceNr.size()-1);forceCount++)
					data1D.push_back(
						SYSU_read_linedouble(6+
						forceCount));
				vdwForce.push_back(data1D);
				VDWS=VDWS+1;
			}
			else
				SYSU_error_exit(_FIELDOUT_VERSION,
					"VDW pair "+tmpString+"-"+tmpString1+
					" already specified...",
					_SYSUTILS_IOERR);

			break;
		}

		case FFIELD:
		{
			forcesExitStatus=true;
			break;
		}
		default: break;
	};
}

//atom types 
//shell types
/*
i=nextfilerecord(infp);
i=test_filelinestring(1,"SHELLS","IOERROR:",_inputfn,1);
SHELLS=read_lineint(2);

if(SHELLS>0)
{
	shellid=allocate_int(SHELLS,_FIELDOUT_VERSION,"shellid\0",2);
	shellspring=allocate_double(SHELLS,_FIELDOUT_VERSION,"shellspring\0",2);
	
	for(j=0;j<SHELLS;j++)
	{
		i=nextfilerecord(infp);
		i=test_filelinestring(1,"SHELL","IOERROR:",_inputfn,1);
		shellid[j]=read_lineint(2);
		if(shellid[j]!=j)
		{
			printf("Found shellid [%d]...must be [%d]...\n",shellid[j],j);
			exit(3);
		}
		shellspring[j]=read_linedouble(3);
	}
}
*/
//constraints types
//bonds types
//angles types
//dihedrals types
//inversion types
//tethered types
/*
i=nextfilerecord(infp);
i=test_filelinestring(1,"TETHFS","IOERROR:",_inputfn,1);
TETHFS=read_lineint(2);

if(TETHFS>0)
{
	tethfid=allocate_int(TETHFS,_FIELDOUT_VERSION,"tethfid\0",
		_SYSUTILS_MEMERR);
	tethftype=allocate_string2(TETHFS,_SYSUTILS_TSTRING_LEN,
		_FIELDOUT_VERSION,"tethftype\0",_SYSUTILS_MEMERR);
	tethforcenr=allocate_int(TETHFS,_FIELDOUT_VERSION,"tethforcenr\0",
		_SYSUTILS_MEMERR);
	tethforce=allocate_2double(TETHFS,_FIELDOUT_VERSION,"tethforce\0",
		_SYSUTILS_MEMERR);
	
	for(j=0;j<TETHFS;j++)
	{
		i=nextfilerecord(infp);
		i=test_filelinestring(1,"TETHF","IOERROR:",_inputfn,
			_SYSUTILS_IOERR);
		tethfid[j]=read_lineint(2);
		if(tethfid[j]!=j)
		{
			printf("Found tethfid [%d]...must be [%d]...\n",
				tethfid[j],j);
			exit(_SYSUTILS_IOERR);
		}
		i=read_linestring(tethftype[j],3);
		tethforcenr[j]=read_lineint(4);
		tethforce[j]=allocate_double(tethforcenr[j],_FIELDOUT_VERSION,
			"tethforce[j]\0",_SYSUTILS_MEMERR);
		for(k=0;k<tethforcenr[j];k++)
		{
			tethforce[j][k]=read_linedouble(5+k);
		}
		
	}
}
*/
//============================================
// actual field information

//i=nextfilerecord(infp);
//i=test_filelinestring(1,"FIELD\n","IOERROR:",_inputfn,1);

i=nextfilerecord(infp);
SYSHEADER=SYSU_read_line100char();
SYSHEADER=SYSU_cut_stringend(SYSHEADER);
i=nextfilerecord(infp);
i=test_filelinestring(1,"MOLECULES","IOERROR:",_inputfn,1);
MOLECULES=read_lineint(2);

//atoms
//bonds
//consts
//angles
//dihedrals
//inversions
//rigids
/*
RIGIDGROUPS=allocate_int(MOLECULES,_FIELDOUT_VERSION,"RIGIDGROUPS\0",2);
RIGIDS=allocate_2int(MOLECULES,_FIELDOUT_VERSION,"RIGIDS\0",2);
rigidscount=allocate_2int(MOLECULES,_FIELDOUT_VERSION,"rigidscount\0",2);

rigidnr=allocate_3int(MOLECULES,_FIELDOUT_VERSION,"rigidnr\0",2);

rigidsite=allocate_4int(MOLECULES,_FIELDOUT_VERSION,"rigidsite\0",2);
rigidstep=allocate_4int(MOLECULES,_FIELDOUT_VERSION,"rigidstep\0",2);


//RIGIDS=allocate_int(MOLECULES,_FIELDOUT_VERSION,"RIGIDS\0",2);
//rigidnr=allocate_2int(MOLECULES,_FIELDOUT_VERSION,"rigidnr\0",2);
//rigidsite=allocate_3int(MOLECULES,_FIELDOUT_VERSION,"rigidsite\0",2);
*/

//tethered
/*
TETHGROUPS=allocate_int(MOLECULES,_FIELDOUT_VERSION,"TETHGROUPS\0",2);
TETHS=allocate_2int(MOLECULES,_FIELDOUT_VERSION,"TETHS\0",2);

tethcount=allocate_2int(MOLECULES,_FIELDOUT_VERSION,"tethcount\0",2);

tethtype=allocate_3int(MOLECULES,_FIELDOUT_VERSION,"tethtype\0",2);
tethsite=allocate_3int(MOLECULES,_FIELDOUT_VERSION,"tethsite\0",2);
tethstep=allocate_3int(MOLECULES,_FIELDOUT_VERSION,"tethstep\0",2);
*/

moleculeExitStatus=false;
moleculeCount=0;

//vector initializations

//atoms
ATOMS.resize(MOLECULES);
atomelements.resize(MOLECULES);
atomtype.resize(MOLECULES);
atomrepeat.resize(MOLECULES);

//bonds
BONDS.resize(MOLECULES);
bondelements.resize(MOLECULES);
bondtype.resize(MOLECULES);
bondsite1.resize(MOLECULES);
bondsite2.resize(MOLECULES);
bondstep1.resize(MOLECULES);
bondstep2.resize(MOLECULES);

//constraints
CONSTS.resize(MOLECULES);
constelements.resize(MOLECULES);
consttype.resize(MOLECULES);
constsite1.resize(MOLECULES);
constsite2.resize(MOLECULES);
conststep1.resize(MOLECULES);
conststep2.resize(MOLECULES);

//angles
ANGLES.resize(MOLECULES);
angleelements.resize(MOLECULES);
angletype.resize(MOLECULES);
anglesite1.resize(MOLECULES);
anglesite2.resize(MOLECULES);
anglesite3.resize(MOLECULES);
anglestep1.resize(MOLECULES);
anglestep2.resize(MOLECULES);
anglestep3.resize(MOLECULES);

//dihedrals
DIHEDRALS.resize(MOLECULES);
dihelements.resize(MOLECULES);
dihtype.resize(MOLECULES);
dihsite1.resize(MOLECULES);
dihsite2.resize(MOLECULES);
dihsite3.resize(MOLECULES);
dihsite4.resize(MOLECULES);
dihstep1.resize(MOLECULES);
dihstep2.resize(MOLECULES);
dihstep3.resize(MOLECULES);
dihstep4.resize(MOLECULES);

//inversions
INVS.resize(MOLECULES);
invelements.resize(MOLECULES);
invtype.resize(MOLECULES);
invsite1.resize(MOLECULES);
invsite2.resize(MOLECULES);
invsite3.resize(MOLECULES);
invsite4.resize(MOLECULES);
invstep1.resize(MOLECULES);
invstep2.resize(MOLECULES);
invstep3.resize(MOLECULES);
invstep4.resize(MOLECULES);

//rigids
RIGIDS.resize(MOLECULES);
rigidelements.resize(MOLECULES);
rigidnr.resize(MOLECULES);
rigidsite.resize(MOLECULES);
rigidstep.resize(MOLECULES);

i=nextfilerecord(infp);
while(!moleculeExitStatus)
{
	tmpString=SYSU_read_line100char();
	tmpString=SYSU_cut_stringend(tmpString);
	MOLHEADER.push_back(tmpString);

	i=nextfilerecord(infp);
	i=test_filelinestring(1,"NUMMOLS","IOERROR:",_inputfn,1);
	NUMMOLS.push_back(read_lineint(2));


	groupExitStatus=false;


//vector initializations

//atoms
	ATOMGROUPS.push_back(0);

//bonds
	BONDGROUPS.push_back(0);

//constaints
	CONSTGROUPS.push_back(0);

//angles
	ANGLEGROUPS.push_back(0);

//dihedrals
	DIHGROUPS.push_back(0);

//inversions
	INVGROUPS.push_back(0);

//rigids
	RIGIDGROUPS.push_back(0);
	rigidelements.at(moleculeCount).push_back(0);

	i=nextfilerecord(infp);

	while(!groupExitStatus)
	{
		tmpString=SYSU_read_linestring(1);
		tmpString=SYSU_cut_stringend(tmpString);
//atoms
		if(compare_strings_nocase(tmpString,"ATOMS"))
		{
			groupType=GATOMS;
			if(ATOMTYPES==0)
			{
				SYSU_error_exit(_FIELDOUT_VERSION,
					"ATOMTYPE definitions missing",
					_SYSUTILS_IOERR);
			}
		}
//bonds
		if(compare_strings_nocase(tmpString,"BONDS"))
		{
			groupType=GBONDS;
			if(BONDTYPES==0)
			{
				SYSU_error_exit(_FIELDOUT_VERSION,
					"BONDTYPE definitions missing",
					_SYSUTILS_IOERR);
			}
		}
//constraints
		if(compare_strings_nocase(tmpString,"CONSTS"))
		{
			groupType=GCONSTS;
			if(CONSTRAINTS==0)
			{
				SYSU_error_exit(_FIELDOUT_VERSION,
					"CONSTRAINT definitions missing",
					_SYSUTILS_IOERR);
			}
		}

//angles
		if(compare_strings_nocase(tmpString,"ANGLES"))
		{
			groupType=GANGLES;
			if(ANGLETYPES==0)
			{
				SYSU_error_exit(_FIELDOUT_VERSION,
					"ANGLETYPE definitions missing",
					_SYSUTILS_IOERR);
			}
		}

//dihedrals
		if(compare_strings_nocase(tmpString,"DIHEDRALS"))
		{
			groupType=GDIHS;
			if(DIHEDRALTYPES==0)
			{
				SYSU_error_exit(_FIELDOUT_VERSION,
					"DIHEDRALTYPE definitions missing",
					_SYSUTILS_IOERR);
			}
		}

//inversions
		if(compare_strings_nocase(tmpString,"INVERSIONS"))
		{
			groupType=GINVS;
			if(INVERSIONS==0)
			{
				SYSU_error_exit(_FIELDOUT_VERSION,
					"INVERSION definitions missing",
					_SYSUTILS_IOERR);
			}
		}

//rigids
		if(compare_strings_nocase(tmpString,"RIGIDS"))
		{
			groupType=GRIGIDS;
		}

		if(compare_strings_nocase(tmpString,"FINISH"))
			groupType=GFINISH;

		if(compare_strings_nocase(tmpString,"CLOSE"))
			groupType=GCLOSE;
		
		switch(groupType)
		{
//atoms
			case GATOMS:
			{
				ATOMS.at(moleculeCount).push_back(
					SYSU_read_lineint(2));
				i=FO2_read_elements("ATOM",infp,0);
				if(i>0)
				{
					ATOMGROUPS.at(moleculeCount)=
					ATOMGROUPS.at(moleculeCount)+1;
					atomelements.at(moleculeCount).
						push_back(i);
					atomtype.at(moleculeCount).
						resize(ATOMGROUPS.
						at(moleculeCount),
						FO2_return_1D_types());
					atomrepeat.at(moleculeCount).
						resize(ATOMGROUPS.
						at(moleculeCount),
						FO2_return_1D_sites(1));
					FO2_check_types(atomTypes,atomtype,
						moleculeCount,ATOMGROUPS.
						at(moleculeCount)-1,
						_FIELDOUT_VERSION,
						"ATOMYPE");
				}
				break;
			}
//bonds
			case GBONDS:
			{
				BONDS.at(moleculeCount).push_back(
					SYSU_read_lineint(2));
				i=FO2_read_elements("BOND",infp,2);
				if(i>0)
				{
					BONDGROUPS.at(moleculeCount)=
					BONDGROUPS.at(moleculeCount)+1;
					bondelements.at(moleculeCount).
						push_back(i);
					bondtype.at(moleculeCount).
						resize(BONDGROUPS.
						at(moleculeCount),
						FO2_return_1D_types());
					bondsite1.at(moleculeCount).
						resize(BONDGROUPS.
						at(moleculeCount),
						FO2_return_1D_sites(1));
					bondsite2.at(moleculeCount).
						resize(BONDGROUPS.
						at(moleculeCount),
						FO2_return_1D_sites(2));
					bondstep1.at(moleculeCount).
						resize(BONDGROUPS.
						at(moleculeCount),
						FO2_return_1D_steps(1));
					bondstep2.at(moleculeCount).
						resize(BONDGROUPS.
						at(moleculeCount),
						FO2_return_1D_steps(2));
					FO2_check_types(bondTypes,bondtype,
						moleculeCount,BONDGROUPS.
						at(moleculeCount)-1,
						_FIELDOUT_VERSION,
						"BONDTYPE");
				}
				break;
			}
//constraints
			case GCONSTS:
			{
				CONSTS.at(moleculeCount).push_back(
					SYSU_read_lineint(2));
				i=FO2_read_elements("CONST",infp,2);
				if(i>0)
				{
					CONSTGROUPS.at(moleculeCount)=
					CONSTGROUPS.at(moleculeCount)+1;
					constelements.at(moleculeCount).
						push_back(i);
					consttype.at(moleculeCount).
						resize(CONSTGROUPS.
						at(moleculeCount),
						FO2_return_1D_types());
					constsite1.at(moleculeCount).
						resize(CONSTGROUPS.
						at(moleculeCount),
						FO2_return_1D_sites(1));
					constsite2.at(moleculeCount).
						resize(CONSTGROUPS.
						at(moleculeCount),
						FO2_return_1D_sites(2));
					conststep1.at(moleculeCount).
						resize(CONSTGROUPS.
						at(moleculeCount),
						FO2_return_1D_steps(1));
					conststep2.at(moleculeCount).
						resize(CONSTGROUPS.
						at(moleculeCount),
						FO2_return_1D_steps(2));
					FO2_check_types(constraintTypes,
						consttype,
						moleculeCount,CONSTGROUPS.
						at(moleculeCount)-1,
						_FIELDOUT_VERSION,
						"CONSTRAINT");
				}
				break;
			}
//angles
			case GANGLES:
			{
				ANGLES.at(moleculeCount).push_back(
					SYSU_read_lineint(2));
				i=FO2_read_elements("ANG",infp,3);
				if(i>0)
				{
					ANGLEGROUPS.at(moleculeCount)=
					ANGLEGROUPS.at(moleculeCount)+1;
					angleelements.at(moleculeCount).
						push_back(i);
					angletype.at(moleculeCount).
						resize(ANGLEGROUPS.
						at(moleculeCount),
						FO2_return_1D_types());
					anglesite1.at(moleculeCount).
						resize(ANGLEGROUPS.
						at(moleculeCount),
						FO2_return_1D_sites(1));
					anglesite2.at(moleculeCount).
						resize(ANGLEGROUPS.
						at(moleculeCount),
						FO2_return_1D_sites(2));
					anglesite3.at(moleculeCount).
						resize(ANGLEGROUPS.
						at(moleculeCount),
						FO2_return_1D_sites(3));
					anglestep1.at(moleculeCount).
						resize(ANGLEGROUPS.
						at(moleculeCount),
						FO2_return_1D_steps(1));
					anglestep2.at(moleculeCount).
						resize(ANGLEGROUPS.
						at(moleculeCount),
						FO2_return_1D_steps(2));
					anglestep3.at(moleculeCount).
						resize(ANGLEGROUPS.
						at(moleculeCount),
						FO2_return_1D_steps(3));
					FO2_check_types(angleTypes,angletype,
						moleculeCount,ANGLEGROUPS.
						at(moleculeCount)-1,
						_FIELDOUT_VERSION,
						"ANGLETYPE");
				}
				break;
			}

//dihedrals
			case GDIHS:
			{
				DIHEDRALS.at(moleculeCount).push_back(
					SYSU_read_lineint(2));
				i=FO2_read_elements("DIH",infp,4);
				if(i>0)
				{
					DIHGROUPS.at(moleculeCount)=
					DIHGROUPS.at(moleculeCount)+1;
					dihelements.at(moleculeCount).
						push_back(i);
					dihtype.at(moleculeCount).
						resize(DIHGROUPS.
						at(moleculeCount),
						FO2_return_1D_types());
					dihsite1.at(moleculeCount).
						resize(DIHGROUPS.
						at(moleculeCount),
						FO2_return_1D_sites(1));
					dihsite2.at(moleculeCount).
						resize(DIHGROUPS.
						at(moleculeCount),
						FO2_return_1D_sites(2));
					dihsite3.at(moleculeCount).
						resize(DIHGROUPS.
						at(moleculeCount),
						FO2_return_1D_sites(3));
					dihsite4.at(moleculeCount).
						resize(DIHGROUPS.
						at(moleculeCount),
						FO2_return_1D_sites(4));
					dihstep1.at(moleculeCount).
						resize(DIHGROUPS.
						at(moleculeCount),
						FO2_return_1D_steps(1));
					dihstep2.at(moleculeCount).
						resize(DIHGROUPS.
						at(moleculeCount),
						FO2_return_1D_steps(2));
					dihstep3.at(moleculeCount).
						resize(DIHGROUPS.
						at(moleculeCount),
						FO2_return_1D_steps(3));
					dihstep4.at(moleculeCount).
						resize(DIHGROUPS.
						at(moleculeCount),
						FO2_return_1D_steps(4));
					FO2_check_types(dihedralTypes,dihtype,
						moleculeCount,DIHGROUPS.
						at(moleculeCount)-1,
						_FIELDOUT_VERSION,
						"DIHEDRALTYPE");
				}
				break;
			}

//inversions
			case GINVS:
			{
				INVS.at(moleculeCount).push_back(
					SYSU_read_lineint(2));
				i=FO2_read_elements("INV",infp,4);
				if(i>0)
				{
					INVGROUPS.at(moleculeCount)=
					INVGROUPS.at(moleculeCount)+1;
					invelements.at(moleculeCount).
						push_back(i);
					invtype.at(moleculeCount).
						resize(INVGROUPS.
						at(moleculeCount),
						FO2_return_1D_types());
					invsite1.at(moleculeCount).
						resize(INVGROUPS.
						at(moleculeCount),
						FO2_return_1D_sites(1));
					invsite2.at(moleculeCount).
						resize(INVGROUPS.
						at(moleculeCount),
						FO2_return_1D_sites(2));
					invsite3.at(moleculeCount).
						resize(INVGROUPS.
						at(moleculeCount),
						FO2_return_1D_sites(3));
					invsite4.at(moleculeCount).
						resize(INVGROUPS.
						at(moleculeCount),
						FO2_return_1D_sites(4));
					invstep1.at(moleculeCount).
						resize(INVGROUPS.
						at(moleculeCount),
						FO2_return_1D_steps(1));
					invstep2.at(moleculeCount).
						resize(INVGROUPS.
						at(moleculeCount),
						FO2_return_1D_steps(2));
					invstep3.at(moleculeCount).
						resize(INVGROUPS.
						at(moleculeCount),
						FO2_return_1D_steps(3));
					invstep4.at(moleculeCount).
						resize(INVGROUPS.
						at(moleculeCount),
						FO2_return_1D_steps(4));
					FO2_check_types(inversionTypes,invtype,
						moleculeCount,INVGROUPS.
						at(moleculeCount)-1,
						_FIELDOUT_VERSION,
						"INVERSION");
				}
				break;
			}

			case GRIGIDS:
			{
				RIGIDS.at(moleculeCount).push_back(
					SYSU_read_lineint(2));

				elementExitStatus=false;
				elementCount=0;			
				
				RIGIDGROUPS.at(moleculeCount)=RIGIDGROUPS.
					at(moleculeCount)+1;
				rigidnr.at(moleculeCount).resize(RIGIDGROUPS.
					at(moleculeCount));
				rigidsite.at(moleculeCount).resize(RIGIDGROUPS.
					at(moleculeCount));
				rigidstep.at(moleculeCount).resize(RIGIDGROUPS.
					at(moleculeCount));
				while(!elementExitStatus)
				{
					i=FO2_read_element_sites("RIGID",infp);
					if(i>0)
					{
						elementCount=elementCount+1;
						rigidelements.at(moleculeCount).
							at(RIGIDGROUPS.at(
							moleculeCount)-1)++;
						rigidnr.at(moleculeCount).
							at(RIGIDGROUPS.
							at(moleculeCount)-1).
							push_back(i);
						rigidsite.at(moleculeCount).
							at(RIGIDGROUPS.
							at(moleculeCount)-1).
							resize(elementCount,
							FO2_return_1D_sites(1));
						rigidstep.at(moleculeCount).
							at(RIGIDGROUPS.
							at(moleculeCount)-1).
							resize(elementCount,
							FO2_return_1D_steps(1));
						
						
					}
					else
						elementExitStatus=true;
				}
/*
				i=FO2_read_elements("BOND",infp,2);
				if(i>0)
				{
					BONDGROUPS.at(moleculeCount)=
					BONDGROUPS.at(moleculeCount)+1;
					bondelements.at(moleculeCount).
						push_back(i);
					bondtype.at(moleculeCount).
						resize(BONDGROUPS.
						at(moleculeCount),
						FO2_return_1D_types());
					bondsite1.at(moleculeCount).
						resize(BONDGROUPS.
						at(moleculeCount),
						FO2_return_1D_sites(1));
					bondsite2.at(moleculeCount).
						resize(BONDGROUPS.
						at(moleculeCount),
						FO2_return_1D_sites(2));
					bondstep1.at(moleculeCount).
						resize(BONDGROUPS.
						at(moleculeCount),
						FO2_return_1D_steps(1));
					bondstep2.at(moleculeCount).
						resize(BONDGROUPS.
						at(moleculeCount),
						FO2_return_1D_steps(2));
					FO2_check_types(bondTypes,bondtype,
						moleculeCount,BONDGROUPS.
						at(moleculeCount)-1,
						_FIELDOUT_VERSION,
						"BONDTYPE");
				}
*/
				break;
			}

			case GFINISH:
			{
				groupExitStatus=true;
				moleculeCount=moleculeCount+1;
				break;
			}
			case GCLOSE:
			{
				moleculeExitStatus=true;
				break;
			}
			default: break;
		};
	}


	i=nextfilerecord(infp);
	tmpString=SYSU_read_linestring(1);
	tmpString=SYSU_cut_stringend(tmpString);
	if(compare_strings_nocase(tmpString,"CLOSE"))
		moleculeExitStatus=true;

}

//========================================================================
//read rigid
/*
	i=nextfilerecord(infp);
	i=test_filelinestring(1,"RIGIDGROUPS","IOERROR:",_inputfn,1);
	RIGIDGROUPS[j]=read_lineint(2);
	RIGIDS[j]=allocate_int(RIGIDGROUPS[j],_FIELDOUT_VERSION,
			"RIGIDS[j]\0",2);
	rigidscount[j]=allocate_int(RIGIDGROUPS[j],_FIELDOUT_VERSION,
			"rigidscount[j]\0",2);
	rigidnr[j]=allocate_2int(RIGIDGROUPS[j],_FIELDOUT_VERSION,
			"rigidsnr[j]\0",2);
	rigidsite[j]=allocate_3int(RIGIDGROUPS[j],_FIELDOUT_VERSION,
			"rigidsite[j]\0",2);
	rigidstep[j]=allocate_3int(RIGIDGROUPS[j],_FIELDOUT_VERSION,
			"rigidstep[j]\0",2);

	for(k=0;k<RIGIDGROUPS[j];k++)
	{
		i=nextfilerecord(infp);
		i=test_filelinestring(1,"RIGIDS","IOERROR:",_inputfn,1);
		RIGIDS[j][k]=read_lineint(2);
		rigidscount[j][k]=read_lineint(3);
		rigidnr[j][k]=allocate_int(RIGIDS[j][k],_FIELDOUT_VERSION,
				"rigidsnr[j][k]\0",2);
		rigidsite[j][k]=allocate_2int(RIGIDS[j][k],_FIELDOUT_VERSION,
				"rigidsite[j][k]\0",2);
		rigidstep[j][k]=allocate_2int(RIGIDS[j][k],_FIELDOUT_VERSION,
				"rigidstep[j][k]\0",2);

		for(l=0;l<RIGIDS[j][k];l++)
		{
			i=nextfilerecord(infp);
			i=test_filelinestring(1,"RIGID","IOERROR:",_inputfn,1);
			rigidnr[j][k][l]=read_lineint(2);
			rigidsite[j][k][l]=allocate_int(rigidnr[j][k][l],
				_FIELDOUT_VERSION,"rigidsite[j][k][l]\0",2);
			rigidstep[j][k][l]=allocate_int(rigidnr[j][k][l],
				_FIELDOUT_VERSION,"rigidstep[j][k][l]\0",2);

			for(m=0;m<rigidnr[j][k][l];m++)
			{
				rigidsite[j][k][l][m]=read_lineint(2*m+3);
				rigidstep[j][k][l][m]=read_lineint(2*m+4);
			}
		}
	}
*/

//	        i=nextfilerecord(infp);
//		i=test_filelinestring(1,"RIGIDS","IOERROR:",_inputfn,1);
//		RIGIDS[j]=read_lineint(2);
//		rigidnr[j]=allocate_int(RIGIDS[j],_FIELDOUT_VERSION,
//				"rigidnr[j]\0",2);
//		rigidsite[j]=allocate_2int(RIGIDS[j],_FIELDOUT_VERSION,
//				"rigidsite[j]\0",2);
//		
//		for(k=0;k<RIGIDS[j];k++)
//		{
//			i=nextfilerecord(infp);
//			i=test_filelinestring(1,"RIGID","IOERROR:",_inputfn,1);
//			rigidnr[j][k]=read_lineint(2);
//			rigidsite[j][k]=allocate_int(rigidnr[j][k],
//					_FIELDOUT_VERSION,
//					"rigidsite[j][k]\0",2);
//			for(l=0;l<rigidnr[j][k];l++)
//				rigidsite[j][k][l]=read_lineint(3+l);
//						
//		}

//read tethered atoms
/*
	i=nextfilerecord(infp);
	i=test_filelinestring(1,"TETHGROUPS","IOERROR:",_inputfn,1);
	TETHGROUPS[j]=read_lineint(2);
	TETHS[j]=allocate_int(TETHGROUPS[j],_FIELDOUT_VERSION,
			"TETHS[j]\0",2);
	tethcount[j]=allocate_int(TETHGROUPS[j],_FIELDOUT_VERSION,
			"tethcount[j]\0",2);
	tethtype[j]=allocate_2int(TETHGROUPS[j],_FIELDOUT_VERSION,
			"tethtype[j]\0",2);
	tethsite[j]=allocate_2int(TETHGROUPS[j],_FIELDOUT_VERSION,
			"tethsite[j]\0",2);
	tethstep[j]=allocate_2int(TETHGROUPS[j],_FIELDOUT_VERSION,
			"tethstep[j]\0",2);

	for(k=0;k<TETHGROUPS[j];k++)
	{
		i=nextfilerecord(infp);
		i=test_filelinestring(1,"TETHS","IOERROR:",_inputfn,1);
		TETHS[j][k]=read_lineint(2);
		tethcount[j][k]=read_lineint(3);
		tethtype[j][k]=allocate_int(TETHS[j][k],_FIELDOUT_VERSION,
				"tethtype[j][k]\0",2);
		tethsite[j][k]=allocate_int(TETHS[j][k],_FIELDOUT_VERSION,
				"tethsite[j][k]\0",2);
		tethstep[j][k]=allocate_int(TETHS[j][k],_FIELDOUT_VERSION,
				"tethstep[j][k]\0",2);

		for(l=0;l<TETHS[j][k];l++)
		{
			i=nextfilerecord(infp);
			i=test_filelinestring(1,"TETH","IOERROR:",_inputfn,1);
			tethtype[j][k][l]=read_lineint(2);
			tethsite[j][k][l]=read_lineint(3);
			tethstep[j][k][l]=read_lineint(4);
		}
	}
	
*/
//	i=nextfilerecord(infp);
//	moleculeExitStatus=true;
//	i=test_filelinestring(1,"FINISH\n","IOERROR:",_inputfn,1);

//}

i=close_file(infp);


};

//=========================================
//========== Destructor FIELDOUT ==========
//=========================================

FIELDOUT::~FIELDOUT()
{


};

//==============================================
//========== method FO2_read_elements ==========
//==============================================

int FIELDOUT::FO2_read_elements(string _keyword,FILE *_inputfile,
	int _sitenr)
{

bool elementExitStatus=false;
int i;

data1D_type.clear();

data1D_site1.clear();
data1D_site2.clear();
data1D_site3.clear();
data1D_site4.clear();

data1D_step1.clear();
data1D_step2.clear();
data1D_step3.clear();
data1D_step4.clear();

data1D_element_count=0;

while(!elementExitStatus)
{
	i=nextfilerecord(_inputfile);

	if(SYSU_test_string(EKEYWORD,_keyword))
	{
		data1D_type.push_back(SYSU_read_linestring(ETYPE));
		switch(_sitenr)
		{
			case 0:
			{
				data1D_site1.push_back(
					SYSU_read_lineint(ESITE1));
				break;
			}
			case 1:
			{
				data1D_site1.push_back(
					SYSU_read_lineint(ESITE1));
				data1D_step1.push_back(
					SYSU_read_lineint(ESTEP1));
				break;
			}
			case 2:
			{
				data1D_site1.push_back(
					SYSU_read_lineint(ESITE1));
				data1D_step1.push_back(
					SYSU_read_lineint(ESTEP1));
				data1D_site2.push_back(
					SYSU_read_lineint(ESITE2));
				data1D_step2.push_back(
					SYSU_read_lineint(ESTEP2));
				break;
			}
			case 3:
			{
				data1D_site1.push_back(
					SYSU_read_lineint(ESITE1));
				data1D_step1.push_back(
					SYSU_read_lineint(ESTEP1));
				data1D_site2.push_back(
					SYSU_read_lineint(ESITE2));
				data1D_step2.push_back(
					SYSU_read_lineint(ESTEP2));
				data1D_site3.push_back(
					SYSU_read_lineint(ESITE3));
				data1D_step3.push_back(
					SYSU_read_lineint(ESTEP3));
				break;
			}
			case 4:
			{
				data1D_site1.push_back(
					SYSU_read_lineint(ESITE1));
				data1D_step1.push_back(
					SYSU_read_lineint(ESTEP1));
				data1D_site2.push_back(
					SYSU_read_lineint(ESITE2));
				data1D_step2.push_back(
					SYSU_read_lineint(ESTEP2));
				data1D_site3.push_back(
					SYSU_read_lineint(ESITE3));
				data1D_step3.push_back(
					SYSU_read_lineint(ESTEP3));
				data1D_site4.push_back(
					SYSU_read_lineint(ESITE4));
				data1D_step4.push_back(
					SYSU_read_lineint(ESTEP4));
				break;
			}
			default: break;
		};
		data1D_element_count=data1D_element_count+1;
	}
	else
		elementExitStatus=true;
}


if(data1D_element_count==0)
{
	SYSU_error_exit(_FIELDOUT_VERSION,
		"can not find any "+_keyword+" record in the present group",
		_SYSUTILS_IOERR);
}

return data1D_element_count;

};

//===================================================
//========== method FO2_read_element_sites ==========
//===================================================

int FIELDOUT::FO2_read_element_sites(string _keyword,FILE *_inputfile)
{

int i;

data1D_site1.clear();

data1D_step1.clear();

data1D_element_count=0;

i=nextfilerecord(_inputfile);

if(SYSU_test_string(EKEYWORD,_keyword))
{
	data1D_element_count=SYSU_read_lineint(ETYPE);

	for(i=0;i<data1D_element_count;i++)
	{
		data1D_site1.push_back(SYSU_read_lineint(ESITE1+i*2));
		data1D_step1.push_back(SYSU_read_lineint(ESTEP1+i*2));
	}

}

return data1D_element_count;

};

//================================================
//========== method FO2_return_1D_types ==========
//================================================

vector<string> FIELDOUT::FO2_return_1D_types()
{

return data1D_type;

}

//==============================================
//========== method FO2_read_1D_sites ==========
//==============================================

vector<int> FIELDOUT::FO2_return_1D_sites(int _site)
{

vector <int> outResult;
switch(_site)
{
	case 1:
	{
		outResult=data1D_site1;
		break;
	}
	case 2:
	{
		outResult=data1D_site2;
		break;
	}
	case 3:
	{
		outResult=data1D_site3;
		break;
	}
	case 4:
	{
		outResult=data1D_site4;
		break;
	}
};
return outResult;

};

//==============================================
//========== method FO2_read_1D_steps ==========
//==============================================

vector<int> FIELDOUT::FO2_return_1D_steps(int _site)
{

vector <int> outResult;
switch(_site)
{
	case 1:
	{
		outResult=data1D_step1;
		break;
	}
	case 2:
	{
		outResult=data1D_step2;
		break;
	}
	case 3:
	{
		outResult=data1D_step3;
		break;
	}
	case 4:
	{
		outResult=data1D_step4;
		break;
	}
};
return outResult;

};


//=============================================
//========== Method FO2_check_types ===========
//=============================================

bool FIELDOUT::FO2_check_types(fldo2StringStringMap _inputMap,
	vector< vector< vector< string> > > _checkingType,int _molecule,
	int _group,string _programName,string _inputType)
{

bool checkStatus=false;
unsigned int i;
stringstream errorMsg;


for(i=0;i<_checkingType.at(_molecule).at(_group).size();i++)
{
	stringStringResult=_inputMap.find(_checkingType.at(_molecule).
		at(_group).at(i));

	if(stringStringResult==_inputMap.end())
	{
		errorMsg << _inputType << " type " << 
			_checkingType.at(_molecule).at(_group).at(i) 
			<< " at [" << _molecule+1 << "][" << _group+1 
			<< "][" << i+1 << "] not found...";
		SYSU_error_exit(_programName,errorMsg.str(),_SYSUTILS_IOERR);
	}

}

return checkStatus=true;

};

//=================================================================
//========== Method FO2_output_map_second_string2double ===========
//=================================================================

double FIELDOUT::FO2_output_map_second_string2double(
	_fldo2StringDoubleMap _inputMap,string _searchString,
	string _errorMessage,string _programName)
{

double outValue;
stringDoubleResult=_inputMap.find(_searchString);

if(stringDoubleResult==_inputMap.end())
{
	SYSU_error_exit(_programName,_errorMessage,_SYSUTILS_IOERR);
}
else
	outValue=stringDoubleResult->second;

return outValue;

};

//==============================================================
//========== Method FO2_output_map_second_string2int ===========
//==============================================================

int FIELDOUT::FO2_output_map_second_string2int(
	_fldo2StringIntMap _inputMap,string _searchString,
	string _errorMessage,string _programName)
{

int outValue;
stringIntResult=_inputMap.find(_searchString);

if(stringIntResult==_inputMap.end())
{
	SYSU_error_exit(_programName,_errorMessage,_SYSUTILS_IOERR);
}
else
	outValue=stringIntResult->second;

return outValue;

};

//=================================================================
//========== Method FO2_output_map_second_string2string ===========
//=================================================================
string FIELDOUT::FO2_output_map_second_string2string(
	fldo2StringStringMap _inputMap,string _searchString,
	string _errorMessage,string _programName)
{

string outValue;

stringStringResult=_inputMap.find(_searchString);

if(stringStringResult==_inputMap.end())
{
	SYSU_error_exit(_programName,_errorMessage,_SYSUTILS_IOERR);
}
else
	outValue=stringStringResult->second;


return outValue;

};
//=============================================
//========== Method write_fieldfile ===========
//=============================================

int FIELDOUT::write_fieldfile(string _outfn)
{
FILE *outfp;
int molecules,groups;
int elements;
int repeats;
int forces;
int sites;
int i;
int counter;
double outDouble;
int outInt;
string outString;
stringstream errorMessage;

errorMessage.clear();

outfp=open_file(_outfn,"w");

fprintf(outfp,"%s\n",SYSHEADER.c_str());
fprintf(outfp,"UNITS %-40s\n",_UNITS);
fprintf(outfp,"MOLECULES %d\n",MOLECULES);

for(molecules=0;molecules<MOLECULES;molecules++)
{

	fprintf(outfp,"%s\n",MOLHEADER.at(molecules).c_str());
	fprintf(outfp,"NUMMOLS %5d\n",NUMMOLS.at(molecules));

//write atoms
	counter=0;
	for(groups=0;groups<ATOMGROUPS.at(molecules);groups++)
	{
		for(elements=0;elements<atomelements.at(molecules).at(groups);
			elements++)
		{
			counter=counter+atomrepeat.at(molecules).at(groups).
				at(elements)*ATOMS.at(molecules).
				at(groups);
		}
	}
	if(counter>0) fprintf(outfp,"ATOMS %5d\n",counter);

	for(groups=0;groups<ATOMGROUPS.at(molecules);groups++)
	{
		for(repeats=0;repeats<ATOMS.at(molecules).at(groups);repeats++)
		{
			for(elements=0;elements<atomelements.at(molecules).
				at(groups);elements++)
			{
				fprintf(outfp,"%-8s",
					atomtype.at(molecules).at(groups).
					at(elements).c_str());

				errorMessage.clear();
				errorMessage << "unknown ATOM label "
				<< atomtype.at(molecules).at(groups).
				at(elements) << " in [" << molecules+1
				<< "][" << groups+1 << "][" << elements+1 
				<< "]..." << endl;

				outDouble=FO2_output_map_second_string2double(
					atomMass,
					atomtype.at(molecules).at(groups).
					at(elements),
					errorMessage.str(),
					_FIELDOUT_VERSION);
				fprintf(outfp,"%12.5f",outDouble);

				outDouble=FO2_output_map_second_string2double(
					atomCharge,
					atomtype.at(molecules).at(groups).
					at(elements),
					errorMessage.str(),
					_FIELDOUT_VERSION);


				fprintf(outfp,"%12.5f%5d\n",outDouble,
					atomrepeat.at(molecules).at(groups).
					at(elements));
			}
		}
	}

//write bonds
	counter=0;

	for(groups=0;groups<BONDGROUPS.at(molecules);groups++)
	{
		counter=counter+BONDS.at(molecules).at(groups)*
			bondelements.at(molecules).at(groups);
	}
	if(counter>0) fprintf(outfp,"BONDS %5d\n",counter);


	
	for(groups=0;groups<BONDGROUPS.at(molecules);groups++)
	{
		for(repeats=0;repeats<BONDS.at(molecules).at(groups);repeats++)
		{
			for(elements=0;elements<bondelements.at(molecules).
				at(groups);elements++)
			{
				errorMessage.clear();
				errorMessage << "unknown BOND label "
				<< bondtype.at(molecules).at(groups).
				at(elements) << " in [" << molecules+1
				<< "][" << groups+1 << "][" << 
				elements+1 << "]..." << endl;

				outString=FO2_output_map_second_string2string(
					bondPotKey,
					bondtype.at(molecules).at(groups).
					at(elements),
					errorMessage.str(),_FIELDOUT_VERSION);

				outInt=FO2_output_map_second_string2int(
					bondForceNr,
					bondtype.at(molecules).at(groups).
					at(elements),
					errorMessage.str(),_FIELDOUT_VERSION);



				fprintf(outfp,"%-4s%5d%5d",
				outString.c_str(),
				bondsite1.at(molecules).at(groups).
					at(elements)+repeats*bondstep1.
					at(molecules).at(groups).at(elements),
				bondsite2.at(molecules).at(groups).
					at(elements)+repeats*bondstep2.
					at(molecules).at(groups).at(elements));
				
				stringVDResult=bondForces.find(
					bondtype.at(molecules).
					at(groups).at(elements));
				if(stringVDResult==bondForces.end())
				{
					SYSU_error_exit(_FIELDOUT_VERSION,
						errorMessage.str(),
						_SYSUTILS_IOERR);
					}
				for(forces=0;forces<outInt;forces++)
				{
					fprintf(outfp,"%12.3f",stringVDResult->
						second.at(forces));
				}

				fprintf(outfp,"\n");
			}
		}
	}

//write constraints
	counter=0;

	for(groups=0;groups<CONSTGROUPS.at(molecules);groups++)
	{
		counter=counter+CONSTS.at(molecules).at(groups)*
			constelements.at(molecules).at(groups);
	}
	if(counter>0) fprintf(outfp,"CONSTRAINTS %5d\n",counter);


	
	for(groups=0;groups<CONSTGROUPS.at(molecules);groups++)
	{
		for(repeats=0;repeats<CONSTS.at(molecules).at(groups);repeats++)
		{
			for(elements=0;elements<constelements.at(molecules).
				at(groups);elements++)
			{
				stringDoubleResult=constLength.find(consttype.
					at(molecules).at(groups).at(elements));
				if(stringDoubleResult==constLength.end())
				{
					errorMessage.clear();
					errorMessage << "unknown CONST label "
					<< consttype.at(molecules).at(groups).
					at(elements) << " in [" << molecules+1
					<< "][" << groups+1 << "][" << 
					elements+1 << "]..." << endl;
					SYSU_error_exit(_FIELDOUT_VERSION,
					errorMessage.str(),_SYSUTILS_IOERR);
				}
				else
					outDouble=stringDoubleResult->second;
				fprintf(outfp,"%5d%5d%12.6f\n",
				constsite1.at(molecules).at(groups).
					at(elements)+repeats*conststep1.
					at(molecules).at(groups).at(elements),
				constsite2.at(molecules).at(groups).
					at(elements)+repeats*conststep2.
					at(molecules).at(groups).at(elements),						outDouble);
			}
		}
	}

//write angles
	counter=0;

	for(groups=0;groups<ANGLEGROUPS.at(molecules);groups++)
	{
		counter=counter+ANGLES.at(molecules).at(groups)*
			angleelements.at(molecules).at(groups);
	}
	if(counter>0) fprintf(outfp,"ANGLES %5d\n",counter);


	
	for(groups=0;groups<ANGLEGROUPS.at(molecules);groups++)
	{
		for(repeats=0;repeats<ANGLES.at(molecules).at(groups);repeats++)
		{
			for(elements=0;elements<angleelements.at(molecules).
				at(groups);elements++)
			{
				errorMessage.clear();
				errorMessage << "unknown ANGLE label "
				<< angletype.at(molecules).at(groups).
				at(elements) << " in [" << molecules+1
				<< "][" << groups+1 << "][" << 
				elements+1 << "]..." << endl;

				outString=FO2_output_map_second_string2string(
					anglePotKey,
					angletype.at(molecules).at(groups).
					at(elements),
					errorMessage.str(),_FIELDOUT_VERSION);

				outInt=FO2_output_map_second_string2int(
					angleForceNr,
					angletype.at(molecules).at(groups).
					at(elements),
					errorMessage.str(),_FIELDOUT_VERSION);

				fprintf(outfp,"%-4s%5d%5d%5d",
				outString.c_str(),
				anglesite1.at(molecules).at(groups).
					at(elements)+repeats*anglestep1.
					at(molecules).at(groups).at(elements),
				anglesite2.at(molecules).at(groups).
					at(elements)+repeats*anglestep2.
					at(molecules).at(groups).at(elements),
				anglesite3.at(molecules).at(groups).
					at(elements)+repeats*anglestep3.
					at(molecules).at(groups).at(elements));
				
				stringVDResult=angleForces.find(
					angletype.at(molecules).
					at(groups).at(elements));
				if(stringVDResult==angleForces.end())
				{
					SYSU_error_exit(_FIELDOUT_VERSION,
						errorMessage.str(),
						_SYSUTILS_IOERR);
					}
				for(forces=0;forces<outInt;forces++)
				{
					fprintf(outfp,"%12.6f",stringVDResult->
						second.at(forces));
				}

				fprintf(outfp,"\n");
			}
		}
	}

//write dihedrals
	counter=0;

	for(groups=0;groups<DIHGROUPS.at(molecules);groups++)
	{
		counter=counter+DIHEDRALS.at(molecules).at(groups)*
			dihelements.at(molecules).at(groups);
	}
	if(counter>0) fprintf(outfp,"DIHEDRALS %5d\n",counter);


	
	for(groups=0;groups<DIHGROUPS.at(molecules);groups++)
	{
		for(repeats=0;repeats<DIHEDRALS.at(molecules).at(groups);
			repeats++)
		{
			for(elements=0;elements<dihelements.at(molecules).
				at(groups);elements++)
			{
				errorMessage.clear();
				errorMessage << "unknown DIHEDRAL label "
				<< dihtype.at(molecules).at(groups).
				at(elements) << " in [" << molecules+1
				<< "][" << groups+1 << "][" << 
				elements+1 << "]..." << endl;

				outString=FO2_output_map_second_string2string(
					dihPotKey,
					dihtype.at(molecules).at(groups).
					at(elements),
					errorMessage.str(),_FIELDOUT_VERSION);

				outInt=FO2_output_map_second_string2int(
					dihForceNr,
					dihtype.at(molecules).at(groups).
					at(elements),
					errorMessage.str(),_FIELDOUT_VERSION);

				fprintf(outfp,"%-4s%5d%5d%5d%5d",
				outString.c_str(),
				dihsite1.at(molecules).at(groups).
					at(elements)+repeats*dihstep1.
					at(molecules).at(groups).at(elements),
				dihsite2.at(molecules).at(groups).
					at(elements)+repeats*dihstep2.
					at(molecules).at(groups).at(elements),
				dihsite3.at(molecules).at(groups).
					at(elements)+repeats*dihstep3.
					at(molecules).at(groups).at(elements),
				dihsite4.at(molecules).at(groups).
					at(elements)+repeats*dihstep4.
					at(molecules).at(groups).at(elements));
				
				stringVDResult=dihForces.find(
					dihtype.at(molecules).
					at(groups).at(elements));
				if(stringVDResult==dihForces.end())
				{
					SYSU_error_exit(_FIELDOUT_VERSION,
						errorMessage.str(),
						_SYSUTILS_IOERR);
				}

				if(compare_strings_nocase(outString,SYLV))
				{
					for(forces=0;forces<SYLV_PARAMS1;
						forces++)
						fprintf(outfp,"%12.6f",
							stringVDResult->
							second.at(forces));
					fprintf(outfp,"\n");
					for(forces=SYLV_PARAMS1;forces<outInt;
						forces++)
						fprintf(outfp,"%12.6f",
							stringVDResult->
							second.at(forces));
				}
				else
				if(compare_strings_nocase(outString,COSB))
				{
					for(forces=0;forces<COSB_PARAMS1;
						forces++)
						fprintf(outfp,"%12.6f",
							stringVDResult->
							second.at(forces));
					fprintf(outfp,"\n");
					for(forces=COSB_PARAMS1;
						forces<COSB_PARAMS2;forces++)
						fprintf(outfp,"%12.6f",
							stringVDResult->
							second.at(forces));
					fprintf(outfp,"\n");
					for(forces=COSB_PARAMS2;
						forces<COSB_PARAMS3;forces++)
						fprintf(outfp,"%12.6f",
							stringVDResult->
							second.at(forces));
				}
				else
				if(compare_strings_nocase(outString,TORV))
				{
					for(forces=0;forces<TORV_PARAMS1;
						forces++)
						fprintf(outfp,"%12.6f",
							stringVDResult->
							second.at(forces));
					fprintf(outfp,"\n");
					for(forces=TORV_PARAMS1;forces<outInt;
						forces++)
						fprintf(outfp,"%12.6f",
							stringVDResult->
							second.at(forces));
				}
				else
				if(compare_strings_nocase(outString,COS5))
				{
					for(forces=0;forces<COS5_PARAMS1;
						forces++)
						fprintf(outfp,"%12.6f",
							stringVDResult->
							second.at(forces));
					fprintf(outfp,"\n");
					for(forces=COS5_PARAMS1;
						forces<COS5_PARAMS2;forces++)
						fprintf(outfp,"%12.6f",
							stringVDResult->
							second.at(forces));
					fprintf(outfp,"%12.6f%12.6f",0.0,0.0);
				}
				else
				if(compare_strings_nocase(outString,ZERO))
				{
				}
				else
				if(compare_strings_nocase(outString,ANDI))
				{
					for(forces=0;forces<ANDI_PARAMS1;
						forces++)
						fprintf(outfp,"%12.6f",
							stringVDResult->
							second.at(forces));
					fprintf(outfp,"\n");
					for(forces=ANDI_PARAMS1;forces<outInt;
						forces++)
						fprintf(outfp,"%12.6f",
							stringVDResult->
							second.at(forces));
				}
				else
				for(forces=0;forces<outInt;forces++)
				{
					fprintf(outfp,"%12.6f",stringVDResult->
						second.at(forces));
				}

				fprintf(outfp,"\n");
			}
		}
	}

//write dihedrals
/*	
	count=0;
	for(j=0;j<DIHGROUPS[i];j++)
	{
		count=count+DIHS[i][j]*dihscount[i][j];
	}
	if(count>0) fprintf(outfp,"DIHEDRALS %5d\n",count);
	
	for(j=0;j<DIHGROUPS[i];j++)
	{
		for(k=0;k<dihscount[i][j];k++)
		{
			for(l=0;l<DIHS[i][j];l++)
			{
				fprintf(outfp,"%-4s%5d%5d%5d%5d",
				dihtype[dihstype[i][j][l]],
				dihsite1[i][j][l]+k*dihstep1[i][j][l],
				dihsite2[i][j][l]+k*dihstep2[i][j][l],
				dihsite3[i][j][l]+k*dihstep3[i][j][l],
				dihsite4[i][j][l]+k*dihstep4[i][j][l]);

				if(comp_str(dihtype[dihstype[i][j][l]],
							"sylv\0")==0)
				{
					for(m=0;m<_SYLV_PARAMS;m++)
						fprintf(outfp,"%12.6f",
						dihforce[dihstype[i][j][l]][m]);
					fprintf(outfp,"\n");
					for(m=_SYLV_PARAMS;
						m<dihforcenr[dihstype[i][j][l]]
						;m++)
					{       
					fprintf(outfp,"%12.6f",
					dihforce[dihstype[i][j][l]][m]);
					}       
					fprintf(outfp,"\n");	
				}
				else if(comp_str(dihtype[dihstype[i][j][l]],
							"zero\0")==0)
					fprintf(outfp,"\n");
				else if(comp_str(dihtype[dihstype[i][j][l]],
							"cosb\0")==0)
				{
		for(m=0;m<_COSB_PARAMS1;m++)
		{
			fprintf(outfp,"%12.6f",dihforce[dihstype[i][j][l]][m]);
		}
		fprintf(outfp,"\n");

		for(m=_COSB_PARAMS1;m<_COSB_PARAMS1+_COSB_PARAMS2;m++)
			fprintf(outfp,"%12.6f",dihforce[dihstype[i][j][l]][m]);
		fprintf(outfp,"\n");	
		for(m=_COSB_PARAMS1+_COSB_PARAMS2;
			m<dihforcenr[dihstype[i][j][l]];m++)
			fprintf(outfp,"%12.6f",dihforce[dihstype[i][j][l]][m]);
		fprintf(outfp,"\n");	
				}
				else if(comp_str(dihtype[dihstype[i][j][l]],
							"andi\0")==0)
				{
					for(m=0;m<_ANDI_PARAMS;m++)
						fprintf(outfp,"%12.6f",
						dihforce[dihstype[i][j][l]][m]);
					fprintf(outfp,"\n");
					for(m=_ANDI_PARAMS;
						m<dihforcenr[dihstype[i][j][l]]
						;m++)
					{       
					fprintf(outfp,"%12.6f",
					dihforce[dihstype[i][j][l]][m]);
					}       
					fprintf(outfp,"\n");	
				}
				else
				{	
					for(m=0;m<dihforcenr[dihstype[i][j][l]]
						;m++)
					{
						fprintf(outfp,"%12.6f",
						dihforce[dihstype[i][j][l]][m]);
					}
					fprintf(outfp,"\n");
				}
			}
		}
	}
*/

//write inversions
	counter=0;

	for(groups=0;groups<INVGROUPS.at(molecules);groups++)
	{
		counter=counter+INVS.at(molecules).at(groups)*
			invelements.at(molecules).at(groups);
	}
	if(counter>0) fprintf(outfp,"INVERSIONS %5d\n",counter);


	
	for(groups=0;groups<INVGROUPS.at(molecules);groups++)
	{
		for(repeats=0;repeats<INVS.at(molecules).at(groups);
			repeats++)
		{
			for(elements=0;elements<invelements.at(molecules).
				at(groups);elements++)
			{
				errorMessage.clear();
				errorMessage << "unknown INVERSION label "
				<< invtype.at(molecules).at(groups).
				at(elements) << " in [" << molecules+1
				<< "][" << groups+1 << "][" << 
				elements+1 << "]..." << endl;

				outString=FO2_output_map_second_string2string(
					invPotKey,
					invtype.at(molecules).at(groups).
					at(elements),
					errorMessage.str(),_FIELDOUT_VERSION);

				outInt=FO2_output_map_second_string2int(
					invForceNr,
					invtype.at(molecules).at(groups).
					at(elements),
					errorMessage.str(),_FIELDOUT_VERSION);

				fprintf(outfp,"%-4s%5d%5d%5d%5d",
				outString.c_str(),
				invsite1.at(molecules).at(groups).
					at(elements)+repeats*invstep1.
					at(molecules).at(groups).at(elements),
				invsite2.at(molecules).at(groups).
					at(elements)+repeats*invstep2.
					at(molecules).at(groups).at(elements),
				invsite3.at(molecules).at(groups).
					at(elements)+repeats*invstep3.
					at(molecules).at(groups).at(elements),
				invsite4.at(molecules).at(groups).
					at(elements)+repeats*invstep4.
					at(molecules).at(groups).at(elements));
				
				stringVDResult=invForces.find(
					invtype.at(molecules).
					at(groups).at(elements));
				if(stringVDResult==invForces.end())
				{
					SYSU_error_exit(_FIELDOUT_VERSION,
						errorMessage.str(),
						_SYSUTILS_IOERR);
					}
				for(forces=0;forces<outInt;forces++)
				{
					fprintf(outfp,"%12.6f",stringVDResult->
						second.at(forces));
				}

				fprintf(outfp,"\n");
			}
		}
	}

//write inversions
/*
        count=0;
        for(j=0;j<INVGROUPS[i];j++)
        {
                count=count+INVS[i][j]*invscount[i][j];
        }
        if(count>0) fprintf(outfp,"INVERSIONS %5d\n",count);
        
        for(j=0;j<INVGROUPS[i];j++)
        {
                for(k=0;k<invscount[i][j];k++)
                {
                        for(l=0;l<INVS[i][j];l++)
                        {
                                fprintf(outfp,"%-4s%5d%5d%5d%5d",
                                invtype[invstype[i][j][l]],
                                invsite1[i][j][l]+k*invstep1[i][j][l],
                                invsite2[i][j][l]+k*invstep2[i][j][l],
                                invsite3[i][j][l]+k*invstep3[i][j][l],
                                invsite4[i][j][l]+k*invstep4[i][j][l]);

                                for(m=0;m<invforcenr[invstype[i][j][l]];m++)
                                {
                                        fprintf(outfp,"%12.6f",
                                                invforce[invstype[i][j][l]][m]);
                                }
                                fprintf(outfp,"\n");
                        }
                }
        }
*/

//write rigids
	counter=0;

	for(groups=0;groups<RIGIDGROUPS.at(molecules);groups++)
	{
		counter=counter+RIGIDS.at(molecules).at(groups)*
			rigidelements.at(molecules).at(groups);
	}
	if(counter>0) fprintf(outfp,"RIGID %5d\n",counter);


	for(groups=0;groups<RIGIDGROUPS.at(molecules);groups++)
	{
		for(repeats=0;repeats<RIGIDS.at(molecules).at(groups);repeats++)
		{
			for(elements=0;elements<rigidelements.at(molecules).
				at(groups);elements++)
			{
				fprintf(outfp,"%5d",rigidnr.at(molecules).
					at(groups).at(elements));
				for(sites=0;sites<rigidnr.at(molecules).
					at(groups).at(elements);sites++)
				{

					fprintf(outfp,"%5d",rigidsite.
						at(molecules).at(groups).
						at(elements).at(sites)+repeats*
						rigidstep.at(molecules).
						at(groups).at(elements).
						at(sites));

				}
/*
				constsite1.at(molecules).at(groups).
					at(elements)+repeats*conststep1.
					at(molecules).at(groups).at(elements),
				constsite2.at(molecules).at(groups).
					at(elements)+repeats*conststep2.
					at(molecules).at(groups).at(elements),						outDouble);
*/
				fprintf(outfp,"\n");
			}
		}
	}
//write rigids
/*
	for(j=0;j<RIGIDGROUPS[i];j++)
	{
		for(k=0;k<rigidscount[i][j];k++)
		{
			for(l=0;l<RIGIDS[i][j];l++)
			{
				fprintf(outfp,"%5d",rigidnr[i][j][l]);
				for(n=0;n<rigidnr[i][j][l];n++)
				fprintf(outfp,"%5d",
					rigidsite[i][j][l][n]+
					k*rigidstep[i][j][l][n]);
				fprintf(outfp,"\n");
			}
		}
	}
*/
//write rigid complexes
	
//	if(RIGIDS[i]>0) fprintf(outfp,"RIGID %5d\n",RIGIDS[i]);
//	
//	for(j=0;j<RIGIDS[i];j++)
//	{
//		fprintf(outfp,"%5d",rigidnr[i][j]);
//		
//		for(k=0;k<rigidnr[i][j];k++)
//		{
//			fprintf(outfp,"%5d",rigidsite[i][j][k]);	
//		}
//		fprintf(outfp,"\n");
//	}
	
//write tethered atoms
/*	
	count=0;
	for(j=0;j<TETHGROUPS[i];j++)
	{
		count=count+TETHS[i][j]*tethcount[i][j];
	}
	if(count>0) fprintf(outfp,"TETH %5d\n",count);
	
	for(j=0;j<TETHGROUPS[i];j++)
	{
		for(k=0;k<tethcount[i][j];k++)
		{
			for(l=0;l<TETHS[i][j];l++)
			{
				fprintf(outfp,"%-4s%5d",
				tethftype[tethtype[i][j][l]],
				tethsite[i][j][l]+k*tethstep[i][j][l]);
				for(m=0;m<tethforcenr[tethtype[i][j][l]];m++)
				{
					fprintf(outfp,"%12.6f",
					tethforce[tethtype[i][j][l]][m]);
				}
				fprintf(outfp,"\n");
			}
		}
	}
	
*/
/*
	fprintf(outfp,"FINISH\n");
}
*/

//write vdw
/*
fprintf(outfp,"VDW %d\n",VDWS);
for(i=0;i<VDWS;i++)
{
	fprintf(outfp,"%-8s%-8s%-4s ",atlabel[vdwsite1[i]],atlabel[vdwsite2[i]],
			vdwtype[i]);
	fprintf(outfp,"%12.6f%12.6f",vdwforce[i][0],vdwforce[i][1]);
	for(j=2;j<vdwforcenr[i];j++)
	{
		fprintf(outfp,"%12.6f",vdwforce[i][j]);
	}
	fprintf(outfp,"\n");
*/
	fprintf(outfp,"FINISH\n");
}


//write vdw


fprintf(outfp,"VDW %d\n",VDWS);
for(elements=0;elements<VDWS;elements++)
{
	fprintf(outfp,"%-8s%-8s%-4s ",vdwAtom1.at(elements).c_str(),
		vdwAtom2.at(elements).c_str(),vdwPotKey.at(elements).c_str());
	fprintf(outfp,"%12.1f",vdwForce.at(elements).at(0));
	if(vdwPotKey.at(elements)=="buck"||vdwPotKey.at(elements)=="dibu" || vdwPotKey.at(elements)=="di12")
		fprintf(outfp,"%12.6f",vdwForce.at(elements).at(1));
	else
		fprintf(outfp,"%12.1f",vdwForce.at(elements).at(1));
	for(forces=2;forces<vdwForceNr.at(elements);forces++)
		fprintf(outfp,"%12.6f",vdwForce.at(elements).at(forces));
	fprintf(outfp,"\n");
}

fprintf(outfp,"CLOSE\n");

i=close_file(outfp);

return i;
};






