//  Class: fieldin
//Version: fieldin-00.00.04-070226 by cipo@physic.ut.ee
// Author: cipo@physic.ut.ee
// Description: class to read DL_POLY FIELD file
//  

#include <iostream>
#include <string>
#include <vector>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef _SYSUTILS
#define _SYSUTILS
#include "sysutils.h"
#endif

#ifndef _FIELDIN_VERSION
#define _FIELDIN_VERSION "Version: fieldin-00.00.04-070226 by cipo@physic.ut.ee\0"
#define _FI_FINISH_IDX 0
#define _FI_SHELL_IDX 1
#define _FI_BONDS_IDX 2
#define _FI_CONST_IDX 3
#define _FI_PMF_IDX 4
#define _FI_ANG_IDX 5
#define _FI_DIH_IDX 6
#define _FI_INV_IDX 7
#define _FI_RIG_IDX 8
#define _FI_TETH_IDX 9
#define _FI_BOND_FORCE 4
#define _FI_ANG_FORCE 4
#define _FI_DIH_FORCE 9
#define _FI_INV_FORCE 2
#define _FI_TETH_FORCE 4

#endif


class FIELDIN:SYSUTILS
{


public:

char FI_HEADER[81];
char FI_UNITS[41];
int FI_MOLECULES;
char **FI_MOLHEADER;
int *FI_NUMMOLS;

char **fi_tmplabel;
double *fi_tmpweight,*fi_tmpcharge;
int *fi_tmprepeat,*fi_tmpifrz,*fi_tmpigrp;

int *FI_ATOMS;
int *FI_ATOMTYPES;

char ***FI_label;
double **FI_weight,**FI_charge;
int **FI_repeat,**FI_ifrz,**FI_igrp;

int *FI_SHELL,*FI_BONDS,*FI_CONST,*FI_ANG,*FI_DIH,*FI_INV,*FI_RIG;
int *FI_TETH;

int **FI_shellsite1,**FI_shellsite2;
double **FI_shellspring;

char ***FI_bondkey;
int **FI_bondsite1,**FI_bondsite2;
double ***FI_bondforce;

int **FI_constsite1,**FI_constsite2;
double **FI_constlen;

double *FI_PMF;
int *FI_PMF1,*FI_PMF2,**FI_pmf1site,**FI_pmf2site;
double **FI_pmf1weight,**FI_pmf2weight;

char ***FI_angkey;
int **FI_angsite1,**FI_angsite2,**FI_angsite3;
double ***FI_angforce;

char ***FI_dihkey;
int **FI_dihsite1,**FI_dihsite2,**FI_dihsite3,**FI_dihsite4;
double ***FI_dihforce;

char ***FI_invkey;
int **FI_invsite1,**FI_invsite2,**FI_invsite3,**FI_invsite4;
double ***FI_invforce;

int **FI_rigidnr,***FI_rigidsite;

char ***FI_tethkey;
int **FI_tethsite;
double ***FI_tethforce;

FIELDIN(string _inputfn);
~FIELDIN();
int FI_retr_molecules();
int FI_retr_nummols(int _molecule);
int FI_retr_atoms(int _molecule);
int FI_retr_angles(int _molecule);
int FI_retr_angsite1indx(int _molecule,int _anglenr);
int FI_retr_angsite2indx(int _molecule,int _anglenr);
int FI_retr_angsite3indx(int _molecule,int _anglenr);
int FI_retr_angsite1label(int _molecule,int _anglenr,char *_label);
int FI_retr_angsite2label(int _molecule,int _anglenr,char *_label);
int FI_retr_angsite3label(int _molecule,int _anglenr,char *_label);
int FI_retr_dihedrals(int _molecule);
int FI_retr_dihsite1indx(int _molecule,int _danglenr);
int FI_retr_dihsite2indx(int _molecule,int _danglenr);
int FI_retr_dihsite3indx(int _molecule,int _danglenr);
int FI_retr_dihsite4indx(int _molecule,int _danglenr);
int FI_retr_dihsite1label(int _molecule,int _danglenr,char *_label);
int FI_retr_dihsite2label(int _molecule,int _danglenr,char *_label);
int FI_retr_dihsite3label(int _molecule,int _danglenr,char *_label);
int FI_retr_dihsite4label(int _molecule,int _danglenr,char *_label);
int FI_retr_rigids(const int _molecule);
	// returns a number on RIGID records in the _molecule
vector <int> FI_retr_rigid_sites(const int _molecule,const int _rigidnr);
	// retruns a vector of rigid complex sites in _molecule
int FI_find_rigidnr(const int _molecule,const int _atomIndex);
	// retruns a position of rigid sites containing atom _atomIndex
	// in _molecule
	// return -1 if not found
vector <int> FI_find_rigid_sites(const int _molecule,const int _atomIndex);
	// retruns a vector of rigid complex sites containing atom _atomIndex
	// in _molecule
	// size()=0 if not found
};

// NB: indexing starts form 0








