#include "fieldin.h"


//=========================================
//========== Constructor FIELDIN ==========
//=========================================

FIELDIN::FIELDIN(string _inputfn)
{

int i,j,k,l;
int count=0,count1=0;
FILE *infp;

printf("%s started...\n",_FIELDIN_VERSION);

infp=open_file(_inputfn,"r");

i=nextfilerecord(infp);
i=read_line100char(&FI_HEADER[0]);

printf("%s",FI_HEADER);

i=nextfilerecord(infp);
i=test_filelinestring(1,"UNITS\0","IOERROR:",_inputfn,1);
i=read_linestring(&FI_UNITS[0],2);
i=cut_stringend(&FI_UNITS[0]);

i=nextfilerecord(infp);
i=test_filelinestring(1,"MOLECULES\0","IOERROR:",_inputfn,1);
FI_MOLECULES=read_lineint(2);

printf("MOLECULES %d\n",FI_MOLECULES);

FI_MOLHEADER=allocate_string2(FI_MOLECULES,81,_FIELDIN_VERSION,"FI_MOLHEADER",3);
FI_NUMMOLS=allocate_int(FI_MOLECULES,_FIELDIN_VERSION,"FI_NUMMOLS",3);
FI_ATOMS=allocate_int(FI_MOLECULES,_FIELDIN_VERSION,"FI_ATOMS",3);
FI_ATOMTYPES=allocate_int(FI_MOLECULES,_FIELDIN_VERSION,"FI_ATOMTYPES",3);

FI_label=allocate_3string(FI_MOLECULES,_FIELDIN_VERSION,"FI_label 3str\0",3);
FI_weight=allocate_2double(FI_MOLECULES,_FIELDIN_VERSION,"FI_weight 2db\0",3);
FI_charge=allocate_2double(FI_MOLECULES,_FIELDIN_VERSION,"FI_charge 2db\0",3);
FI_repeat=allocate_2int(FI_MOLECULES,_FIELDIN_VERSION,"FI_repeat 2int\0",3);
FI_ifrz=allocate_2int(FI_MOLECULES,_FIELDIN_VERSION,"FI_ifrz 2int\0",3);
FI_igrp=allocate_2int(FI_MOLECULES,_FIELDIN_VERSION,"FI_igrp 2int\0",3);

FI_SHELL=allocate_int(FI_MOLECULES,_FIELDIN_VERSION,"FI_SHELL",3);
FI_BONDS=allocate_int(FI_MOLECULES,_FIELDIN_VERSION,"FI_BONDS",3);
FI_CONST=allocate_int(FI_MOLECULES,_FIELDIN_VERSION,"FI_CONST",3);
FI_ANG=allocate_int(FI_MOLECULES,_FIELDIN_VERSION,"FI_ANG",3);
FI_DIH=allocate_int(FI_MOLECULES,_FIELDIN_VERSION,"FI_DIH",3);
FI_INV=allocate_int(FI_MOLECULES,_FIELDIN_VERSION,"FI_INV",3);
FI_RIG=allocate_int(FI_MOLECULES,_FIELDIN_VERSION,"FI_RIG",3);
FI_TETH=allocate_int(FI_MOLECULES,_FIELDIN_VERSION,"FI_TETH",3);

FI_shellsite1=allocate_2int(FI_MOLECULES,_FIELDIN_VERSION,"FI_shellsite1\0",3);
FI_shellsite2=allocate_2int(FI_MOLECULES,_FIELDIN_VERSION,"FI_shellsite2\0",3);
FI_shellspring=allocate_2double(FI_MOLECULES,_FIELDIN_VERSION,
		"FI_shellspring\0",3);

FI_bondkey=allocate_3string(FI_MOLECULES,_FIELDIN_VERSION,"FI_bondkey\0",3);
FI_bondsite1=allocate_2int(FI_MOLECULES,_FIELDIN_VERSION,"FI_bondsite1\0",3);
FI_bondsite2=allocate_2int(FI_MOLECULES,_FIELDIN_VERSION,"FI_bondsite2\0",3);
FI_bondforce=allocate_3double(FI_MOLECULES,_FIELDIN_VERSION,"FI_bondforce\0",3);

FI_constsite1=allocate_2int(FI_MOLECULES,_FIELDIN_VERSION,"FI_constsite1\0",3);
FI_constsite2=allocate_2int(FI_MOLECULES,_FIELDIN_VERSION,"FI_constsite2\0",3);
FI_constlen=allocate_2double(FI_MOLECULES,_FIELDIN_VERSION,"FI_constlen\0",3);

FI_PMF=allocate_double(FI_MOLECULES,_FIELDIN_VERSION,"FI_PMF",3);
FI_PMF1=allocate_int(FI_MOLECULES,_FIELDIN_VERSION,"FI_PMF1",3);
FI_PMF2=allocate_int(FI_MOLECULES,_FIELDIN_VERSION,"FI_PMF2",3);
FI_pmf1site=allocate_2int(FI_MOLECULES,_FIELDIN_VERSION,"FI_pmf1site",3);
FI_pmf2site=allocate_2int(FI_MOLECULES,_FIELDIN_VERSION,"FI_pmf2site",3);
FI_pmf1weight=allocate_2double(FI_MOLECULES,_FIELDIN_VERSION,
		"FI_pmf1weight",3);
FI_pmf2weight=allocate_2double(FI_MOLECULES,_FIELDIN_VERSION,
		"FI_pmf2weight",3);

FI_angkey=allocate_3string(FI_MOLECULES,_FIELDIN_VERSION,"FI_angkey\0",3);
FI_angsite1=allocate_2int(FI_MOLECULES,_FIELDIN_VERSION,"FI_angsite1\0",3);
FI_angsite2=allocate_2int(FI_MOLECULES,_FIELDIN_VERSION,"FI_angsite2\0",3);
FI_angsite3=allocate_2int(FI_MOLECULES,_FIELDIN_VERSION,"FI_angsite3\0",3);
FI_angforce=allocate_3double(FI_MOLECULES,_FIELDIN_VERSION,"FI_angforce\0",3);

FI_dihkey=allocate_3string(FI_MOLECULES,_FIELDIN_VERSION,"FI_dihkey\0",3);
FI_dihsite1=allocate_2int(FI_MOLECULES,_FIELDIN_VERSION,"FI_dihsite1\0",3);
FI_dihsite2=allocate_2int(FI_MOLECULES,_FIELDIN_VERSION,"FI_dihsite2\0",3);
FI_dihsite3=allocate_2int(FI_MOLECULES,_FIELDIN_VERSION,"FI_dihsite3\0",3);
FI_dihsite4=allocate_2int(FI_MOLECULES,_FIELDIN_VERSION,"FI_dihsite4\0",3);
FI_dihforce=allocate_3double(FI_MOLECULES,_FIELDIN_VERSION,"FI_dihforce\0",3);

FI_invkey=allocate_3string(FI_MOLECULES,_FIELDIN_VERSION,"FI_invkey\0",3);
FI_invsite1=allocate_2int(FI_MOLECULES,_FIELDIN_VERSION,"FI_invsite1\0",3);
FI_invsite2=allocate_2int(FI_MOLECULES,_FIELDIN_VERSION,"FI_invsite2\0",3);
FI_invsite3=allocate_2int(FI_MOLECULES,_FIELDIN_VERSION,"FI_invsite3\0",3);
FI_invsite4=allocate_2int(FI_MOLECULES,_FIELDIN_VERSION,"FI_invsite4\0",3);
FI_invforce=allocate_3double(FI_MOLECULES,_FIELDIN_VERSION,"FI_invforce\0",3);

FI_rigidnr=allocate_2int(FI_MOLECULES,_FIELDIN_VERSION,"FI_rigidnr\0",3);
FI_rigidsite=allocate_3int(FI_MOLECULES,_FIELDIN_VERSION,"FI_rigidsite\0",3);

FI_tethkey=allocate_3string(FI_MOLECULES,_FIELDIN_VERSION,"FI_tethkey\0",3);
FI_tethsite=allocate_2int(FI_MOLECULES,_FIELDIN_VERSION,"FI_tethsite\0",3);
FI_tethforce=allocate_3double(FI_MOLECULES,_FIELDIN_VERSION,"FI_tethforce\0",3);

for(j=0;j<FI_MOLECULES;j++)
{

printf("MOLECULE #%d\n",j);

i=nextfilerecord(infp);
i=read_line100char(FI_MOLHEADER[j]);
i=cut_stringend(FI_MOLHEADER[j]);
printf("%s\n",FI_MOLHEADER[j]);

i=nextfilerecord(infp);
i=test_filelinestring(1,"NUMMOLS\0","IOERROR:",_inputfn,1);
FI_NUMMOLS[j]=read_lineint(2);

printf("NUMMOLS %d\n",FI_NUMMOLS[j]);

i=nextfilerecord(infp);
i=test_filelinestring(1,"ATOMS\0","IOERROR:",_inputfn,1);
FI_ATOMS[j]=read_lineint(2);


fi_tmplabel=allocate_string2(FI_ATOMS[j],_SYSUTIL_TSTRING_LEN,_FIELDIN_VERSION,"fi_tmplabel",3);
fi_tmpweight=allocate_double(FI_ATOMS[j],_FIELDIN_VERSION,"fi_tmpweight",3);
fi_tmpcharge=allocate_double(FI_ATOMS[j],_FIELDIN_VERSION,"fi_charge",3);
fi_tmprepeat=allocate_int(FI_ATOMS[j],_FIELDIN_VERSION,"fi_tmprepeat",3);
fi_tmpifrz=allocate_int(FI_ATOMS[j],_FIELDIN_VERSION,"fi_tmpifrz",3);
fi_tmpigrp=allocate_int(FI_ATOMS[j],_FIELDIN_VERSION,"fi_tmpigrp",3);

k=0;
count=0;

while(k<FI_ATOMS[j])
{
	i=nextfilerecord(infp);
	i=read_linestring(fi_tmplabel[count],1);
	fi_tmpweight[count]=read_linedouble(2);
	fi_tmpcharge[count]=read_linedouble(3);
	fi_tmprepeat[count]=read_lineint(4);
	if(fi_tmprepeat[count]==-1) fi_tmprepeat[count]=1;
	fi_tmpifrz[count]=read_lineint(5);
	if(fi_tmpifrz[count]==-1) fi_tmpifrz[count]=0;
	fi_tmpigrp[count]=read_lineint(6);
	if(fi_tmpigrp[count]==-1) fi_tmpigrp[count]=0;
	k=k+fi_tmprepeat[count];
	count=count+1;
}

FI_ATOMTYPES[j]=count;
printf("ATOMS %d read: %d\n",FI_ATOMS[j],count);

FI_label[j]=allocate_string2(FI_ATOMTYPES[j],_SYSUTIL_TSTRING_LEN,_FIELDIN_VERSION,"FI_label str2",3);
FI_weight[j]=allocate_double(FI_ATOMTYPES[j],_FIELDIN_VERSION,"FI_weight[j]\0",3);
FI_charge[j]=allocate_double(FI_ATOMTYPES[j],_FIELDIN_VERSION,"FI_charge[j]\0",3);
FI_repeat[j]=allocate_int(FI_ATOMTYPES[j],_FIELDIN_VERSION,"FI_repeat[j]\0",3);
FI_ifrz[j]=allocate_int(FI_ATOMTYPES[j],_FIELDIN_VERSION,"FI_ifrz[j]\0",3);
FI_igrp[j]=allocate_int(FI_ATOMTYPES[j],_FIELDIN_VERSION,"FI_igrp[j]\0",3);

for(k=0;k<FI_ATOMTYPES[j];k++)
{
	strcpy(FI_label[j][k],fi_tmplabel[k]);
	FI_weight[j][k]=fi_tmpweight[k];
	FI_charge[j][k]=fi_tmpcharge[k];
	FI_repeat[j][k]=fi_tmprepeat[k];
	FI_ifrz[j][k]=fi_tmpifrz[k];
	FI_igrp[j][k]=fi_tmpigrp[k];
}

for(k=0;k<FI_ATOMS[j];k++) delete fi_tmplabel[k];
delete fi_tmplabel;
delete fi_tmpweight;
delete fi_tmpcharge;
delete fi_tmprepeat;
delete fi_tmpifrz;
delete fi_tmpigrp;


count=-1;
while(count!=_FI_FINISH_IDX)
{
	//	printf("COUNT %d\n",count);
	count=-1;
	count1=0;
	i=nextfilerecord(infp);
	i=test_string(1,"shells\0");
	if(i==0) count=_FI_SHELL_IDX;
	i=test_string(1,"bonds\0");
	if(i==0) count=_FI_BONDS_IDX;
	i=test_string(1,"constraints\0");
	if(i==0) count=_FI_CONST_IDX;
	i=test_string(1,"pmf\0");
	if(i==0) count=_FI_PMF_IDX;
	i=test_string(1,"angles\0");
	if(i==0) count=_FI_ANG_IDX;
	i=test_string(1,"dihedrals\0");
	if(i==0) count=_FI_DIH_IDX;
	i=test_string(1,"inversions\0");
	if(i==0) count=_FI_INV_IDX;
	i=test_string(1,"rigid\0");
	if(i==0) count=_FI_RIG_IDX;
	i=test_string(1,"teth\0");
	if(i==0) count=_FI_TETH_IDX;
	i=test_string(1,"finish\n");
	if(i==0) count=_FI_FINISH_IDX;
//	i=read_line100char(&tmpchar[0]);
//		printf("COUNT1 %d %s\n",count,tmpchar);

	switch(count)
	{
		case _FI_FINISH_IDX: break;
		case _FI_SHELL_IDX:
		{
			FI_SHELL[j]=read_lineint(2);
			FI_shellsite1[j]=allocate_int(FI_SHELL[j],
				_FIELDIN_VERSION,"FI_shellsite1[j]\0",3);
			FI_shellsite2[j]=allocate_int(FI_SHELL[j],
				_FIELDIN_VERSION,"FI_shellsite2[j]\0",3);
			FI_shellspring[j]=allocate_double(FI_SHELL[j],
				_FIELDIN_VERSION,"FI_shellspring[j]\0",3);
			for(k=0;k<FI_SHELL[j];k++)
			{
				i=nextfilerecord(infp);
				FI_shellsite1[j][k]=read_lineint(1);
				FI_shellsite2[j][k]=read_lineint(2);
				FI_shellspring[j][k]=read_linedouble(3);
				count1=count1+1;
			}
			printf("SHELL %d read: %d\n",FI_SHELL[j],count1);
			count1=0;
			break;
		}
		case _FI_BONDS_IDX:
		{
			FI_BONDS[j]=read_lineint(2);
			FI_bondkey[j]=allocate_string2(FI_BONDS[j],
				_SYSUTIL_TSTRING_LEN_S,_FIELDIN_VERSION,
				"FI_bondkey[j]\0",3);
			FI_bondsite1[j]=allocate_int(FI_BONDS[j],
				_FIELDIN_VERSION,"FI_bondsite1[j]\0",3);
			FI_bondsite2[j]=allocate_int(FI_BONDS[j],
				_FIELDIN_VERSION,"FI_bondsite2[j]\0",3);
			FI_bondforce[j]=allocate_double2(FI_BONDS[j],
				_FI_BOND_FORCE,_FIELDIN_VERSION,
				"FI_bondforce[j]\0",3);
			for(k=0;k<FI_BONDS[j];k++)
			{
				i=nextfilerecord(infp);
				i=read_linestring(FI_bondkey[j][k],1);
				FI_bondsite1[j][k]=read_lineint(2);
				FI_bondsite2[j][k]=read_lineint(3);
				for(l=0;l<_FI_BOND_FORCE;l++)
				  FI_bondforce[j][k][l]=read_linedouble(4+l);
				count1=count1+1;
			}
			printf("BONDS %d read: %d\n",FI_BONDS[j],count1);
			break;
		}
		case _FI_CONST_IDX:
		{
			FI_CONST[j]=read_lineint(2);
			FI_constsite1[j]=allocate_int(FI_CONST[j],
				_FIELDIN_VERSION,"FI_constsite1[j]\0",3);
			FI_constsite2[j]=allocate_int(FI_CONST[j],
				_FIELDIN_VERSION,"FI_constsite2[j]\0",3);
			FI_constlen[j]=allocate_double(FI_CONST[j],
				_FIELDIN_VERSION,"FI_constlen[j]\0",3);
			for(k=0;k<FI_CONST[j];k++)
			{
				i=nextfilerecord(infp);
				FI_constsite1[j][k]=read_lineint(1);
				FI_constsite2[j][k]=read_lineint(2);
				FI_constlen[j][k]=read_linedouble(3);
				count1=count1+1;
//printf("CONST %d %d %f\n",FI_constsite1[j][k],FI_constsite2[j][k],FI_constlen[j][k]);
			}
			printf("CONSTRAINTS %d read: %d\n",FI_CONST[j],count1);
			break;
		}
		case _FI_PMF_IDX:
		{
			FI_PMF[j]=read_linedouble(2);
			i=nextfilerecord(infp);
			i=test_filelinestring(1,"pmf unit\0","IOERROR:",
					_inputfn,1);
			FI_PMF1[j]=read_lineint(2);
			FI_pmf1site[j]=allocate_int(FI_PMF1[j],
				_FIELDIN_VERSION,"FI_pmf1site[j]\0",3);
			FI_pmf1weight[j]=allocate_double(FI_PMF1[j],
				_FIELDIN_VERSION,"FI_pmf1weight[j]\0",3);
			for(k=0;k<FI_PMF1[j];k++)
			{
				i=nextfilerecord(infp);
				FI_pmf1site[j][k]=read_lineint(1);
				FI_pmf1weight[j][k]=read_linedouble(2);
			}
			i=nextfilerecord(infp);
			i=test_filelinestring(1,"pmf unit\0","IOERROR:",
					_inputfn,1);
			FI_PMF2[j]=read_lineint(2);
			FI_pmf2site[j]=allocate_int(FI_PMF2[j],
				_FIELDIN_VERSION,"FI_pmf2site[j]\0",3);
			FI_pmf2weight[j]=allocate_double(FI_PMF2[j],
				_FIELDIN_VERSION,"FI_pmf2weight[j]\0",3);
			for(k=0;k<FI_PMF2[j];k++)
			{
				i=nextfilerecord(infp);
				FI_pmf2site[j][k]=read_lineint(1);
				FI_pmf2weight[j][k]=read_linedouble(2);
			}
			printf("PMF %f\n",FI_PMF[j]);
			break;
		}
		case _FI_ANG_IDX:
		{
			FI_ANG[j]=read_lineint(2);
			FI_angkey[j]=allocate_string2(FI_ANG[j],
				_SYSUTIL_TSTRING_LEN_S,_FIELDIN_VERSION,
				"FI_angkey[j]\0",3);
			FI_angsite1[j]=allocate_int(FI_ANG[j],
				_FIELDIN_VERSION,"FI_angsite1[j]\0",3);
			FI_angsite2[j]=allocate_int(FI_ANG[j],
				_FIELDIN_VERSION,"FI_angsite2[j]\0",3);
			FI_angsite3[j]=allocate_int(FI_ANG[j],
				_FIELDIN_VERSION,"FI_angsite3[j]\0",3);
			FI_angforce[j]=allocate_double2(FI_ANG[j],
				_FI_ANG_FORCE,_FIELDIN_VERSION,
				"FI_angforce[j]\0",3);
			for(k=0;k<FI_ANG[j];k++)
			{
				i=nextfilerecord(infp);
				i=read_linestring(FI_angkey[j][k],1);
				FI_angsite1[j][k]=read_lineint(2);
				FI_angsite2[j][k]=read_lineint(3);
				FI_angsite3[j][k]=read_lineint(4);
//printf("ANG %s %d %d %d ",FI_angkey[j][k],FI_angsite1[j][k],FI_angsite2[j][k],FI_angsite3[j][k]);
				for(l=0;l<_FI_ANG_FORCE;l++)
				{
				  FI_angforce[j][k][l]=read_linedouble(5+l);
//printf("%f ",FI_angforce[j][k][l]);
				}
//printf("\n");
				count1=count1+1;
			}
			printf("ANGLES %d read: %d\n",FI_ANG[j],count1);
			break;
		}
		case _FI_DIH_IDX:
		{
			FI_DIH[j]=read_lineint(2);
			FI_dihkey[j]=allocate_string2(FI_DIH[j],
				_SYSUTIL_TSTRING_LEN_S,_FIELDIN_VERSION,
				"FI_dihkey[j]\0",3);
			FI_dihsite1[j]=allocate_int(FI_DIH[j],
				_FIELDIN_VERSION,"FI_dihsite1[j]\0",3);
			FI_dihsite2[j]=allocate_int(FI_DIH[j],
				_FIELDIN_VERSION,"FI_dihsite2[j]\0",3);
			FI_dihsite3[j]=allocate_int(FI_DIH[j],
				_FIELDIN_VERSION,"FI_dihsite3[j]\0",3);
			FI_dihsite4[j]=allocate_int(FI_DIH[j],
				_FIELDIN_VERSION,"FI_dihsite4[j]\0",3);
			FI_dihforce[j]=allocate_double2(FI_DIH[j],
				_FI_DIH_FORCE,_FIELDIN_VERSION,
				"FI_dihforce[j]\0",3);
			for(k=0;k<FI_DIH[j];k++)
			{
				i=nextfilerecord(infp);
				i=read_linestring(FI_dihkey[j][k],1);
				FI_dihsite1[j][k]=read_lineint(2);
				FI_dihsite2[j][k]=read_lineint(3);
				FI_dihsite3[j][k]=read_lineint(4);
				FI_dihsite4[j][k]=read_lineint(5);
//printf("DIH %s %d %d %d %d ",FI_dihkey[j][k],FI_dihsite1[j][k],FI_dihsite2[j][k],FI_dihsite3[j][k],FI_dihsite4[j][k]);
				i=test_string(1,"sylv\0");
				if(i==0)
				{
				  FI_dihforce[j][k][0]=read_linedouble(6);
				  FI_dihforce[j][k][1]=read_linedouble(7);
//printf("%f %f\n",FI_dihforce[j][k][0],FI_dihforce[j][k][1]);
				  i=nextfilerecord(infp);
				  for(l=0;l<_FI_DIH_FORCE-2;l++)
				  {
				    FI_dihforce[j][k][l]=read_linedouble(l+1);
//printf("%f ",FI_dihforce[j][k][l]);
				  }
				}
				else
				{
				  for(l=0;l<_FI_DIH_FORCE;l++)
				  {
				    FI_dihforce[j][k][l]=read_linedouble(6+l);
//printf("%f ",FI_dihforce[j][k][l]);
				  }
				}
//printf("\n");
				count1=count1+1;
			}
			printf("DIHEDRALS %d read: %d\n",FI_DIH[j],count1);
			break;
		}
		case _FI_INV_IDX:
		{
			FI_INV[j]=read_lineint(2);
			FI_invkey[j]=allocate_string2(FI_INV[j],
				_SYSUTIL_TSTRING_LEN_S,_FIELDIN_VERSION,
				"FI_invkey[j]\0",3);
			FI_invsite1[j]=allocate_int(FI_INV[j],
				_FIELDIN_VERSION,"FI_invsite1[j]\0",3);
			FI_invsite2[j]=allocate_int(FI_INV[j],
				_FIELDIN_VERSION,"FI_invsite2[j]\0",3);
			FI_invsite3[j]=allocate_int(FI_INV[j],
				_FIELDIN_VERSION,"FI_invsite3[j]\0",3);
			FI_invsite4[j]=allocate_int(FI_INV[j],
				_FIELDIN_VERSION,"FI_invsite4[j]\0",3);
			FI_invforce[j]=allocate_double2(FI_INV[j],
				_FI_INV_FORCE,_FIELDIN_VERSION,
				"FI_invforce[j]\0",3);
			for(k=0;k<FI_INV[j];k++)
			{
				i=nextfilerecord(infp);
				i=read_linestring(FI_invkey[j][k],1);
				FI_invsite1[j][k]=read_lineint(2);
				FI_invsite2[j][k]=read_lineint(3);
				FI_invsite3[j][k]=read_lineint(4);
				FI_invsite4[j][k]=read_lineint(5);
				for(l=0;l<_FI_INV_FORCE;l++)
				  FI_invforce[j][k][l]=read_linedouble(6+l);
				count1=count1+1;
			}
			printf("INVERSIONS %d %d\n",FI_INV[j],count1);
			break;
		}
		case _FI_RIG_IDX:
		{
			FI_RIG[j]=read_lineint(2);
			FI_rigidnr[j]=allocate_int(FI_RIG[j],_FIELDIN_VERSION,
					"FI_rigidnr[j]\0",3);
			FI_rigidsite[j]=allocate_2int(FI_RIG[j],
					_FIELDIN_VERSION,"FI_rigidsite[j]\0",3);
			for(k=0;k<FI_RIG[j];k++)
			{
				i=nextfilerecord(infp);
				FI_rigidnr[j][k]=read_lineint(1);
				FI_rigidsite[j][k]=allocate_int(
					FI_rigidnr[j][k],_FIELDIN_VERSION,
					"FI_rigidsite[j]\0",3);
				for(l=0;l<FI_rigidnr[j][k];l++)
				  FI_rigidsite[j][k][l]=read_lineint(2+l);
				count1=count1+1;
			}
			printf("RIGID %d read: %d\n",FI_RIG[j],count1);
			break;
		}
		case _FI_TETH_IDX:
		{
			FI_TETH[j]=read_lineint(2);
			FI_tethkey[j]=allocate_string2(FI_TETH[j],
				_SYSUTIL_TSTRING_LEN_S,_FIELDIN_VERSION,
				"FI_tethkey[j]\0",3);
			FI_tethsite[j]=allocate_int(FI_TETH[j],
				_FIELDIN_VERSION,"FI_tethsite[j]\0",3);
			FI_tethforce[j]=allocate_double2(FI_TETH[j],
				_FI_TETH_FORCE,_FIELDIN_VERSION,
				"FI_tethforce[j]\0",3);
			for(k=0;k<FI_TETH[j];k++)
			{
				i=nextfilerecord(infp);
				i=read_linestring(FI_tethkey[j][k],1);
				FI_tethsite[j][k]=read_lineint(2);
				for(l=0;l<_FI_TETH_FORCE;l++)
				  FI_tethforce[j][k][l]=read_linedouble(3+l);
				count1=count1+1;
			}
			printf("TETH %d read: %d\n",FI_TETH[j],count1);
			break;
		}
		default:
		{
			count=_FI_FINISH_IDX;
			break;
		}
	}//switch end
}//while end


}//MOLECULES loop end





};

//========================================
//========== Destructor FIELDIN ==========
//========================================

FIELDIN::~FIELDIN()
{

int i,j;//,k;

for(i=0;i<FI_MOLECULES;i++)
{
	delete FI_MOLHEADER[i];
	
	for(j=0;j<FI_ATOMTYPES[i];j++) delete FI_label[i][j];
	delete FI_label[i];
	delete FI_weight[i];
	delete FI_charge[i];
	delete FI_repeat[i];
	delete FI_ifrz[i];
	delete FI_igrp[i];

	delete FI_shellsite1[i];
	delete FI_shellsite2[i];
	delete FI_shellspring[i];
	
	for(j=0;j<FI_BONDS[i];j++)
	{
		delete FI_bondkey[i][j];
		delete FI_bondforce[i][j];
	}
	delete FI_bondkey[i];
	delete FI_bondsite1[i];
	delete FI_bondsite2[i];
	delete FI_bondforce[i];
	
	delete FI_constsite1[i];
	delete FI_constsite2[i];
	delete FI_constlen[i];
	
	delete FI_pmf1site[i];
	delete FI_pmf2site[i];
	delete FI_pmf1weight[i];
	delete FI_pmf1weight[i];	
	
	for(j=0;j<FI_ANG[i];j++)
	{
		delete FI_angkey[i][j];
		delete FI_angforce[i][j];
	}
	delete FI_angkey[i];
	delete FI_angsite1[i];
	delete FI_angsite2[i];
	delete FI_angsite3[i];
	delete FI_angforce[i];
	
	for(j=0;j<FI_DIH[i];j++)
	{
		delete FI_dihkey[i][j];
		delete FI_dihforce[i][j];
	}
	delete FI_dihkey[i];
	delete FI_dihsite1[i];
	delete FI_dihsite2[i];
	delete FI_dihsite3[i];
	delete FI_dihsite4[i];
	delete FI_dihforce[i];
	
	for(j=0;j<FI_INV[i];j++)
	{
		delete FI_invkey[i][j];
		delete FI_invforce[i][j];
	}
	delete FI_invkey[i];
	delete FI_invsite1[i];
	delete FI_invsite2[i];
	delete FI_invsite3[i];
	delete FI_invsite4[i];
	delete FI_invforce[i];
	
	for(j=0;j<FI_RIG[i];j++)
	{
		delete FI_rigidsite[i][j];
	}
	delete FI_rigidnr;
	delete FI_rigidsite[i];
	
	for(j=0;j<FI_TETH[i];j++)
	{
		delete FI_tethkey[i][j];
		delete FI_tethforce[i][j];
	}
	delete FI_tethkey[i];
	delete FI_tethsite[i];
	delete FI_tethforce[i];

}//MOLEUCLES end

delete FI_MOLHEADER;
delete FI_NUMMOLS;
delete FI_ATOMS;
delete FI_ATOMTYPES;

delete FI_label;
delete FI_weight;
delete FI_charge;
delete FI_repeat;
delete FI_ifrz;
delete FI_igrp;

delete FI_SHELL;
delete FI_BONDS;
delete FI_CONST;
delete FI_PMF;
delete FI_PMF1;
delete FI_PMF2;
delete FI_ANG;
delete FI_DIH;
delete FI_INV;
delete FI_RIG;
delete FI_TETH;

delete FI_shellsite1;
delete FI_shellsite2;
delete FI_shellspring;

delete FI_bondkey;
delete FI_bondsite1;
delete FI_bondsite2;
delete FI_bondforce;

delete FI_constsite1;
delete FI_constsite2;
delete FI_constlen;

delete FI_pmf1site;
delete FI_pmf2site;
delete FI_pmf1weight;
delete FI_pmf1weight;

delete FI_angkey;
delete FI_angsite1;
delete FI_angsite2;
delete FI_angsite3;
delete FI_angforce;

delete FI_dihkey;
delete FI_dihsite1;
delete FI_dihsite2;
delete FI_dihsite3;
delete FI_dihsite4;
delete FI_dihforce;

delete FI_invkey;
delete FI_invsite1;
delete FI_invsite2;
delete FI_invsite3;
delete FI_invsite4;
delete FI_invforce;

delete FI_rigidnr;
delete FI_rigidsite;

delete FI_tethkey;
delete FI_tethsite;
delete FI_tethforce;

printf("%s finished...\n",_FIELDIN_VERSION);

};

//==============================================
//========== Method FI_retr_molecules ==========
//==============================================

int FIELDIN::FI_retr_molecules()
{

return FI_MOLECULES;

};

//============================================
//========== Method FI_retr_nummols ==========
//============================================

int FIELDIN::FI_retr_nummols(int _molecule)
{

return FI_NUMMOLS[_molecule];

};

//==========================================
//========== Method FI_retr_atoms ==========
//==========================================

int FIELDIN::FI_retr_atoms(int _molecule)
{

return FI_ATOMS[_molecule];

};

//===========================================
//========== Method FI_retr_angles ==========
//===========================================

int FIELDIN::FI_retr_angles(int _molecule)
{

return FI_ANG[_molecule];

};

//=================================================
//========== Method FI_retr_angsite1indx ==========
//=================================================

int FIELDIN::FI_retr_angsite1indx(int _molecule,int _anglenr)
{

int i,count=0,indx;

for(i=0;i<_molecule;i++)
	count=count+FI_NUMMOLS[_molecule]*FI_ATOMS[_molecule];

indx=count+FI_angsite1[_molecule][_anglenr];

return indx;

};

//=================================================
//========== Method FI_retr_angsite2indx ==========
//=================================================

int FIELDIN::FI_retr_angsite2indx(int _molecule,int _anglenr)
{

int i,count=0,indx;

for(i=0;i<_molecule;i++)
	count=count+FI_NUMMOLS[_molecule]*FI_ATOMS[_molecule];

indx=count+FI_angsite2[_molecule][_anglenr];

return indx;

};

//=================================================
//========== Method FI_retr_angsite3indx ==========
//=================================================

int FIELDIN::FI_retr_angsite3indx(int _molecule,int _anglenr)
{

int i,count=0,indx;

for(i=0;i<_molecule;i++)
	count=count+FI_NUMMOLS[_molecule]*FI_ATOMS[_molecule];

indx=count+FI_angsite3[_molecule][_anglenr];

return indx;

};

//==================================================
//========== Method FI_retr_angsite1label ==========
//==================================================

int FIELDIN::FI_retr_angsite1label(int _molecule,int _anglenr,char *_label)
{

int indx,i=0,count=0;

indx=FI_angsite1[_molecule][_anglenr];

while(count<indx)
{
	count=count+FI_repeat[_molecule][i];
	i=i+1;
}

indx=i-1;

strcpy(_label,FI_label[_molecule][indx]);

return indx;

};

//==================================================
//========== Method FI_retr_angsite2label ==========
//==================================================

int FIELDIN::FI_retr_angsite2label(int _molecule,int _anglenr,char *_label)
{

int indx,i=0,count=0;

indx=FI_angsite2[_molecule][_anglenr];

while(count<indx)
{
	count=count+FI_repeat[_molecule][i];
	i=i+1;
}

indx=i-1;

strcpy(_label,FI_label[_molecule][indx]);

return indx;

};

//==================================================
//========== Method FI_retr_angsite3label ==========
//==================================================

int FIELDIN::FI_retr_angsite3label(int _molecule,int _anglenr,char *_label)
{

int indx,i=0,count=0;

indx=FI_angsite3[_molecule][_anglenr];

while(count<indx)
{
	count=count+FI_repeat[_molecule][i];
	i=i+1;
}

indx=i-1;

strcpy(_label,FI_label[_molecule][indx]);

return indx;

};

//==============================================
//========== Method FI_retr_dihedrals ==========
//==============================================

int FIELDIN::FI_retr_dihedrals(int _molecule)
{

return FI_DIH[_molecule];

};


//=================================================
//========== Method FI_retr_dihsite1indx ==========
//=================================================

int FIELDIN::FI_retr_dihsite1indx(int _molecule,int _danglenr)
{

int i,count=0,indx;

for(i=0;i<_molecule;i++)
	count=count+FI_NUMMOLS[_molecule]*FI_ATOMS[_molecule];

indx=count+FI_dihsite1[_molecule][_danglenr];

return indx;

};

//=================================================
//========== Method FI_retr_dihsite2indx ==========
//=================================================

int FIELDIN::FI_retr_dihsite2indx(int _molecule,int _danglenr)
{

int i,count=0,indx;

for(i=0;i<_molecule;i++)
	count=count+FI_NUMMOLS[_molecule]*FI_ATOMS[_molecule];

indx=count+FI_dihsite2[_molecule][_danglenr];

return indx;

};

//=================================================
//========== Method FI_retr_dihsite3indx ==========
//=================================================

int FIELDIN::FI_retr_dihsite3indx(int _molecule,int _danglenr)
{

int i,count=0,indx;

for(i=0;i<_molecule;i++)
	count=count+FI_NUMMOLS[_molecule]*FI_ATOMS[_molecule];

indx=count+FI_dihsite3[_molecule][_danglenr];

return indx;

};

//=================================================
//========== Method FI_retr_dihsite4indx ==========
//=================================================

int FIELDIN::FI_retr_dihsite4indx(int _molecule,int _danglenr)
{

int i,count=0,indx;

for(i=0;i<_molecule;i++)
	count=count+FI_NUMMOLS[_molecule]*FI_ATOMS[_molecule];

indx=count+FI_dihsite4[_molecule][_danglenr];

return indx;

};

//==================================================
//========== Method FI_retr_dihsite1label ==========
//==================================================

int FIELDIN::FI_retr_dihsite1label(int _molecule,int _danglenr,char *_label)
{

int indx,i=0,count=0;

indx=FI_dihsite1[_molecule][_danglenr];

while(count<indx)
{
	count=count+FI_repeat[_molecule][i];
	i=i+1;
}

indx=i-1;

strcpy(_label,FI_label[_molecule][indx]);

return indx;

};

//==================================================
//========== Method FI_retr_dihsite2label ==========
//==================================================

int FIELDIN::FI_retr_dihsite2label(int _molecule,int _danglenr,char *_label)
{

int indx,i=0,count=0;

indx=FI_dihsite2[_molecule][_danglenr];

printf("S1 indx: %d\n",indx);

while(count<indx)
{
	count=count+FI_repeat[_molecule][i];
	printf("S2 count %d i %d\n",count,i);
	i=i+1;
}

indx=i-1;

strcpy(_label,FI_label[_molecule][indx]);

return indx;

};

//==================================================
//========== Method FI_retr_dihsite3label ==========
//==================================================

int FIELDIN::FI_retr_dihsite3label(int _molecule,int _danglenr,char *_label)
{

int indx,i=0,count=0;

indx=FI_dihsite3[_molecule][_danglenr];

while(count<indx)
{
	count=count+FI_repeat[_molecule][i];
	i=i+1;
}

indx=i-1;

strcpy(_label,FI_label[_molecule][indx]);

return indx;

};

//==================================================
//========== Method FI_retr_dihsite4label ==========
//==================================================

int FIELDIN::FI_retr_dihsite4label(int _molecule,int _danglenr,char *_label)
{

int indx,i=0,count=0;

indx=FI_dihsite4[_molecule][_danglenr];

while(count<indx)
{
	count=count+FI_repeat[_molecule][i];
	i=i+1;
}

indx=i-1;

strcpy(_label,FI_label[_molecule][indx]);

return indx;

};


//===========================================
//========== Method FI_retr_rigids ==========
//===========================================

int FIELDIN::FI_retr_rigids(const int _molecule)
{

return FI_RIG[_molecule];

};

//================================================
//========== method FI_retr_rigid_sites ==========
//================================================

vector <int> FIELDIN::FI_retr_rigid_sites(const int _molecule,
						const int _rigidnr)
{

vector <int> outRigids;
int i;

outRigids.clear();

for(i=0;i<FI_rigidnr[_molecule][_rigidnr];i++)
	outRigids.push_back(FI_rigidsite[_molecule][_rigidnr][i]);

return outRigids;
};

//============================================
//========== method FI_retr_rigidnr ==========
//============================================

int FIELDIN::FI_find_rigidnr(const int _molecule,const int _atomIndex)
{

int i,j,rigidNr=-1;

for(i=0;i<FI_RIG[_molecule];i++)
{
	for(j=0;j<FI_rigidnr[_molecule][i];j++)
	{
		if(_atomIndex==FI_rigidsite[_molecule][i][j])
			rigidNr=i;
			
	}

}

return rigidNr;
};

//================================================
//========== method FI_find_rigid_sites ==========
//================================================

vector <int> FIELDIN::FI_find_rigid_sites(const int _molecule,
		const int _atomIndex)
{

vector <int> outRigids;
int rigidNr;

outRigids.clear();

rigidNr=FI_find_rigidnr(_molecule,_atomIndex);

if(rigidNr!=-1)
	outRigids=FI_retr_rigid_sites(_molecule,rigidNr);

return outRigids;
};




